/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerEvaluateActionHandler;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.frame.XWatchesViewImpl;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class XAddToWatchesFromEditorActionHandler
extends XDebuggerActionHandler {
    @Override
    protected boolean isEnabled(@NotNull XDebugSession session2, DataContext dataContext) {
        Promise<String> textPromise = XAddToWatchesFromEditorActionHandler.getTextToEvaluate(dataContext, session2);
        if (textPromise.getState() == Promise.State.PENDING) {
            return true;
        }
        if (textPromise.getState() == Promise.State.REJECTED) {
            return false;
        }
        try {
            return textPromise.blockingGet(0) != null;
        }
        catch (ExecutionException | TimeoutException e) {
            return false;
        }
    }

    @NotNull
    protected static Promise<String> getTextToEvaluate(DataContext dataContext, XDebugSession session2) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return Promises.resolvedPromise(null);
        }
        String text = editor.getSelectionModel().getSelectedText();
        if (text != null) {
            return Promises.resolvedPromise((Object)StringUtil.nullize((String)text, (boolean)true));
        }
        XDebuggerEvaluator evaluator = session2.getDebugProcess().getEvaluator();
        if (evaluator != null) {
            return XDebuggerEvaluateActionHandler.getExpressionText(evaluator, editor.getProject(), editor).then(s -> StringUtil.nullize((String)s, (boolean)true));
        }
        return Promises.resolvedPromise(null);
    }

    @Override
    protected void perform(@NotNull XDebugSession session2, DataContext dataContext) {
        XAddToWatchesFromEditorActionHandler.getTextToEvaluate(dataContext, session2).onSuccess(text -> {
            if (text == null) {
                return;
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                XDebugSessionTab tab = ((XDebugSessionImpl)session2).getSessionTab();
                if (tab != null) {
                    ((XWatchesViewImpl)tab.getWatchesView()).addWatchExpression(XExpressionImpl.fromText(text), -1, true, true);
                }
            });
        });
    }
}

