/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.Range;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ToggleBreakpointEnabledAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Set<XLineBreakpoint> breakpoints = ToggleBreakpointEnabledAction.findLineBreakpoints(e);
        Iterator iterator2 = breakpoints.iterator();
        while (iterator2.hasNext()) {
            XLineBreakpoint breakpoint;
            breakpoint.setEnabled(!(breakpoint = (XLineBreakpoint)iterator2.next()).isEnabled());
        }
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabled(!ToggleBreakpointEnabledAction.findLineBreakpoints(e).isEmpty());
    }

    @NotNull
    private static Set<XLineBreakpoint> findLineBreakpoints(AnActionEvent e) {
        Project project = e.getProject();
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (project == null || editor == null) {
            return Collections.emptySet();
        }
        XBreakpointManagerImpl breakpointManager = (XBreakpointManagerImpl)XDebuggerManager.getInstance((Project)project).getBreakpointManager();
        XLineBreakpointManager lineBreakpointManager = breakpointManager.getLineBreakpointManager();
        Document document = editor.getDocument();
        ArrayList<Range> lineRanges = new ArrayList<Range>();
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            lineRanges.add(new Range((Comparable)Integer.valueOf(document.getLineNumber(caret.getSelectionStart())), (Comparable)Integer.valueOf(document.getLineNumber(caret.getSelectionEnd()))));
        }
        Collection<XLineBreakpointImpl> breakpoints = lineBreakpointManager.getDocumentBreakpoints(document);
        HashSet<XLineBreakpoint> res2 = new HashSet<XLineBreakpoint>();
        for (XLineBreakpointImpl breakpoint : breakpoints) {
            int line = breakpoint.getLine();
            for (Range range2 : lineRanges) {
                if (!range2.isWithin((Comparable)Integer.valueOf(line))) continue;
                res2.add(breakpoint);
            }
        }
        return res2;
    }
}

