/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.XDebuggerActionBase;
import org.jetbrains.annotations.NotNull;

public class EditBreakpointAction
extends XDebuggerActionBase
implements DumbAware {
    @Override
    @NotNull
    protected DebuggerActionHandler getHandler(@NotNull DebuggerSupport debuggerSupport) {
        return debuggerSupport.getEditBreakpointAction();
    }

    public static class ContextAction
    extends DumbAwareAction {
        private final GutterIconRenderer myRenderer;
        private final Object myBreakpoint;
        private final DebuggerSupport myDebuggerSupport;

        public ContextAction(GutterIconRenderer breakpointRenderer, Object breakpoint, DebuggerSupport debuggerSupport) {
            super(ActionsBundle.actionText((String)"EditBreakpoint"));
            this.myRenderer = breakpointRenderer;
            this.myBreakpoint = breakpoint;
            this.myDebuggerSupport = debuggerSupport;
            AnAction action2 = ActionManager.getInstance().getAction("ViewBreakpoints");
            this.copyShortcutFrom(action2);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            Project project = ContextAction.getEventProject((AnActionEvent)e);
            if (editor == null || project == null) {
                return;
            }
            this.myDebuggerSupport.getEditBreakpointAction().editBreakpoint(project, editor, this.myBreakpoint, this.myRenderer);
        }
    }
}

