/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.legacyBridge.module;

import com.google.common.collect.HashBiMap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.module.impl.ModulePathKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.projectModel.ProjectModelBundle;
import com.intellij.util.PathUtil;
import com.intellij.workspaceModel.ide.NonPersistentEntitySource;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerServiceKt;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsProjectEntitiesLoader;
import com.intellij.workspaceModel.ide.impl.legacyBridge.LegacyBridgeModifiableBase;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleBridgeImpl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleManagerComponentBridge;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.VirtualFileUrlManager;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import com.intellij.workspaceModel.storage.bridgeEntities.BridgeModelModifiableEntitiesKt;
import com.intellij.workspaceModel.storage.bridgeEntities.ModifiableModuleEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModifiableModuleGroupPathEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleDependencyItem;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleGroupPathEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0016\u001a\u00020\bJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\fH\u0016J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u000e2\u0006\u0010!\u001a\u00020\fH\u0002J\u001d\u0010\"\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010#2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a2\u0006\u0002\u0010$J\u0012\u0010%\u001a\u0004\u0018\u00010\u001c2\u0006\u0010&\u001a\u00020\fH\u0016J\u0013\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001c0#H\u0016\u00a2\u0006\u0002\u0010(J\u0012\u0010)\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010*\u001a\u00020\u0004H\u0016J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020,H\u0016J\u0010\u0010.\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\fH\u0016J\u0018\u0010/\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\f2\u0006\u00100\u001a\u00020\fH\u0016J.\u0010/\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\f2\u0006\u00100\u001a\u00020\f2\u0014\u00101\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0018\u000102H\u0016J\u0018\u00103\u001a\u00020\u001c2\u0006\u00104\u001a\u00020\f2\u0006\u00100\u001a\u00020\fH\u0016J\u0010\u00105\u001a\u00020\u00182\u0006\u00104\u001a\u00020\fH\u0002J\u0018\u00106\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\fH\u0016J'\u00107\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0010\u00108\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010#H\u0016\u00a2\u0006\u0002\u00109R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\n\u001aB\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \r*\u0004\u0018\u00010\u000e0\u000e \r* \u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \r*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u000f\u001aB\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \r*\u0004\u0018\u00010\u000e0\u000e \r* \u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \r*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0010\u001aB\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \r*\u0004\u0018\u00010\u000e0\u000e \r* \u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \r*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\u0012j\b\u0012\u0004\u0012\u00020\u000e`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModifiableModuleModelBridge;", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/LegacyBridgeModifiableBase;", "Lcom/intellij/openapi/module/ModifiableModuleModel;", "project", "Lcom/intellij/openapi/project/Project;", "moduleManager", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleManagerComponentBridge;", "diff", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorageBuilder;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleManagerComponentBridge;Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorageBuilder;)V", "myModulesToAdd", "Lcom/google/common/collect/HashBiMap;", "", "kotlin.jvm.PlatformType", "Lcom/intellij/workspaceModel/ide/legacyBridge/ModuleBridge;", "myModulesToDispose", "myNewNameToModule", "myUncommittedModulesToDispose", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "virtualFileManager", "Lcom/intellij/workspaceModel/storage/VirtualFileUrlManager;", "collectChanges", "commit", "", "dispose", "disposeModule", "module", "Lcom/intellij/openapi/module/Module;", "findModuleByName", "name", "getActualName", "getModuleByFilePath", "filePath", "getModuleGroupPath", "", "(Lcom/intellij/openapi/module/Module;)[Ljava/lang/String;", "getModuleToBeRenamed", "newName", "getModules", "()[Lcom/intellij/openapi/module/Module;", "getNewName", "getProject", "hasModuleGroups", "", "isChanged", "loadModule", "newModule", "moduleTypeId", "options", "", "newNonPersistentModule", "moduleName", "removeUnloadedModule", "renameModule", "setModuleGroupPath", "groupPath", "(Lcom/intellij/openapi/module/Module;[Ljava/lang/String;)V", "intellij.platform.workspaceModel.ide"})
public final class ModifiableModuleModelBridge
extends LegacyBridgeModifiableBase
implements ModifiableModuleModel {
    private final HashBiMap<String, ModuleBridge> myModulesToAdd;
    private final HashBiMap<String, ModuleBridge> myModulesToDispose;
    private final ArrayList<ModuleBridge> myUncommittedModulesToDispose;
    private final HashBiMap<String, ModuleBridge> myNewNameToModule;
    private final VirtualFileUrlManager virtualFileManager;
    private final Project project;
    private final ModuleManagerComponentBridge moduleManager;

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public Module[] getModules() {
        List modules2 = ArraysKt.toMutableList((Object[])this.moduleManager.getModules());
        modules2.removeAll(this.myModulesToDispose.values());
        modules2.addAll(this.myModulesToAdd.values());
        Collection $this$toTypedArray$iv = modules2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Module[] moduleArray = thisCollection$iv.toArray(new Module[0]);
        if (moduleArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return moduleArray;
    }

    @NotNull
    public Module newModule(@NotNull String filePath, @NotNull String moduleTypeId) {
        return this.newModule(filePath, moduleTypeId, null);
    }

    @NotNull
    public Module newNonPersistentModule(@NotNull String moduleName, @NotNull String moduleTypeId) {
        ModuleEntity moduleEntity = BridgeModelModifiableEntitiesKt.addModuleEntity$default(this.getDiff$intellij_platform_workspaceModel_ide(), moduleName, CollectionsKt.listOf((Object)ModuleDependencyItem.ModuleSourceDependency.INSTANCE), NonPersistentEntitySource.INSTANCE, null, 8, null);
        ModuleBridgeImpl module = new ModuleBridgeImpl(moduleEntity.persistentId(), moduleName, this.project, null, this.getEntityStorageOnDiff$intellij_platform_workspaceModel_ide(), this.getDiff$intellij_platform_workspaceModel_ide());
        ModuleManagerComponentBridge.Companion.getMutableModuleMap$intellij_platform_workspaceModel_ide(this.getDiff$intellij_platform_workspaceModel_ide()).addMapping(moduleEntity, module);
        ((Map)this.myModulesToAdd).put(moduleName, module);
        module.init(null);
        module.setModuleType(moduleTypeId);
        return module;
    }

    @NotNull
    public Module newModule(@NotNull String filePath, @NotNull String moduleTypeId, @Nullable Map<String, String> options2) {
        EntitySource entitySource;
        String canonicalPath = FileUtil.toSystemIndependentName((String)FileUtil.resolveShortWindowsName((String)filePath));
        ModuleBridge existingModule = this.getModuleByFilePath(canonicalPath);
        if (existingModule != null) {
            return existingModule;
        }
        String moduleName = ModulePathKt.getModuleNameByFilePath(canonicalPath);
        if (this.findModuleByName(moduleName) != null) {
            throw (Throwable)new ModuleWithNameAlreadyExists("Module already exists: " + moduleName, moduleName);
        }
        this.removeUnloadedModule(moduleName);
        EntitySource entitySource2 = entitySource = JpsProjectEntitiesLoader.INSTANCE.createEntitySourceForModule(this.project, this.virtualFileManager.fromPath(PathUtil.getParentPath((String)canonicalPath)), null);
        String string = moduleTypeId;
        ModuleEntity moduleEntity = BridgeModelModifiableEntitiesKt.addModuleEntity(this.getDiff$intellij_platform_workspaceModel_ide(), moduleName, CollectionsKt.listOf((Object)ModuleDependencyItem.ModuleSourceDependency.INSTANCE), entitySource2, string);
        ModuleBridge moduleInstance = this.moduleManager.createModuleInstance(moduleEntity, this.getEntityStorageOnDiff$intellij_platform_workspaceModel_ide(), this.getDiff$intellij_platform_workspaceModel_ide(), true);
        ModuleManagerComponentBridge.Companion.getMutableModuleMap$intellij_platform_workspaceModel_ide(this.getDiff$intellij_platform_workspaceModel_ide()).addMapping(moduleEntity, moduleInstance);
        ((Map)this.myModulesToAdd).put(moduleName, moduleInstance);
        return moduleInstance;
    }

    private final ModuleBridge getModuleByFilePath(String filePath) {
        for (Module module : this.getModules()) {
            boolean bl;
            boolean bl2 = SystemInfo.isFileSystemCaseSensitive;
            if (bl2) {
                bl = Intrinsics.areEqual((Object)module.getModuleFilePath(), (Object)filePath);
            } else if (!bl2) {
                bl = StringsKt.equals((String)module.getModuleFilePath(), (String)filePath, (boolean)true);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            boolean sameFilePath = bl;
            if (!sameFilePath) continue;
            Module module2 = module;
            if (module2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge");
            }
            return (ModuleBridge)module2;
        }
        return null;
    }

    private final void removeUnloadedModule(String moduleName) {
        UnloadedModuleDescription unloadedModuleDescription = this.moduleManager.getUnloadedModuleDescription(moduleName);
        if (unloadedModuleDescription != null) {
            ModuleEntity moduleEntity = (ModuleEntity)this.getEntityStorageOnDiff$intellij_platform_workspaceModel_ide().getCurrent().resolve(new ModuleId(unloadedModuleDescription.getName()));
            if (moduleEntity == null) {
                String string = "Could not find module to remove by id: " + unloadedModuleDescription.getName();
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            ModuleEntity moduleEntity2 = moduleEntity;
            this.getDiff$intellij_platform_workspaceModel_ide().removeEntity(moduleEntity2);
        }
    }

    @NotNull
    public Module loadModule(@NotNull String filePath) {
        return this.newModule(filePath, "");
    }

    public void disposeModule(@NotNull Module module) {
        if (Disposer.isDisposing((Disposable)((Disposable)module.getProject()))) {
            return;
        }
        Module module2 = module;
        if (module2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge");
        }
        ModuleBridge cfr_ignored_0 = (ModuleBridge)module2;
        if (this.findModuleByName(((ModuleBridge)module).getName()) == null) {
            String string = "Module '" + ((ModuleBridge)module).getName() + "' is not found. Probably it's already disposed.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (this.myModulesToAdd.inverse().remove((Object)module) != null) {
            this.myUncommittedModulesToDispose.add((ModuleBridge)module);
        }
        this.myNewNameToModule.inverse().remove((Object)module);
        ((Map)this.myModulesToDispose).put(((ModuleBridge)module).getName(), module);
    }

    @Nullable
    public Module findModuleByName(@NotNull String name) {
        ModuleBridge addedModule = (ModuleBridge)this.myModulesToAdd.get((Object)name);
        if (addedModule != null) {
            return addedModule;
        }
        if (this.myModulesToDispose.containsKey((Object)name)) {
            return null;
        }
        ModuleBridge newNameModule = (ModuleBridge)this.myNewNameToModule.get((Object)name);
        if (newNameModule != null) {
            return null;
        }
        return this.moduleManager.findModuleByName(name);
    }

    public void dispose() {
        this.assertModelIsLive$intellij_platform_workspaceModel_ide();
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.project);
        if (moduleManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleManagerComponentBridge");
        }
        ModuleManagerComponentBridge moduleManager2 = (ModuleManagerComponentBridge)moduleManager;
        for (ModuleBridge moduleToAdd : (Set)this.myModulesToAdd.values()) {
            Disposer.dispose((Disposable)((Disposable)moduleToAdd));
        }
        for (ModuleBridge module : this.myUncommittedModulesToDispose) {
            Disposer.dispose((Disposable)((Disposable)module));
        }
        this.myModulesToAdd.clear();
        this.myModulesToDispose.clear();
        this.myNewNameToModule.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isChanged() {
        Map map2 = (Map)this.myModulesToAdd;
        boolean bl = false;
        if (!map2.isEmpty()) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        map2 = (Map)this.myModulesToDispose;
        bl = false;
        if (!map2.isEmpty()) {
            return true;
        }
        boolean bl3 = false;
        if (bl3) return true;
        map2 = (Map)this.myNewNameToModule;
        bl = false;
        if (map2.isEmpty()) return false;
        return true;
    }

    public void commit() {
        WorkspaceEntityStorageBuilder diff = this.collectChanges();
        WorkspaceModel.Companion.getInstance(this.project).updateProjectModel((Function1)new Function1<WorkspaceEntityStorageBuilder, Map<WorkspaceEntity, ? extends WorkspaceEntity>>(diff){
            final /* synthetic */ WorkspaceEntityStorageBuilder $diff;

            @NotNull
            public final Map<WorkspaceEntity, WorkspaceEntity> invoke(@NotNull WorkspaceEntityStorageBuilder it) {
                return it.addDiff(this.$diff);
            }
            {
                this.$diff = workspaceEntityStorageBuilder;
                super(1);
            }
        });
    }

    @NotNull
    public final WorkspaceEntityStorageBuilder collectChanges() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        WorkspaceEntityStorage storage = this.getEntityStorageOnDiff$intellij_platform_workspaceModel_ide().getCurrent();
        for (ModuleBridge moduleToDispose : (Set)this.myModulesToDispose.values()) {
            ModuleEntity moduleEntity;
            if ((ModuleEntity)storage.resolve(moduleToDispose.getModuleEntityId()) == null) {
                String string = "Could not find module to remove by id: " + moduleToDispose.getModuleEntityId();
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.getDiff$intellij_platform_workspaceModel_ide().removeEntity(moduleEntity);
        }
        for (ModuleBridge module : this.myUncommittedModulesToDispose) {
            Disposer.dispose((Disposable)((Disposable)module));
        }
        return this.getDiff$intellij_platform_workspaceModel_ide();
    }

    public void renameModule(@NotNull Module module, @NotNull String newName) {
        Module module2 = module;
        if (module2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge");
        }
        ModuleBridge cfr_ignored_0 = (ModuleBridge)module2;
        Module oldModule = this.findModuleByName(newName);
        this.myNewNameToModule.inverse().remove((Object)module);
        this.myNewNameToModule.remove((Object)newName);
        this.removeUnloadedModule(newName);
        String oldName = ((ModuleBridge)module).getName();
        ModuleId oldId = ((ModuleBridge)module).getModuleEntityId();
        if (Intrinsics.areEqual((Object)oldName, (Object)newName) ^ true) {
            ModuleBridge moduleToAdd = (ModuleBridge)this.myModulesToAdd.remove((Object)oldName);
            if (moduleToAdd != null) {
                moduleToAdd.rename(newName, false);
                ((Map)this.myModulesToAdd).put(newName, moduleToAdd);
            } else {
                ((Map)this.myNewNameToModule).put(newName, module);
            }
            ModuleEntity moduleEntity = (ModuleEntity)this.getEntityStorageOnDiff$intellij_platform_workspaceModel_ide().getCurrent().resolve(oldId);
            if (moduleEntity == null) {
                String string = "Unable to resolve module by id: " + oldId;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            ModuleEntity entity = moduleEntity;
            this.getDiff$intellij_platform_workspaceModel_ide().modifyEntity(ModifiableModuleEntity.class, (WorkspaceEntity)entity, (Function1)new Function1<ModifiableModuleEntity, Unit>(newName){
                final /* synthetic */ String $newName;

                public final void invoke(@NotNull ModifiableModuleEntity $this$modifyEntity) {
                    $this$modifyEntity.setName(this.$newName);
                }
                {
                    this.$newName = string;
                    super(1);
                }
            });
        }
        if (oldModule != null) {
            throw (Throwable)new ModuleWithNameAlreadyExists(ProjectModelBundle.message((String)"module.already.exists.error", (Object[])new Object[]{newName}), newName);
        }
    }

    @Nullable
    public Module getModuleToBeRenamed(@NotNull String newName) {
        return (Module)this.myNewNameToModule.get((Object)newName);
    }

    @Nullable
    public String getNewName(@NotNull Module module) {
        Map map2 = (Map)this.myNewNameToModule.inverse();
        boolean bl = false;
        return (String)map2.get(module);
    }

    @NotNull
    public String getActualName(@NotNull Module module) {
        String string = this.getNewName(module);
        if (string == null) {
            string = module.getName();
        }
        return string;
    }

    @Nullable
    public String[] getModuleGroupPath(@NotNull Module module) {
        return ModuleManagerComponentBridge.Companion.getModuleGroupPath$intellij_platform_workspaceModel_ide(module, this.getEntityStorageOnDiff$intellij_platform_workspaceModel_ide());
    }

    public boolean hasModuleGroups() {
        return ModuleManagerComponentBridge.Companion.hasModuleGroups$intellij_platform_workspaceModel_ide(this.getEntityStorageOnDiff$intellij_platform_workspaceModel_ide());
    }

    public void setModuleGroupPath(@NotNull Module module, @Nullable String[] groupPath) {
        Module module2 = module;
        if (module2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge");
        }
        ModuleId moduleId = ((ModuleBridge)module2).getModuleEntityId();
        WorkspaceEntityStorage storage = this.getEntityStorageOnDiff$intellij_platform_workspaceModel_ide().getCurrent();
        ModuleEntity moduleEntity = (ModuleEntity)storage.resolve(moduleId);
        if (moduleEntity == null) {
            String string = "Could not resolve module by moduleId: " + moduleId;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ModuleEntity moduleEntity2 = moduleEntity;
        ModuleGroupPathEntity moduleGroupEntity = moduleEntity2.getGroupPath();
        List groupPathList = groupPath != null ? ArraysKt.toList((Object[])groupPath) : null;
        ModuleGroupPathEntity moduleGroupPathEntity = moduleGroupEntity;
        if (Intrinsics.areEqual(moduleGroupPathEntity != null ? moduleGroupPathEntity.getPath() : null, (Object)groupPathList) ^ true) {
            if (moduleGroupEntity == null && groupPathList != null) {
                EntitySource entitySource = moduleEntity2.getEntitySource();
                List list2 = groupPathList;
                ModuleEntity moduleEntity3 = moduleEntity2;
                BridgeModelModifiableEntitiesKt.addModuleGroupPathEntity(this.getDiff$intellij_platform_workspaceModel_ide(), list2, moduleEntity3, entitySource);
            } else if (moduleGroupEntity != null || groupPathList != null) {
                if (moduleGroupEntity != null && groupPathList == null) {
                    this.getDiff$intellij_platform_workspaceModel_ide().removeEntity(moduleGroupEntity);
                } else if (moduleGroupEntity != null && groupPathList != null) {
                    this.getDiff$intellij_platform_workspaceModel_ide().modifyEntity(ModifiableModuleGroupPathEntity.class, (WorkspaceEntity)moduleGroupEntity, (Function1)new Function1<ModifiableModuleGroupPathEntity, Unit>(groupPathList){
                        final /* synthetic */ List $groupPathList;

                        public final void invoke(@NotNull ModifiableModuleGroupPathEntity $this$modifyEntity) {
                            $this$modifyEntity.setPath(this.$groupPathList);
                        }
                        {
                            this.$groupPathList = list2;
                            super(1);
                        }
                    });
                } else {
                    String string = "Should not be reached";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            }
        }
    }

    public ModifiableModuleModelBridge(@NotNull Project project, @NotNull ModuleManagerComponentBridge moduleManager, @NotNull WorkspaceEntityStorageBuilder diff) {
        super(diff);
        this.project = project;
        this.moduleManager = moduleManager;
        this.myModulesToAdd = HashBiMap.create();
        this.myModulesToDispose = HashBiMap.create();
        this.myUncommittedModulesToDispose = new ArrayList();
        this.myNewNameToModule = HashBiMap.create();
        this.virtualFileManager = VirtualFileUrlManagerServiceKt.getInstance(VirtualFileUrlManager.Companion, this.project);
    }
}

