/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.jps.serialization;

import com.intellij.configurationStore.FileStorageAnnotation;
import com.intellij.configurationStore.StateAnnotation;
import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StateStorageBase;
import com.intellij.configurationStore.StreamProviderFactory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateSplitterEx;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import com.intellij.workspaceModel.ide.impl.jps.serialization.FakeDirectoryBasedStateSplitter;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u000b"}, d2={"getProjectStateStorage", "Lcom/intellij/configurationStore/StateStorageBase;", "Lcom/intellij/configurationStore/StateMap;", "filePath", "", "store", "Lcom/intellij/openapi/components/impl/stores/IProjectStore;", "project", "Lcom/intellij/openapi/project/Project;", "getStorageSpec", "Lcom/intellij/openapi/components/Storage;", "intellij.platform.workspaceModel.ide"})
public final class JpsProjectModelSynchronizerKt {
    @Nullable
    public static final StateStorageBase<StateMap> getProjectStateStorage(@NotNull String filePath, @NotNull IProjectStore store, @NotNull Project project) {
        Storage storage = JpsProjectModelSynchronizerKt.getStorageSpec(filePath, project);
        if (storage == null) {
            return null;
        }
        Storage storageSpec = storage;
        StateStorage stateStorage = store.getStorageManager().getStateStorage(storageSpec);
        if (stateStorage == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.StateStorageBase<com.intellij.configurationStore.StateMap>");
        }
        return (StateStorageBase)stateStorage;
    }

    private static final Storage getStorageSpec(String filePath, Project project) {
        String collapsedPath = null;
        Class<StateSplitterEx> splitterClass = null;
        if (FileUtil.extensionEquals((String)filePath, (String)"ipr")) {
            collapsedPath = "$PROJECT_FILE$";
            splitterClass = StateSplitterEx.class;
        } else {
            String fileName = PathUtil.getFileName((String)filePath);
            String parentPath = PathUtil.getParentPath((String)filePath);
            String parentFileName = PathUtil.getFileName((String)parentPath);
            if (Intrinsics.areEqual((Object)parentFileName, (Object)".idea")) {
                collapsedPath = fileName;
                splitterClass = StateSplitterEx.class;
            } else {
                String grandParentPath = PathUtil.getParentPath((String)parentPath);
                collapsedPath = parentFileName;
                splitterClass = FakeDirectoryBasedStateSplitter.class;
                if (Intrinsics.areEqual((Object)PathUtil.getFileName((String)grandParentPath), (Object)".idea") ^ true) {
                    StreamProviderFactory streamProviderFactory = (StreamProviderFactory)CollectionsKt.firstOrNull((List)StreamProviderFactory.Companion.getEP_NAME().getExtensionList((AreaInstance)project));
                    if (streamProviderFactory == null) {
                        return null;
                    }
                    StreamProviderFactory providerFactory = streamProviderFactory;
                    if (Intrinsics.areEqual((Object)parentFileName, (Object)"project")) {
                        if (Intrinsics.areEqual((Object)fileName, (Object)"libraries.xml") || Intrinsics.areEqual((Object)fileName, (Object)"artifacts.xml")) {
                            FileStorageAnnotation inProjectStorage = new FileStorageAnnotation(FileUtil.getNameWithoutExtension((String)fileName), false, splitterClass);
                            String componentName = Intrinsics.areEqual((Object)fileName, (Object)"libraries.xml") ? "libraryTable" : "ArtifactManager";
                            return providerFactory.getOrCreateStorageSpec(fileName, (State)new StateAnnotation(componentName, (Storage)inProjectStorage));
                        }
                        if (Intrinsics.areEqual((Object)fileName, (Object)"modules.xml")) {
                            return StreamProviderFactory.DefaultImpls.getOrCreateStorageSpec$default(providerFactory, fileName, null, 2, null);
                        }
                    }
                    String string = filePath + " is not under .idea directory and not under external system cache";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            }
        }
        return (Storage)new FileStorageAnnotation(collapsedPath, false, splitterClass);
    }
}

