/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.tree;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import org.jetbrains.annotations.NotNull;

public class ProjectContentFileFilter
implements VirtualFileFilter {
    private final Project project;
    private final VirtualFileFilter filter;
    private ProjectFileIndex fileIndex;

    public ProjectContentFileFilter(@NotNull Project project, @NotNull VirtualFileFilter filter2) {
        this.project = project;
        this.filter = filter2;
    }

    public boolean accept(@NotNull VirtualFile file2) {
        if (!this.filter.accept(file2)) {
            return false;
        }
        if (this.fileIndex == null) {
            this.fileIndex = ProjectRootManager.getInstance((Project)this.project).getFileIndex();
        }
        return this.fileIndex.isInContent(file2);
    }
}

