/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic.dump.paths.resolvers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePaths;
import com.intellij.util.indexing.diagnostic.dump.paths.resolvers.PortableFilePathResolver;
import kotlin.Metadata;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/util/indexing/diagnostic/dump/paths/resolvers/RelativePortableFilePathResolver;", "Lcom/intellij/util/indexing/diagnostic/dump/paths/resolvers/PortableFilePathResolver;", "()V", "findFileByPath", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "portableFilePath", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "intellij.platform.lang.impl"})
public final class RelativePortableFilePathResolver
implements PortableFilePathResolver {
    public static final RelativePortableFilePathResolver INSTANCE;

    @Override
    @Nullable
    public VirtualFile findFileByPath(@NotNull Project project, @NotNull PortableFilePath portableFilePath) {
        if (portableFilePath instanceof PortableFilePath.RelativePath) {
            VirtualFile virtualFile = PortableFilePaths.INSTANCE.findFileByPath(((PortableFilePath.RelativePath)portableFilePath).getRoot(), project);
            if (virtualFile == null) {
                return null;
            }
            VirtualFile rootFile = virtualFile;
            String fullUrl = StringsKt.trimEnd((String)rootFile.getUrl(), (char[])new char[]{'/'}) + '/' + ((PortableFilePath.RelativePath)portableFilePath).getRelativePath();
            return VirtualFileManager.getInstance().refreshAndFindFileByUrl(fullUrl);
        }
        return null;
    }

    private RelativePortableFilePathResolver() {
    }

    static {
        RelativePortableFilePathResolver relativePortableFilePathResolver;
        INSTANCE = relativePortableFilePathResolver = new RelativePortableFilePathResolver();
    }
}

