/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.diagnostic.FileIndexingStatistics;
import com.intellij.util.indexing.diagnostic.LimitedPriorityQueue;
import com.intellij.util.indexing.diagnostic.TimeStats;
import com.intellij.util.indexing.diagnostic.TooLargeForIndexingFile;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002 !B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eR*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\""}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexingJobStatistics;", "", "()V", "_statsPerFileType", "Ljava/util/HashMap;", "", "Lcom/intellij/util/indexing/diagnostic/IndexingJobStatistics$StatsPerFileType;", "Lkotlin/collections/HashMap;", "_statsPerIndexer", "Lcom/intellij/util/indexing/diagnostic/IndexingJobStatistics$StatsPerIndexer;", "numberOfTooLargeForIndexingFiles", "Ljava/util/concurrent/atomic/AtomicInteger;", "getNumberOfTooLargeForIndexingFiles", "()Ljava/util/concurrent/atomic/AtomicInteger;", "statsPerFileType", "", "getStatsPerFileType", "()Ljava/util/Map;", "statsPerIndexer", "getStatsPerIndexer", "tooLargeForIndexingFiles", "Lcom/intellij/util/indexing/diagnostic/LimitedPriorityQueue;", "Lcom/intellij/util/indexing/diagnostic/TooLargeForIndexingFile;", "getTooLargeForIndexingFiles", "()Lcom/intellij/util/indexing/diagnostic/LimitedPriorityQueue;", "addFileStatistics", "", "fileStatistics", "Lcom/intellij/util/indexing/diagnostic/FileIndexingStatistics;", "contentLoadingTime", "", "fileSize", "StatsPerFileType", "StatsPerIndexer", "intellij.platform.lang.impl"})
public final class IndexingJobStatistics {
    private final HashMap<String, StatsPerIndexer> _statsPerIndexer;
    private final HashMap<String, StatsPerFileType> _statsPerFileType;
    @NotNull
    private final AtomicInteger numberOfTooLargeForIndexingFiles;
    @NotNull
    private final LimitedPriorityQueue<TooLargeForIndexingFile> tooLargeForIndexingFiles;

    @NotNull
    public final synchronized Map<String, StatsPerIndexer> getStatsPerIndexer() {
        return MapsKt.toMap((Map)this._statsPerIndexer);
    }

    @NotNull
    public final synchronized Map<String, StatsPerFileType> getStatsPerFileType() {
        return MapsKt.toMap((Map)this._statsPerFileType);
    }

    @NotNull
    public final AtomicInteger getNumberOfTooLargeForIndexingFiles() {
        return this.numberOfTooLargeForIndexingFiles;
    }

    @NotNull
    public final LimitedPriorityQueue<TooLargeForIndexingFile> getTooLargeForIndexingFiles() {
        return this.tooLargeForIndexingFiles;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void addFileStatistics(@NotNull FileIndexingStatistics fileStatistics, long contentLoadingTime, long fileSize) {
        Object object;
        Map<ID<?, ?>, Long> $this$forEach$iv = fileStatistics.getPerIndexerTimes();
        boolean $i$f$forEach = false;
        Map<ID<?, ?>, Long> map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<ID<?, ?>, Long>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object2;
            void $this$getOrPut$iv;
            void indexId;
            Map.Entry<ID<?, ?>, Long> element$iv;
            Map.Entry<ID<?, ?>, Long> $dstr$indexId$time = element$iv = iterator2.next();
            boolean bl2 = false;
            Map.Entry<ID<?, ?>, Long> entry = $dstr$indexId$time;
            int n = 0;
            ID<?, ?> iD = entry.getKey();
            entry = $dstr$indexId$time;
            n = 0;
            long time = ((Number)entry.getValue()).longValue();
            Map map3 = this._statsPerIndexer;
            String key$iv = indexId.getName();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl3 = false;
                StatsPerIndexer answer$iv = new StatsPerIndexer(new TimeStats(), 0, 0L);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            StatsPerIndexer stats = (StatsPerIndexer)object2;
            stats.getIndexingTime().addTime(time);
            StatsPerIndexer statsPerIndexer = stats;
            n = statsPerIndexer.getNumberOfFiles();
            statsPerIndexer.setNumberOfFiles(n + 1);
            StatsPerIndexer statsPerIndexer2 = stats;
            statsPerIndexer2.setTotalBytes(statsPerIndexer2.getTotalBytes() + fileSize);
        }
        String fileTypeName = fileStatistics.getFileType().getName();
        Map $this$getOrPut$iv = this._statsPerFileType;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(fileTypeName);
        if (value$iv == null) {
            boolean bl4 = false;
            StatsPerFileType answer$iv = new StatsPerFileType(new TimeStats(), new TimeStats(), 0, 0L);
            $this$getOrPut$iv.put(fileTypeName, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        StatsPerFileType stats = (StatsPerFileType)object;
        stats.getContentLoadingTime().addTime(contentLoadingTime);
        stats.getIndexingTime().addTime(fileStatistics.getIndexingTime());
        StatsPerFileType statsPerFileType = stats;
        statsPerFileType.setTotalBytes(statsPerFileType.getTotalBytes() + fileSize);
        StatsPerFileType statsPerFileType2 = stats;
        int n = statsPerFileType2.getNumberOfFiles();
        statsPerFileType2.setNumberOfFiles(n + 1);
    }

    public IndexingJobStatistics() {
        boolean bl = false;
        this._statsPerIndexer = new HashMap();
        bl = false;
        this._statsPerFileType = new HashMap();
        this.numberOfTooLargeForIndexingFiles = new AtomicInteger();
        bl = false;
        this.tooLargeForIndexingFiles = new LimitedPriorityQueue(5, new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                TooLargeForIndexingFile it = (TooLargeForIndexingFile)a;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getFileSize());
                it = (TooLargeForIndexingFile)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Comparable comparable3 = Long.valueOf(it.getFileSize());
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
            }
        });
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\r\u0010\u0016\u001a\u00060\u0007j\u0002`\bH\u00c6\u0003J+\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\f\b\u0002\u0010\u0006\u001a\u00060\u0007j\u0002`\bH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexingJobStatistics$StatsPerIndexer;", "", "indexingTime", "Lcom/intellij/util/indexing/diagnostic/TimeStats;", "numberOfFiles", "", "totalBytes", "", "Lcom/intellij/util/indexing/diagnostic/BytesNumber;", "(Lcom/intellij/util/indexing/diagnostic/TimeStats;IJ)V", "getIndexingTime", "()Lcom/intellij/util/indexing/diagnostic/TimeStats;", "getNumberOfFiles", "()I", "setNumberOfFiles", "(I)V", "getTotalBytes", "()J", "setTotalBytes", "(J)V", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.lang.impl"})
    public static final class StatsPerIndexer {
        @NotNull
        private final TimeStats indexingTime;
        private int numberOfFiles;
        private long totalBytes;

        @NotNull
        public final TimeStats getIndexingTime() {
            return this.indexingTime;
        }

        public final int getNumberOfFiles() {
            return this.numberOfFiles;
        }

        public final void setNumberOfFiles(int n) {
            this.numberOfFiles = n;
        }

        public final long getTotalBytes() {
            return this.totalBytes;
        }

        public final void setTotalBytes(long l) {
            this.totalBytes = l;
        }

        public StatsPerIndexer(@NotNull TimeStats indexingTime, int numberOfFiles, long totalBytes) {
            this.indexingTime = indexingTime;
            this.numberOfFiles = numberOfFiles;
            this.totalBytes = totalBytes;
        }

        @NotNull
        public final TimeStats component1() {
            return this.indexingTime;
        }

        public final int component2() {
            return this.numberOfFiles;
        }

        public final long component3() {
            return this.totalBytes;
        }

        @NotNull
        public final StatsPerIndexer copy(@NotNull TimeStats indexingTime, int numberOfFiles, long totalBytes) {
            return new StatsPerIndexer(indexingTime, numberOfFiles, totalBytes);
        }

        public static /* synthetic */ StatsPerIndexer copy$default(StatsPerIndexer statsPerIndexer, TimeStats timeStats, int n, long l, int n2, Object object) {
            if ((n2 & 1) != 0) {
                timeStats = statsPerIndexer.indexingTime;
            }
            if ((n2 & 2) != 0) {
                n = statsPerIndexer.numberOfFiles;
            }
            if ((n2 & 4) != 0) {
                l = statsPerIndexer.totalBytes;
            }
            return statsPerIndexer.copy(timeStats, n, l);
        }

        @NotNull
        public String toString() {
            return "StatsPerIndexer(indexingTime=" + this.indexingTime + ", numberOfFiles=" + this.numberOfFiles + ", totalBytes=" + this.totalBytes + ")";
        }

        public int hashCode() {
            TimeStats timeStats = this.indexingTime;
            return ((timeStats != null ? timeStats.hashCode() : 0) * 31 + Integer.hashCode(this.numberOfFiles)) * 31 + Long.hashCode(this.totalBytes);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StatsPerIndexer)) break block3;
                    StatsPerIndexer statsPerIndexer = (StatsPerIndexer)object;
                    if (!Intrinsics.areEqual((Object)this.indexingTime, (Object)statsPerIndexer.indexingTime) || this.numberOfFiles != statsPerIndexer.numberOfFiles || this.totalBytes != statsPerIndexer.totalBytes) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\r\u0010\u0019\u001a\u00060\bj\u0002`\tH\u00c6\u0003J5\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\f\b\u0002\u0010\u0007\u001a\u00060\bj\u0002`\tH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexingJobStatistics$StatsPerFileType;", "", "indexingTime", "Lcom/intellij/util/indexing/diagnostic/TimeStats;", "contentLoadingTime", "numberOfFiles", "", "totalBytes", "", "Lcom/intellij/util/indexing/diagnostic/BytesNumber;", "(Lcom/intellij/util/indexing/diagnostic/TimeStats;Lcom/intellij/util/indexing/diagnostic/TimeStats;IJ)V", "getContentLoadingTime", "()Lcom/intellij/util/indexing/diagnostic/TimeStats;", "getIndexingTime", "getNumberOfFiles", "()I", "setNumberOfFiles", "(I)V", "getTotalBytes", "()J", "setTotalBytes", "(J)V", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.lang.impl"})
    public static final class StatsPerFileType {
        @NotNull
        private final TimeStats indexingTime;
        @NotNull
        private final TimeStats contentLoadingTime;
        private int numberOfFiles;
        private long totalBytes;

        @NotNull
        public final TimeStats getIndexingTime() {
            return this.indexingTime;
        }

        @NotNull
        public final TimeStats getContentLoadingTime() {
            return this.contentLoadingTime;
        }

        public final int getNumberOfFiles() {
            return this.numberOfFiles;
        }

        public final void setNumberOfFiles(int n) {
            this.numberOfFiles = n;
        }

        public final long getTotalBytes() {
            return this.totalBytes;
        }

        public final void setTotalBytes(long l) {
            this.totalBytes = l;
        }

        public StatsPerFileType(@NotNull TimeStats indexingTime, @NotNull TimeStats contentLoadingTime, int numberOfFiles, long totalBytes) {
            this.indexingTime = indexingTime;
            this.contentLoadingTime = contentLoadingTime;
            this.numberOfFiles = numberOfFiles;
            this.totalBytes = totalBytes;
        }

        @NotNull
        public final TimeStats component1() {
            return this.indexingTime;
        }

        @NotNull
        public final TimeStats component2() {
            return this.contentLoadingTime;
        }

        public final int component3() {
            return this.numberOfFiles;
        }

        public final long component4() {
            return this.totalBytes;
        }

        @NotNull
        public final StatsPerFileType copy(@NotNull TimeStats indexingTime, @NotNull TimeStats contentLoadingTime, int numberOfFiles, long totalBytes) {
            return new StatsPerFileType(indexingTime, contentLoadingTime, numberOfFiles, totalBytes);
        }

        public static /* synthetic */ StatsPerFileType copy$default(StatsPerFileType statsPerFileType, TimeStats timeStats, TimeStats timeStats2, int n, long l, int n2, Object object) {
            if ((n2 & 1) != 0) {
                timeStats = statsPerFileType.indexingTime;
            }
            if ((n2 & 2) != 0) {
                timeStats2 = statsPerFileType.contentLoadingTime;
            }
            if ((n2 & 4) != 0) {
                n = statsPerFileType.numberOfFiles;
            }
            if ((n2 & 8) != 0) {
                l = statsPerFileType.totalBytes;
            }
            return statsPerFileType.copy(timeStats, timeStats2, n, l);
        }

        @NotNull
        public String toString() {
            return "StatsPerFileType(indexingTime=" + this.indexingTime + ", contentLoadingTime=" + this.contentLoadingTime + ", numberOfFiles=" + this.numberOfFiles + ", totalBytes=" + this.totalBytes + ")";
        }

        public int hashCode() {
            TimeStats timeStats = this.indexingTime;
            TimeStats timeStats2 = this.contentLoadingTime;
            return (((timeStats != null ? timeStats.hashCode() : 0) * 31 + (timeStats2 != null ? timeStats2.hashCode() : 0)) * 31 + Integer.hashCode(this.numberOfFiles)) * 31 + Long.hashCode(this.totalBytes);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StatsPerFileType)) break block3;
                    StatsPerFileType statsPerFileType = (StatsPerFileType)object;
                    if (!Intrinsics.areEqual((Object)this.indexingTime, (Object)statsPerFileType.indexingTime) || !Intrinsics.areEqual((Object)this.contentLoadingTime, (Object)statsPerFileType.contentLoadingTime) || this.numberOfFiles != statsPerFileType.numberOfFiles || this.totalBytes != statsPerFileType.totalBytes) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

