/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.IndexedHashesSupport;
import org.jetbrains.annotations.NotNull;

class LazyFileContentImpl
extends FileContentImpl {
    @NotNull
    private final NotNullComputable<byte[]> myContentComputable;
    private boolean myContentComputed;

    LazyFileContentImpl(@NotNull VirtualFile file2, @NotNull NotNullComputable<byte[]> contentComputable) {
        super(file2, null, null, -1L, true);
        this.myContentComputable = contentComputable;
    }

    @Override
    public byte @NotNull [] getContent() {
        this.initializeContent();
        return super.getContent();
    }

    @Override
    @NotNull
    public CharSequence getContentAsText() {
        this.initializeContent();
        return super.getContentAsText();
    }

    private void initializeContent() {
        if (!this.myContentComputed) {
            this.myContent = (byte[])this.myContentComputable.get();
            this.myContentComputed = true;
            if (FileBasedIndex.ourSnapshotMappingsEnabled) {
                IndexedHashesSupport.getOrInitIndexedHash(this);
            }
        }
    }
}

