/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.serviceContainer.ComponentManagerImplKt;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.indexing.AdditionalIndexableFileSet;
import com.intellij.util.indexing.CorruptionMarker;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexConfiguration;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexVersionRegistrationSink;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.PersistentIndicesConfiguration;
import com.intellij.util.indexing.RebuildStatus;
import com.intellij.util.indexing.RegisteredIndexes;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.IOUtil;
import gnu.trove.THashSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class FileBasedIndexDataInitialization
extends IndexInfrastructure.DataInitialization<IndexConfiguration> {
    private static final NotificationGroup NOTIFICATIONS = NotificationGroup.balloonGroup((String)"Indexing", (PluginId)PluginManagerCore.CORE_ID);
    private static final Logger LOG = Logger.getInstance(FileBasedIndexDataInitialization.class);
    private final IndexConfiguration state = new IndexConfiguration();
    private final IndexVersionRegistrationSink registrationResultSink = new IndexVersionRegistrationSink();
    private boolean currentVersionCorrupted;
    @NotNull
    private final FileBasedIndexImpl myFileBasedIndex;
    @NotNull
    private final RegisteredIndexes myRegisteredIndexes;

    FileBasedIndexDataInitialization(@NotNull FileBasedIndexImpl index, @NotNull RegisteredIndexes registeredIndexes) {
        this.myFileBasedIndex = index;
        this.myRegisteredIndexes = registeredIndexes;
    }

    private void initAssociatedDataForExtensions() {
        FileBasedIndexExtension extension;
        Iterator extensions2;
        Activity activity = StartUpMeasurer.startActivity((String)"file index extensions iteration");
        Iterator iterator2 = extensions2 = IndexInfrastructure.hasIndices() ? ((ExtensionPointImpl)FileBasedIndexExtension.EXTENSION_POINT_NAME.getPoint()).iterator() : Collections.emptyIterator();
        while (extensions2.hasNext() && (extension = (FileBasedIndexExtension)extensions2.next()) != null) {
            ID name = extension.getName();
            RebuildStatus.registerIndex(name);
            this.myRegisteredIndexes.registerIndexExtension(extension);
            this.addNestedInitializationTask(() -> {
                try {
                    FileBasedIndexImpl.registerIndexer(extension, this.state, this.registrationResultSink);
                }
                catch (IOException io) {
                    throw io;
                }
                catch (Throwable t) {
                    ComponentManagerImplKt.handleComponentError((Throwable)t, (String)extension.getClass().getName(), null);
                }
            });
        }
        this.myRegisteredIndexes.extensionsDataWasLoaded();
        activity.end();
    }

    @Override
    protected void prepare() {
        PersistentFSImpl fs = (PersistentFSImpl)ManagingFS.getInstance();
        FileBasedIndexImpl fileBasedIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
        Disposable disposable2 = () -> new FileBasedIndexImpl.MyShutDownTask().run();
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new MyApplicationListener(fileBasedIndex), disposable2);
        Disposer.register((Disposable)fs, (Disposable)disposable2);
        this.myFileBasedIndex.setUpShutDownTask();
        this.initAssociatedDataForExtensions();
        PersistentIndicesConfiguration.loadConfiguration();
        this.currentVersionCorrupted = CorruptionMarker.invalidateIndexesIfNeeded();
        for (FileBasedIndexInfrastructureExtension ex : (FileBasedIndexInfrastructureExtension[])FileBasedIndexInfrastructureExtension.EP_NAME.getExtensions()) {
            FileBasedIndexInfrastructureExtension.InitializationResult result2 = ex.initialize();
            this.currentVersionCorrupted = this.currentVersionCorrupted && result2 == FileBasedIndexInfrastructureExtension.InitializationResult.INDEX_REBUILD_REQUIRED;
        }
    }

    @Override
    protected void onThrowable(@NotNull Throwable t) {
        FileBasedIndexImpl.LOG.error(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IndexConfiguration finish() {
        try {
            this.state.finalizeFileTypeMappingForIndices();
            this.showChangedIndexesNotification();
            this.registrationResultSink.logChangedAndFullyBuiltIndices(FileBasedIndexImpl.LOG, "Indexes to be rebuilt after version change:", this.currentVersionCorrupted ? "Indexes to be rebuilt after corruption:" : "Indices to be built:");
            this.state.freeze();
            this.myRegisteredIndexes.setState(this.state);
            for (ID<?, ?> indexId : this.state.getIndexIDs()) {
                try {
                    RebuildStatus.clearIndexIfNecessary(indexId, (ThrowableRunnable<? extends StorageException>)((ThrowableRunnable)() -> this.myFileBasedIndex.clearIndex(indexId)));
                }
                catch (StorageException e) {
                    this.myFileBasedIndex.requestRebuild(indexId);
                    FileBasedIndexImpl.LOG.error((Throwable)e);
                }
            }
            this.myFileBasedIndex.registerIndexableSet(new AdditionalIndexableFileSet(), null);
            IndexConfiguration indexConfiguration = this.state;
            return indexConfiguration;
        }
        finally {
            this.myFileBasedIndex.setUpFlusher();
            this.myRegisteredIndexes.ensureLoadedIndexesUpToDate();
            this.myRegisteredIndexes.markInitialized();
            FileBasedIndexDataInitialization.saveRegisteredIndicesAndDropUnregisteredOnes(this.state.getIndexIDs());
        }
    }

    private void showChangedIndexesNotification() {
        if (ApplicationManager.getApplication().isHeadlessEnvironment() || !Registry.is((String)"ide.showIndexRebuildMessage")) {
            return;
        }
        String rebuildNotification = null;
        if (this.currentVersionCorrupted) {
            rebuildNotification = IndexingBundle.message((String)"index.corrupted.notification.text", (Object[])new Object[0]);
        } else if (this.registrationResultSink.hasChangedIndexes()) {
            rebuildNotification = IndexingBundle.message((String)"index.format.changed.notification.text", (Object[])new Object[]{this.registrationResultSink.changedIndices()});
        }
        if (rebuildNotification != null) {
            NOTIFICATIONS.createNotification(IndexingBundle.message((String)"index.rebuild.notification.title", (Object[])new Object[0]), rebuildNotification, NotificationType.INFORMATION, null).notify(null);
        }
    }

    private static void saveRegisteredIndicesAndDropUnregisteredOnes(@NotNull Collection<? extends ID<?, ?>> ids) {
        Throwable throwable;
        if (ApplicationManager.getApplication().isDisposed() || !IndexInfrastructure.hasIndices()) {
            return;
        }
        File registeredIndicesFile = new File(PathManager.getIndexRoot(), "registered");
        THashSet indicesToDrop = new THashSet();
        boolean exceptionThrown = false;
        if (registeredIndicesFile.exists()) {
            try {
                throwable = null;
                try (DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(registeredIndicesFile)));){
                    int size = in.readInt();
                    for (int idx = 0; idx < size; ++idx) {
                        indicesToDrop.add(IOUtil.readString((DataInput)in));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable e) {
                LOG.info(e);
                exceptionThrown = true;
                ids.stream().map(IndexId::getName).forEach(((Set)indicesToDrop)::add);
            }
        }
        if (!exceptionThrown) {
            for (ID<?, ?> key : ids) {
                indicesToDrop.remove(key.getName());
            }
        }
        if (!indicesToDrop.isEmpty()) {
            LOG.info("Dropping indices:" + StringUtil.join((Collection)indicesToDrop, (String)","));
            for (String s : indicesToDrop) {
                FileUtil.deleteWithRenaming((File)IndexInfrastructure.getFileBasedIndexRootDir(s));
            }
        }
        FileUtil.createIfDoesntExist((File)registeredIndicesFile);
        try {
            throwable = null;
            try (DataOutputStream os = new DataOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(registeredIndicesFile)));){
                os.writeInt(ids.size());
                for (ID<?, ?> id2 : ids) {
                    IOUtil.writeString((String)id2.getName(), (DataOutput)os);
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    private static class MyApplicationListener
    implements ApplicationListener {
        private final FileBasedIndexImpl myFileBasedIndex;

        MyApplicationListener(FileBasedIndexImpl fileBasedIndex) {
            this.myFileBasedIndex = fileBasedIndex;
        }

        public void writeActionStarted(@NotNull Object action2) {
            this.myFileBasedIndex.clearUpToDateIndexesForUnsavedOrTransactedDocs();
        }
    }
}

