/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class UriUtil {
    public static final CharMatcher PARAM_CHAR_MATCHER = CharMatcher.anyOf((CharSequence)"?#;");

    private UriUtil() {
    }

    @NotNull
    public static String trimTrailingSlashes(@NotNull String url) {
        return StringUtil.trimTrailing((String)url, (char)'/');
    }

    @NotNull
    public static String trimLeadingSlashes(@NotNull String url) {
        return StringUtil.trimLeading((String)url, (char)'/');
    }

    public static String trimParameters(@NotNull String url) {
        int end = PARAM_CHAR_MATCHER.indexIn((CharSequence)url);
        return end != -1 ? url.substring(0, end) : url;
    }

    @NotNull
    public static Couple<String> splitScheme(@NotNull String url) {
        ArrayList list2 = Lists.newArrayList((Iterable)Splitter.on((String)"://").limit(2).split((CharSequence)url));
        if (list2.size() == 1) {
            return Couple.of((Object)"", list2.get(0));
        }
        return Couple.of(list2.get(0), list2.get(1));
    }
}

