/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.editor.event.DocumentEvent;
import org.jetbrains.annotations.NotNull;

public final class DocumentEventUtil {
    private DocumentEventUtil() {
    }

    public static boolean isMoveInsertion(@NotNull DocumentEvent e) {
        return e.getOldLength() == 0 && e.getMoveOffset() != e.getOffset();
    }

    public static boolean isMoveDeletion(@NotNull DocumentEvent e) {
        return e.getNewLength() == 0 && e.getMoveOffset() != e.getOffset();
    }

    public static int getMoveOffsetBeforeInsertion(@NotNull DocumentEvent e) {
        int moveOffset = e.getMoveOffset();
        if (moveOffset > e.getOffset()) {
            return moveOffset - e.getNewLength();
        }
        return moveOffset;
    }

    public static int getMoveOffsetAfterDeletion(@NotNull DocumentEvent e) {
        int moveOffset = e.getMoveOffset();
        if (moveOffset > e.getOffset()) {
            return moveOffset - e.getOldLength();
        }
        return moveOffset;
    }
}

