/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.CachedValueBase;
import com.intellij.util.CachedValueLeakChecker;
import com.intellij.util.CachedValueStabilityChecker;
import com.intellij.util.CachedValuesFactory;
import com.intellij.util.DefaultCachedValuesFactory;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CachedValuesManagerImpl
extends CachedValuesManager {
    private static final Object NULL = new Object();
    private ConcurrentMap<UserDataHolder, Object> myCacheHolders = ContainerUtil.createConcurrentWeakMap((TObjectHashingStrategy)ContainerUtil.identityStrategy());
    private Set<Key<?>> myKeys = ContainerUtil.newConcurrentSet();
    private final Project myProject;
    private final CachedValuesFactory myFactory;

    public CachedValuesManagerImpl(Project project) {
        this.myProject = project;
        CachedValuesFactory factory2 = (CachedValuesFactory)project.getService(CachedValuesFactory.class);
        this.myFactory = factory2 == null ? new DefaultCachedValuesFactory(project) : factory2;
    }

    @NonInjectable
    public CachedValuesManagerImpl(Project project, CachedValuesFactory factory2) {
        this.myProject = project;
        this.myFactory = factory2 == null ? new DefaultCachedValuesFactory(project) : factory2;
    }

    @NotNull
    public <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> provider, boolean trackValue) {
        return this.myFactory.createCachedValue(provider, trackValue);
    }

    @NotNull
    public <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(@NotNull ParameterizedCachedValueProvider<T, P> provider, boolean trackValue) {
        return this.myFactory.createParameterizedCachedValue(provider, trackValue);
    }

    @Nullable
    public <T> T getCachedValue(@NotNull UserDataHolder dataHolder, @NotNull Key<CachedValue<T>> key, @NotNull CachedValueProvider<T> provider, boolean trackValue) {
        CachedValue<T> value2 = (CachedValue<T>)dataHolder.getUserData(key);
        if (value2 instanceof CachedValueBase && ((CachedValueBase)value2).isFromMyProject(this.myProject)) {
            Getter data2 = value2.getUpToDateOrNull();
            if (data2 != null) {
                return (T)data2.get();
            }
            CachedValueStabilityChecker.checkProvidersEquivalent(provider, value2.getValueProvider(), key);
        }
        if (value2 == null) {
            value2 = this.saveInUserData(dataHolder, key, this.freshCachedValue(dataHolder, key, provider, trackValue));
        }
        return (T)value2.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> CachedValue<T> saveInUserData(@NotNull UserDataHolder dataHolder, @NotNull Key<CachedValue<T>> key, CachedValue<T> value2) {
        this.trackKeyHolder(dataHolder, key);
        if (dataHolder instanceof UserDataHolderEx) {
            return (CachedValue)((UserDataHolderEx)dataHolder).putUserDataIfAbsent(key, value2);
        }
        UserDataHolder userDataHolder = dataHolder;
        synchronized (userDataHolder) {
            CachedValue existing = (CachedValue)dataHolder.getUserData(key);
            if (existing != null) {
                return existing;
            }
            dataHolder.putUserData(key, value2);
            return value2;
        }
    }

    protected void trackKeyHolder(@NotNull UserDataHolder dataHolder, @NotNull Key<?> key) {
        if (!CachedValuesManagerImpl.isClearedOnPluginUnload(dataHolder)) {
            this.myCacheHolders.put(dataHolder, NULL);
            this.myKeys.add(key);
        }
    }

    private static boolean isClearedOnPluginUnload(@NotNull UserDataHolder dataHolder) {
        return dataHolder instanceof PsiElement || dataHolder instanceof ASTNode || dataHolder instanceof FileViewProvider;
    }

    private <T> CachedValue<T> freshCachedValue(UserDataHolder dh, Key<CachedValue<T>> key, CachedValueProvider<T> provider, boolean trackValue) {
        CachedValueLeakChecker.checkProvider(provider, key, dh);
        CachedValue<T> value2 = this.createCachedValue(provider, trackValue);
        assert (((CachedValueBase)value2).isFromMyProject(this.myProject));
        return value2;
    }

    @ApiStatus.Internal
    public void clearCachedValues() {
        for (UserDataHolder holder : this.myCacheHolders.keySet()) {
            for (Key<?> key : this.myKeys) {
                holder.putUserData(key, null);
            }
        }
        CachedValueStabilityChecker.cleanupFieldCache();
        this.myCacheHolders = ContainerUtil.createConcurrentWeakMap((TObjectHashingStrategy)ContainerUtil.identityStrategy());
        this.myKeys = ContainerUtil.newConcurrentSet();
    }
}

