/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usageView;

import com.intellij.ide.TypePresentationService;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.util.indexing.IndexingBundle;
import org.jetbrains.annotations.NotNull;

public class UsageViewTypeLocation
extends ElementDescriptionLocation {
    public static final UsageViewTypeLocation INSTANCE = new UsageViewTypeLocation();
    private static final ElementDescriptionProvider DEFAULT_PROVIDER = new ElementDescriptionProvider(){

        public String getElementDescription(@NotNull PsiElement psiElement, @NotNull ElementDescriptionLocation location) {
            PsiMetaData metaData;
            if (!(location instanceof UsageViewTypeLocation)) {
                return null;
            }
            if (psiElement instanceof PsiMetaOwner && (metaData = ((PsiMetaOwner)psiElement).getMetaData()) instanceof PsiPresentableMetaData) {
                return ((PsiPresentableMetaData)metaData).getTypeName();
            }
            if (psiElement instanceof PsiFile) {
                return IndexingBundle.message((String)"terms.file", (Object[])new Object[0]);
            }
            if (psiElement instanceof PsiDirectory) {
                return IndexingBundle.message((String)"terms.directory", (Object[])new Object[0]);
            }
            String type = LanguageFindUsages.getType((PsiElement)psiElement);
            if (!type.isEmpty()) {
                return type;
            }
            return TypePresentationService.getService().getTypePresentableName(psiElement.getClass());
        }
    };

    private UsageViewTypeLocation() {
    }

    @NotNull
    public ElementDescriptionProvider getDefaultProvider() {
        return DEFAULT_PROVIDER;
    }
}

