/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.ValidateableNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.tree.ChildrenProvider;
import com.intellij.ui.tree.LeafState;
import com.intellij.ui.tree.Reference;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.ui.tree.AbstractTreeModel;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class StructureTreeModel<Structure extends AbstractTreeStructure>
extends AbstractTreeModel
implements Disposable,
InvokerSupplier,
ChildrenProvider<TreeNode> {
    private static final TreePath ROOT_INVALIDATED = new TreePath(new DefaultMutableTreeNode());
    private static final Logger LOG = Logger.getInstance(StructureTreeModel.class);
    private final Reference<Node> root = new Reference();
    private final String description;
    private final Invoker invoker;
    private final Structure structure;
    private volatile Comparator<? super Node> comparator;

    public StructureTreeModel(@NotNull Structure structure, @NotNull Disposable parent) {
        this(structure, null, parent);
    }

    public StructureTreeModel(@NotNull Structure structure, @Nullable Comparator<? super NodeDescriptor<?>> comparator2, @NotNull Disposable parent) {
        this(structure, comparator2, Invoker.forBackgroundThreadWithReadAction(parent), parent);
    }

    public StructureTreeModel(@NotNull Structure structure, @Nullable Comparator<? super NodeDescriptor<?>> comparator2, @NotNull Invoker invoker, @NotNull Disposable parent) {
        this.structure = structure;
        this.description = StructureTreeModel.format(structure.toString());
        this.invoker = invoker;
        this.comparator = comparator2 == null ? null : StructureTreeModel.wrapToNodeComparator(comparator2);
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    @NotNull
    private static Comparator<? super Node> wrapToNodeComparator(@NotNull Comparator<? super NodeDescriptor<?>> comparator2) {
        return (node1, node2) -> comparator2.compare((NodeDescriptor<?>)((Node)node1).getDescriptor(), (NodeDescriptor<?>)((Node)node2).getDescriptor());
    }

    public final void setComparator(@Nullable Comparator<? super NodeDescriptor<?>> comparator2) {
        if (this.disposed) {
            return;
        }
        if (comparator2 != null) {
            this.comparator = StructureTreeModel.wrapToNodeComparator(comparator2);
            this.invalidate();
        } else if (this.comparator != null) {
            this.comparator = null;
            this.invalidate();
        }
    }

    public void dispose() {
        this.comparator = null;
        Node node = this.root.set(null);
        if (node != null) {
            node.dispose();
        }
        this.treeStructureChanged(null, null, null);
        super.dispose();
    }

    @Override
    @NotNull
    public final Invoker getInvoker() {
        return this.invoker;
    }

    private boolean isValidThread() {
        if (this.invoker.isValidThread()) {
            return true;
        }
        LOG.warn((Throwable)new IllegalStateException("StructureTreeModel is used from unexpected thread"));
        return false;
    }

    @NotNull
    private <Result> Promise<Result> onValidThread(@NotNull Function<? super Structure, ? extends Result> function) {
        AsyncPromise promise = new AsyncPromise();
        this.invoker.invoke(() -> {
            Object result2;
            if (!this.disposed && (result2 = function.apply((Structure)this.structure)) != null) {
                promise.setResult(result2);
            }
            if (!promise.isDone()) {
                promise.cancel();
            }
        }).onError(arg_0 -> ((AsyncPromise)promise).setError(arg_0));
        return promise;
    }

    @NotNull
    private <Result> Promise<Result> onValidThread(@NotNull TreePath path, @NotNull Function<? super Node, ? extends Result> function) {
        Object component2 = path.getLastPathComponent();
        if (component2 instanceof Node) {
            Node node = (Node)component2;
            return this.onValidThread(structure -> this.disposed || this.isNodeRemoved(node) ? null : function.apply(node));
        }
        return Promises.rejectedPromise((String)("unexpected node: " + component2));
    }

    @NotNull
    private <Result> Promise<Result> onValidThread(@NotNull Object element2, @NotNull Function<? super Node, ? extends Result> function) {
        return this.onValidThread(structure -> {
            Node node = this.root.get();
            if (node == null) {
                return null;
            }
            if (node.matches(element2)) {
                return function.apply(node);
            }
            ArrayDeque<Object> stack = new ArrayDeque<Object>();
            Object e = element2;
            while (e != null) {
                stack.push(e);
                e = structure.getParentElement(e);
            }
            if (!node.matches(stack.pop())) {
                return null;
            }
            while (!stack.isEmpty()) {
                if ((node = node.findChild(stack.pop())) != null) continue;
                return null;
            }
            return function.apply(node);
        });
    }

    @NotNull
    public final Promise<?> invalidate() {
        return this.onValidThread(structure -> this.invalidateInternal(null, true));
    }

    @NotNull
    public final Promise<TreePath> invalidate(@NotNull TreePath path, boolean structure) {
        return this.onValidThread(path, (? super Node node) -> this.invalidateInternal((Node)node, structure));
    }

    @NotNull
    public final Promise<TreePath> invalidate(@NotNull Object element2, boolean structure) {
        return this.onValidThread(element2, (? super Node node) -> this.invalidateInternal((Node)node, structure));
    }

    @Nullable
    private TreePath invalidateInternal(@Nullable Node node, boolean structure) {
        assert (this.invoker.isValidThread());
        while (node != null && !this.isValid(node)) {
            LOG.debug("invalid element cannot be updated: ", new Object[]{node});
            node = (Node)node.getParent();
            structure = true;
        }
        if (node == null) {
            node = this.root.get();
            if (node != null) {
                node.invalidate();
            }
            this.root.invalidate();
            LOG.debug("root invalidated: ", new Object[]{node});
            this.treeStructureChanged(null, null, null);
            return ROOT_INVALIDATED;
        }
        boolean updated = node.update();
        if (structure) {
            node.invalidate();
            TreePath path = TreePathUtil.pathToTreeNode(node);
            this.treeStructureChanged(path, null, null);
            return path;
        }
        if (updated) {
            TreePath path = TreePathUtil.pathToTreeNode(node);
            this.treeNodesChanged(path, null, null);
            return path;
        }
        return null;
    }

    public final void expand(@NotNull Object element2, @NotNull JTree tree, @NotNull Consumer<? super TreePath> consumer) {
        this.promiseVisitor(element2).onSuccess(visitor -> TreeUtil.expand((JTree)tree, (TreeVisitor)visitor, (Consumer)consumer));
    }

    public final void makeVisible(@NotNull Object element2, @NotNull JTree tree, @NotNull Consumer<? super TreePath> consumer) {
        this.promiseVisitor(element2).onSuccess(visitor -> TreeUtil.makeVisible((JTree)tree, (TreeVisitor)visitor, (Consumer)consumer));
    }

    public final void select(@NotNull Object element2, @NotNull JTree tree, @NotNull Consumer<? super TreePath> consumer) {
        this.promiseVisitor(element2).onSuccess(visitor -> TreeUtil.promiseSelect((JTree)tree, (TreeVisitor)visitor).onSuccess(consumer));
    }

    @NotNull
    public final Promise<TreeVisitor> promiseVisitor(@NotNull Object element2) {
        return this.onValidThread(structure -> new TreeVisitor.ByTreePath(TreePathUtil.pathToCustomNode(element2, arg_0 -> ((AbstractTreeStructure)structure).getParentElement(arg_0)), node -> node instanceof Node ? ((Node)node).getElement() : null));
    }

    public final TreeNode getRoot() {
        if (this.disposed || !this.isValidThread()) {
            return null;
        }
        if (!this.root.isValid()) {
            Node newRoot = this.getValidRoot();
            this.root.set(newRoot);
            LOG.debug("root updated: ", new Object[]{newRoot});
        }
        return this.root.get();
    }

    private Node getNode(Object object, boolean validateChildren) {
        if (this.disposed || !(object instanceof Node) || !this.isValidThread()) {
            return null;
        }
        Node node = (Node)object;
        if (this.isNodeRemoved(node)) {
            return null;
        }
        if (validateChildren) {
            this.validateChildren(node);
        }
        return node;
    }

    private void validateChildren(@NotNull Node node) {
        if (!node.children.isValid()) {
            List<Node> newChildren = this.getValidChildren(node);
            List<Node> oldChildren = node.children.set(newChildren);
            if (oldChildren != null) {
                oldChildren.forEach(child2 -> child2.setParent(null));
            }
            if (newChildren != null) {
                newChildren.forEach(child2 -> child2.setParent(node));
            }
            LOG.debug("children updated: ", new Object[]{node});
        }
    }

    private boolean isNodeRemoved(@NotNull Node node) {
        return !node.isNodeAncestor(this.root.get());
    }

    @Override
    public final List<TreeNode> getChildren(Object object) {
        List list2;
        Node node = this.getNode(object, true);
        List list3 = list2 = node == null ? null : (List)node.children.get();
        if (list2 == null || list2.isEmpty()) {
            return Collections.emptyList();
        }
        list2.forEach(rec$ -> ((Node)rec$).update());
        return Collections.unmodifiableList(list2);
    }

    public final int getChildCount(Object object) {
        Node node = this.getNode(object, true);
        return node == null ? 0 : node.getChildCount();
    }

    public final TreeNode getChild(Object object, int index) {
        Node node = this.getNode(object, true);
        return node == null ? null : node.getChildAt(index);
    }

    public final boolean isLeaf(Object object) {
        Node node = this.getNode(object, false);
        return node == null || node.isLeaf(this::validateChildren);
    }

    public final int getIndexOfChild(Object object, Object child2) {
        return object instanceof Node && child2 instanceof Node ? ((Node)object).getIndex((TreeNode)child2) : -1;
    }

    private boolean isValid(@NotNull Node node) {
        return StructureTreeModel.isValid(this.structure, node.getElement());
    }

    private static boolean isValid(@NotNull AbstractTreeStructure structure, Object element2) {
        AbstractTreeNode node;
        if (element2 == null) {
            return false;
        }
        if (element2 instanceof AbstractTreeNode && null == (node = (AbstractTreeNode)element2).getValue()) {
            return false;
        }
        if (element2 instanceof ValidateableNode && !(node = (ValidateableNode)element2).isValid()) {
            return false;
        }
        return structure.isValid(element2);
    }

    @Nullable
    private Node getValidRoot() {
        Object element2 = this.structure.getRootElement();
        if (!StructureTreeModel.isValid(this.structure, element2)) {
            return null;
        }
        Node newNode = new Node((AbstractTreeStructure)this.structure, element2, null);
        Node oldNode = this.root.get();
        if (oldNode != null && oldNode.canReuse(newNode, element2)) {
            return oldNode;
        }
        return newNode;
    }

    @Nullable
    private List<Node> getValidChildren(@NotNull Node node) {
        NodeDescriptor descriptor2 = node.getDescriptor();
        if (descriptor2 == null) {
            return null;
        }
        Object parent = descriptor2.getElement();
        if (!StructureTreeModel.isValid(this.structure, parent)) {
            return null;
        }
        Object[] elements2 = this.structure.getChildElements(parent);
        if (elements2.length == 0) {
            return null;
        }
        ArrayList<Node> list2 = new ArrayList<Node>(elements2.length);
        for (Object object : elements2) {
            ProgressManager.checkCanceled();
            if (!StructureTreeModel.isValid(this.structure, object)) continue;
            list2.add(new Node((AbstractTreeStructure)this.structure, object, descriptor2));
        }
        Comparator<? super Node> comparator2 = this.comparator;
        if (comparator2 != null) {
            try {
                list2.sort(comparator2);
            }
            catch (IllegalArgumentException exception) {
                StringBuilder sb = new StringBuilder("unexpected sorting failed in ");
                sb.append(this);
                for (Node next : list2) {
                    sb.append('\n').append(next);
                }
                LOG.error(sb.toString(), (Throwable)exception);
            }
        }
        HashMap map2 = new HashMap();
        node.getChildren().forEach(child2 -> {
            ProgressManager.checkCanceled();
            Object element2 = ((Node)child2).getElement();
            if (element2 != null) {
                map2.put(element2, child2);
            }
        });
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            ProgressManager.checkCanceled();
            Node node2 = (Node)list2.get(i2);
            Node oldNode = (Node)map2.get(node2.getElement());
            if (oldNode == null || !oldNode.canReuse(node2, null)) continue;
            list2.set(i2, oldNode);
        }
        return list2;
    }

    @Deprecated
    public final TreeNode getRootImmediately() {
        if (!this.root.isValid()) {
            this.root.set(this.getValidRoot());
        }
        return this.root.get();
    }

    public String toString() {
        return this.description;
    }

    @NotNull
    private static String format(@NotNull String prefix) {
        for (StackTraceElement element2 : new Exception().getStackTrace()) {
            if (StructureTreeModel.class.getName().equals(element2.getClassName())) continue;
            return prefix + " @ " + element2.getFileName() + " : " + element2.getLineNumber();
        }
        return prefix;
    }

    private static final class Node
    extends DefaultMutableTreeNode
    implements LeafState.Supplier {
        private final Reference<List<Node>> children = new Reference();
        private final LeafState leafState;
        private final int hashCode;

        private Node(@NotNull AbstractTreeStructure structure, @NotNull Object element2, NodeDescriptor<?> parent) {
            this(structure.createDescriptor(element2, parent), structure.getLeafState(element2), element2.hashCode());
        }

        private Node(@NotNull NodeDescriptor descriptor2, @NotNull LeafState leafState, int hashCode) {
            super(descriptor2, leafState != LeafState.ALWAYS);
            this.leafState = leafState;
            this.hashCode = hashCode;
            if (leafState == LeafState.ALWAYS) {
                this.children.set(null);
            }
            this.update();
        }

        private void dispose() {
            this.setParent(null);
            List list2 = this.children.set(null);
            if (list2 != null) {
                list2.forEach(Node::dispose);
            }
        }

        private boolean canReuse(@NotNull Node node, Object element2) {
            if (this.leafState != node.leafState || this.hashCode != node.hashCode) {
                return false;
            }
            if (element2 != null && !this.matches(element2)) {
                return false;
            }
            this.userObject = node.userObject;
            return true;
        }

        private boolean update() {
            NodeDescriptor<?> descriptor2 = this.getDescriptor();
            return descriptor2 != null && descriptor2.update();
        }

        private void invalidate() {
            if (this.leafState != LeafState.ALWAYS) {
                this.children.invalidate();
                LOG.debug("node invalidated: ", new Object[]{this});
                this.getChildren().forEach(Node::invalidate);
            }
        }

        private boolean matches(@NotNull Object element2) {
            return this.matches(element2, element2.hashCode());
        }

        private boolean matches(@NotNull Object element2, int hashCode) {
            return this.hashCode == hashCode && element2.equals(this.getElement());
        }

        private Node findChild(@NotNull Object element2) {
            List<Node> list2 = this.children.get();
            if (list2 != null) {
                if (!list2.isEmpty()) {
                    int hashCode = element2.hashCode();
                    Optional<Node> result2 = list2.stream().filter(node -> node.matches(element2, hashCode)).findFirst();
                    if (result2.isPresent()) {
                        return result2.get();
                    }
                }
                if (LOG.isTraceEnabled()) {
                    LOG.debug("node '", new Object[]{this.getElement(), "' have no child: ", element2});
                }
            } else if (LOG.isTraceEnabled()) {
                LOG.debug("node '", new Object[]{this.getElement(), "' have no loaded children"});
            }
            return null;
        }

        @NotNull
        private List<Node> getChildren() {
            List<Node> list2 = this.children.get();
            return list2 != null ? list2 : Collections.emptyList();
        }

        private NodeDescriptor<?> getDescriptor() {
            Object object = this.getUserObject();
            return object instanceof NodeDescriptor ? (NodeDescriptor)object : null;
        }

        private Object getElement() {
            NodeDescriptor<?> descriptor2 = this.getDescriptor();
            return descriptor2 == null ? null : descriptor2.getElement();
        }

        @Override
        public void setUserObject(Object object) {
            throw new UnsupportedOperationException("cannot modify node");
        }

        @Override
        public void setAllowsChildren(boolean value2) {
            throw new UnsupportedOperationException("cannot modify node");
        }

        @Override
        public Object clone() {
            throw new UnsupportedOperationException("cannot clone node");
        }

        @Override
        public void insert(MutableTreeNode child2, int index) {
            throw new UnsupportedOperationException("cannot insert node");
        }

        @Override
        public void remove(int index) {
            throw new UnsupportedOperationException("cannot remove node");
        }

        public Enumeration children() {
            return Collections.enumeration(this.getChildren());
        }

        @Override
        public TreeNode getChildAt(int index) {
            List<Node> list2 = this.getChildren();
            return 0 <= index && index < list2.size() ? (TreeNode)list2.get(index) : null;
        }

        @Override
        public int getChildCount() {
            return this.getChildren().size();
        }

        @Override
        public boolean isLeaf() {
            return this.isLeaf(null);
        }

        private boolean isLeaf(@Nullable Consumer<? super Node> validator) {
            if (null == this.getParent()) {
                return false;
            }
            if (this.leafState == LeafState.ALWAYS) {
                return true;
            }
            if (this.leafState == LeafState.NEVER) {
                return false;
            }
            if (this.leafState == LeafState.DEFAULT && validator != null) {
                validator.accept(this);
            }
            return this.children.isValid() && super.isLeaf();
        }

        @Override
        public int getIndex(@NotNull TreeNode child2) {
            return child2 instanceof Node && this.isNodeChild(child2) ? this.getChildren().indexOf(child2) : -1;
        }

        @NotNull
        public LeafState getLeafState() {
            return this.leafState;
        }
    }
}

