/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.tree.AbstractTreeWalker;
import com.intellij.ui.tree.ChildrenProvider;
import com.intellij.ui.tree.Identifiable;
import com.intellij.ui.tree.LeafState;
import com.intellij.ui.tree.Navigatable;
import com.intellij.ui.tree.Searchable;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.ui.tree.AbstractTreeModel;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class AsyncTreeModel
extends AbstractTreeModel
implements Identifiable,
Searchable,
Navigatable,
TreeVisitor.Acceptor {
    private static final Logger LOG = Logger.getInstance(AsyncTreeModel.class);
    private final Invoker foreground;
    private final Invoker background;
    private final Tree tree = new Tree();
    private final TreeModel model;
    private final boolean showLoadingNode;
    private final TreeModelListener listener = new TreeModelAdapter(){

        protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type) {
            TreePath path = event.getTreePath();
            if (path == null) {
                AsyncTreeModel.this.submit(new CmdGetRoot("Reload root", null));
                return;
            }
            Object object = path.getLastPathComponent();
            if (object == null) {
                LOG.warn("unsupported path: " + path);
                return;
            }
            if (path.getParentPath() == null && type == TreeModelAdapter.EventType.StructureChanged) {
                AsyncTreeModel.this.submit(new CmdGetRoot("Update root", object));
                return;
            }
            AsyncTreeModel.this.onValidThread(() -> {
                Node node = (Node)AsyncTreeModel.this.tree.map.get(object);
                if (node == null) {
                    LOG.debug("ignore updating of nonexistent node: ", new Object[]{object});
                } else if (type == TreeModelAdapter.EventType.NodesChanged) {
                    AsyncTreeModel.this.treeNodesChanged(event.getTreePath(), event.getChildIndices(), event.getChildren());
                } else if (node.isLoadingRequired()) {
                    AsyncTreeModel.this.treeNodesChanged(event.getTreePath(), null, null);
                } else if (type == TreeModelAdapter.EventType.NodesInserted) {
                    AsyncTreeModel.this.submit(new CmdGetChildren("Insert children", node, false));
                } else if (type == TreeModelAdapter.EventType.NodesRemoved) {
                    AsyncTreeModel.this.submit(new CmdGetChildren("Remove children", node, false));
                } else {
                    AsyncTreeModel.this.submit(new CmdGetChildren("Update children", node, true));
                }
            });
        }
    };

    @Deprecated
    public AsyncTreeModel(@NotNull TreeModel model) {
        this(model, true);
    }

    @Deprecated
    public AsyncTreeModel(@NotNull TreeModel model, boolean showLoadingNode) {
        if (model instanceof Disposable) {
            Disposer.register((Disposable)this, (Disposable)((Disposable)model));
        }
        this.foreground = Invoker.forEventDispatchThread((Disposable)this);
        if (model instanceof InvokerSupplier) {
            InvokerSupplier supplier2 = (InvokerSupplier)((Object)model);
            this.background = supplier2.getInvoker();
        } else {
            this.background = this.foreground;
        }
        this.model = model;
        this.model.addTreeModelListener(this.listener);
        this.showLoadingNode = showLoadingNode;
    }

    public AsyncTreeModel(@NotNull TreeModel model, @NotNull Disposable parent) {
        this(model, true, parent);
    }

    public AsyncTreeModel(@NotNull TreeModel model, boolean showLoadingNode, @NotNull Disposable parent) {
        this(model, showLoadingNode);
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public void dispose() {
        super.dispose();
        this.model.removeTreeModelListener(this.listener);
    }

    @Override
    public Object getUniqueID(@NotNull TreePath path) {
        return this.model instanceof Identifiable ? ((Identifiable)((Object)this.model)).getUniqueID(path) : null;
    }

    @Override
    @NotNull
    public Promise<TreePath> getTreePath(Object object) {
        if (this.disposed) {
            return Promises.rejectedPromise();
        }
        return this.resolve(this.model instanceof Searchable ? ((Searchable)((Object)this.model)).getTreePath(object) : null);
    }

    @Override
    @NotNull
    public Promise<TreePath> nextTreePath(@NotNull TreePath path, Object object) {
        if (this.disposed) {
            return Promises.rejectedPromise();
        }
        return this.resolve(this.model instanceof Navigatable ? ((Navigatable)((Object)this.model)).nextTreePath(path, object) : null);
    }

    @Override
    @NotNull
    public Promise<TreePath> prevTreePath(@NotNull TreePath path, Object object) {
        if (this.disposed) {
            return Promises.rejectedPromise();
        }
        return this.resolve(this.model instanceof Navigatable ? ((Navigatable)((Object)this.model)).prevTreePath(path, object) : null);
    }

    @NotNull
    public Promise<TreePath> resolve(TreePath path) {
        AsyncPromise async = new AsyncPromise();
        this.onValidThread(() -> this.resolve((AsyncPromise<? super TreePath>)async, path));
        return async;
    }

    @NotNull
    private Promise<TreePath> resolve(Promise<? extends TreePath> promise) {
        if (promise == null && this.isValidThread()) {
            return Promises.rejectedPromise();
        }
        AsyncPromise async = new AsyncPromise();
        if (promise == null) {
            this.onValidThread(() -> async.setError("rejected"));
        } else {
            promise.onError(this.onValidThread(arg_0 -> ((AsyncPromise)async).setError(arg_0)));
            promise.onSuccess(this.onValidThread((? super T path) -> this.resolve((AsyncPromise<? super TreePath>)async, (TreePath)path)));
        }
        return async;
    }

    private void resolve(@NotNull AsyncPromise<? super TreePath> async, TreePath path) {
        LOG.debug("resolve path: ", new Object[]{path});
        if (path == null) {
            async.setError("path is null");
            return;
        }
        Object object = path.getLastPathComponent();
        if (object == null) {
            async.setError("path is wrong");
            return;
        }
        this.accept((TreeVisitor)new TreeVisitor.ByTreePath(path, o -> o)).onProcessed(result2 -> {
            if (result2 == null) {
                async.setError("path not found");
                return;
            }
            async.setResult(result2);
        });
    }

    public Object getRoot() {
        if (this.disposed) {
            return null;
        }
        this.onValidThread(this::promiseRootEntry);
        Node node = this.tree.root;
        return node == null ? null : node.object;
    }

    public Object getChild(Object object, int index) {
        List<Node> children2 = this.getEntryChildren(object);
        return 0 <= index && index < children2.size() ? children2.get(index).object : null;
    }

    public int getChildCount(Object object) {
        return this.getEntryChildren(object).size();
    }

    public boolean isLeaf(Object object) {
        List children2;
        Node node = this.getEntry(object);
        if (node == null) {
            return true;
        }
        if (node.leafState == LeafState.ALWAYS) {
            return true;
        }
        if (node.leafState == LeafState.NEVER) {
            return false;
        }
        if (node.leafState == LeafState.ASYNC && node.children == null) {
            this.promiseChildren(node);
        }
        return (children2 = node.children) != null && children2.isEmpty();
    }

    public void valueForPathChanged(@NotNull TreePath path, Object value2) {
        this.background.invoke(() -> this.model.valueForPathChanged(path, value2));
    }

    public int getIndexOfChild(Object object, Object child2) {
        if (child2 != null) {
            List<Node> children2 = this.getEntryChildren(object);
            for (int i2 = 0; i2 < children2.size(); ++i2) {
                if (!child2.equals(children2.get(i2).object)) continue;
                return i2;
            }
        }
        return -1;
    }

    @NotNull
    public Promise<TreePath> accept(@NotNull TreeVisitor visitor) {
        return this.accept(visitor, true);
    }

    @NotNull
    public Promise<TreePath> accept(@NotNull TreeVisitor visitor, final boolean allowLoading) {
        AbstractTreeWalker<Node> walker = new AbstractTreeWalker<Node>(visitor, node -> ((Node)node).object){

            @Override
            protected Collection<Node> getChildren(@NotNull Node node) {
                if (node.leafState == LeafState.ALWAYS || !allowLoading) {
                    return node.getChildren();
                }
                AsyncTreeModel.this.promiseChildren(node).onSuccess(parent -> this.setChildren(((Node)parent).getChildren())).onError(this::setError);
                return null;
            }
        };
        if (allowLoading) {
            this.background.invokeLater(() -> this.onValidThread(() -> this.promiseRootEntry().onSuccess(walker::start).onError(walker::setError)));
        } else {
            this.onValidThread(() -> walker.start(this.tree.root));
        }
        return walker.promise();
    }

    public boolean isProcessing() {
        if (this.foreground.getTaskCount() > 0) {
            return true;
        }
        if (this.background.getTaskCount() > 0) {
            return true;
        }
        Object command = this.tree.queue.get();
        return command != null && ((Command)command).isPending();
    }

    private void submit(@NotNull Command command) {
        this.background.compute(command).onSuccess(value2 -> this.foreground.invoke(() -> command.accept((Node)value2)));
    }

    private boolean isValidThread() {
        if (this.foreground.isValidThread()) {
            return true;
        }
        LOG.warn((Throwable)new IllegalStateException("AsyncTreeModel is used from unexpected thread"));
        return false;
    }

    public void onValidThread(@NotNull Runnable runnable2) {
        this.foreground.invoke(runnable2);
    }

    @NotNull
    private <T> Consumer<T> onValidThread(@NotNull Consumer<? super T> consumer) {
        return value2 -> this.onValidThread(() -> consumer.accept(value2));
    }

    @NotNull
    private Promise<Node> promiseRootEntry() {
        if (this.disposed) {
            return Promises.rejectedPromise();
        }
        return this.tree.queue.promise(this::submit, () -> new CmdGetRoot("Load root", null));
    }

    @NotNull
    private Promise<Node> promiseChildren(@NotNull Node node) {
        if (this.disposed) {
            return Promises.rejectedPromise();
        }
        return node.queue.promise(this::submit, () -> {
            node.setLoading(!this.showLoadingNode ? null : new Node(new LoadingNode(), LeafState.ALWAYS));
            return new CmdGetChildren("Load children", node, false);
        });
    }

    private Node getEntry(Object object) {
        return this.disposed || object == null || !this.isValidThread() ? null : (Node)this.tree.map.get(object);
    }

    @NotNull
    private List<Node> getEntryChildren(Object object) {
        Node node = this.getEntry(object);
        if (node == null) {
            return Collections.emptyList();
        }
        if (node.isLoadingRequired()) {
            this.promiseChildren(node);
        }
        return node.getChildren();
    }

    @NotNull
    private TreeModelEvent createEvent(@NotNull TreePath path, Map<Object, Integer> map2) {
        if (map2 == null || map2.isEmpty()) {
            return new TreeModelEvent((Object)this, path, null, null);
        }
        int i2 = 0;
        int size = map2.size();
        int[] indices = new int[size];
        Object[] children2 = new Object[size];
        for (Map.Entry<Object, Integer> entry : map2.entrySet()) {
            indices[i2] = entry.getValue();
            children2[i2] = entry.getKey();
            ++i2;
        }
        return new TreeModelEvent((Object)this, path, indices, children2);
    }

    private void treeNodesChanged(@NotNull Node node, Map<Object, Integer> map2) {
        if (!this.listeners.isEmpty()) {
            for (TreePath path : node.paths) {
                this.listeners.treeNodesChanged(this.createEvent(path, map2));
            }
        }
    }

    private void treeNodesInserted(@NotNull Node node, Map<Object, Integer> map2) {
        if (!this.listeners.isEmpty()) {
            for (TreePath path : node.paths) {
                this.listeners.treeNodesInserted(this.createEvent(path, map2));
            }
        }
    }

    private void treeNodesRemoved(@NotNull Node node, Map<Object, Integer> map2) {
        if (!this.listeners.isEmpty()) {
            for (TreePath path : node.paths) {
                this.listeners.treeNodesRemoved(this.createEvent(path, map2));
            }
        }
    }

    @NotNull
    private static LinkedHashMap<Object, Integer> getIndices(@NotNull List<Node> children2, @Nullable ToIntFunction<? super Node> function) {
        LinkedHashMap<Object, Integer> map2 = new LinkedHashMap<Object, Integer>();
        for (int i2 = 0; i2 < children2.size(); ++i2) {
            Node child2 = children2.get(i2);
            if (map2.containsKey(child2.object)) {
                LOG.warn("ignore duplicated " + (function == null ? "old" : "new") + " child at " + i2);
                continue;
            }
            map2.put(child2.object, function == null ? i2 : function.applyAsInt(child2));
        }
        return map2;
    }

    private static int getIntersectionCount(@NotNull Map<Object, Integer> indices, @NotNull Iterable<Object> objects) {
        int count = 0;
        int last = -1;
        for (Object object : objects) {
            Integer index = indices.get(object);
            if (index == null || last >= index) continue;
            last = index;
            ++count;
        }
        return count;
    }

    @NotNull
    private static List<Object> getIntersection(@NotNull Map<Object, Integer> indices, @NotNull Iterable<Object> objects) {
        ArrayList<Object> list2 = new ArrayList<Object>(indices.size());
        int last = -1;
        for (Object object : objects) {
            Integer index = indices.get(object);
            if (index == null || last >= index) continue;
            last = index;
            list2.add(object);
        }
        return list2;
    }

    @NotNull
    private static List<Object> getIntersection(@NotNull Map<Object, Integer> removed, @NotNull Map<Object, Integer> inserted) {
        int countTwo;
        if (removed.isEmpty() || inserted.isEmpty()) {
            return Collections.emptyList();
        }
        int countOne = AsyncTreeModel.getIntersectionCount(removed, inserted.keySet());
        if (countOne > (countTwo = AsyncTreeModel.getIntersectionCount(inserted, removed.keySet()))) {
            return AsyncTreeModel.getIntersection(removed, inserted.keySet());
        }
        if (countTwo > 0) {
            return AsyncTreeModel.getIntersection(inserted, removed.keySet());
        }
        return Collections.emptyList();
    }

    protected void treeStructureChanged(TreePath path, int[] indices, Object[] children2) {
        try {
            super.treeStructureChanged(path, indices, children2);
        }
        catch (Throwable throwable) {
            LOG.error("custom model: " + this.model, throwable);
        }
    }

    protected void treeNodesChanged(TreePath path, int[] indices, Object[] children2) {
        try {
            super.treeNodesChanged(path, indices, children2);
        }
        catch (Throwable throwable) {
            LOG.error("custom model: " + this.model, throwable);
        }
    }

    protected void treeNodesInserted(TreePath path, int[] indices, Object[] children2) {
        try {
            super.treeNodesInserted(path, indices, children2);
        }
        catch (Throwable throwable) {
            LOG.error("custom model: " + this.model, throwable);
        }
    }

    protected void treeNodesRemoved(TreePath path, int[] indices, Object[] children2) {
        try {
            super.treeNodesRemoved(path, indices, children2);
        }
        catch (Throwable throwable) {
            LOG.error("custom model: " + this.model, throwable);
        }
    }

    @Deprecated
    public void setRootImmediately(@NotNull Object object) {
        Node node = new Node(object, LeafState.NEVER);
        node.insertPath(new TreePath(object));
        this.tree.root = node;
        this.tree.map.put(object, node);
    }

    private static final class Node {
        private final CommandQueue<CmdGetChildren> queue = new CommandQueue();
        private final Set<TreePath> paths = new SmartHashSet();
        private volatile Object object;
        private volatile LeafState leafState;
        @Nullable
        private volatile List<Node> children;
        private volatile Node loading;

        private Node(@NotNull Object object, @NotNull LeafState leafState) {
            this.object = object;
            this.leafState = leafState;
        }

        private void setLeafState(@NotNull LeafState leafState) {
            this.leafState = leafState;
            this.children = leafState == LeafState.ALWAYS ? null : Collections.emptyList();
            this.loading = null;
        }

        private void setChildren(@NotNull List<Node> children2) {
            this.leafState = LeafState.NEVER;
            this.children = children2;
            this.loading = null;
        }

        private void setLoading(Node loading) {
            this.leafState = LeafState.NEVER;
            this.children = loading != null ? Collections.singletonList(loading) : Collections.emptyList();
            this.loading = loading;
        }

        private boolean isLoadingRequired() {
            return this.leafState != LeafState.ALWAYS && this.children == null;
        }

        @NotNull
        private List<Node> getChildren() {
            List<Node> list2 = this.children;
            return list2 != null ? list2 : Collections.emptyList();
        }

        private void forEachChildExceptLoading(Consumer<? super Node> consumer) {
            for (Node node : this.getChildren()) {
                if (node == this.loading) continue;
                consumer.accept(node);
            }
        }

        private void insertPath(@NotNull TreePath path) {
            if (!this.paths.add(path)) {
                LOG.warn("node is already attached to " + path);
            }
            this.forEachChildExceptLoading(child2 -> child2.insertPath(path.pathByAddingChild(child2.object)));
        }

        private void insertMapping(Node parent) {
            if (parent == null) {
                this.insertPath(new TreePath(this.object));
            } else if (parent.loading == this) {
                LOG.warn("insert loading node unexpectedly");
            } else if (parent.paths.isEmpty()) {
                LOG.warn("insert to invalid parent");
            } else {
                parent.paths.forEach(path -> this.insertPath(path.pathByAddingChild(this.object)));
            }
        }

        private void removePath(@NotNull TreePath path) {
            if (!this.paths.remove(path)) {
                LOG.warn("node is not attached to " + path);
            }
            this.forEachChildExceptLoading(child2 -> child2.removePath(path.pathByAddingChild(child2.object)));
        }

        private void removeMapping(Node parent, @NotNull Tree tree) {
            if (parent == null) {
                this.removePath(new TreePath(this.object));
                tree.removeEmpty(this);
            } else if (parent.loading == this) {
                parent.loading = null;
            } else if (parent.paths.isEmpty()) {
                LOG.warn("remove from invalid parent");
            } else {
                parent.paths.forEach(path -> this.removePath(path.pathByAddingChild(this.object)));
                tree.removeEmpty(this);
            }
        }

        private void updatePaths(@NotNull Object oldObject, @NotNull Object newObject) {
            if (this.paths.stream().anyMatch(path -> Node.contains(path, oldObject))) {
                List updated = ContainerUtil.map(this.paths, path -> Node.update(path, oldObject, newObject));
                this.paths.clear();
                this.paths.addAll(updated);
                this.forEachChildExceptLoading(child2 -> child2.updatePaths(oldObject, newObject));
            }
        }

        @NotNull
        private static TreePath update(@NotNull TreePath path, @NotNull Object oldObject, @NotNull Object newObject) {
            if (!Node.contains(path, oldObject)) {
                return path;
            }
            LOG.debug("update path: ", new Object[]{path});
            Object[] objects = TreePathUtil.convertTreePathToArray(path);
            for (int i2 = 0; i2 < objects.length; ++i2) {
                if (oldObject != objects[i2]) continue;
                objects[i2] = newObject;
            }
            return TreePathUtil.convertArrayToTreePath(objects);
        }

        private static boolean contains(@NotNull TreePath path, @NotNull Object object) {
            while (object != path.getLastPathComponent()) {
                if ((path = path.getParentPath()) != null) continue;
                return false;
            }
            return true;
        }
    }

    private static final class Tree {
        private final CommandQueue<CmdGetRoot> queue = new CommandQueue();
        private final Map<Object, Node> map = new HashMap<Object, Node>();
        private volatile Node root;

        private Tree() {
        }

        private void removeEmpty(@NotNull Node child2) {
            child2.forEachChildExceptLoading(this::removeEmpty);
            if (child2.paths.isEmpty()) {
                child2.queue.close();
                Node node = this.map.remove(child2.object);
                if (node != child2) {
                    LOG.warn("invalid node: " + child2.object);
                    if (node != null) {
                        this.map.put(node.object, node);
                    }
                }
            }
        }

        private void fixEqualButNotSame(@NotNull Node node, @NotNull Object object) {
            if (object == node.object) {
                return;
            }
            this.map.remove(node.object);
            node.updatePaths(node.object, object);
            node.object = object;
            this.map.put(object, node);
        }
    }

    private static final class CommandQueue<T extends Command> {
        private final Deque<T> deque = new ArrayDeque<T>();
        private volatile boolean closed;

        private CommandQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        T get() {
            Deque<T> deque = this.deque;
            synchronized (deque) {
                return (T)((Command)this.deque.peekFirst());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        Promise<Node> promise(@NotNull Consumer<Command> submitter, @NotNull Supplier<? extends T> supplier2) {
            Command command;
            Deque<T> deque = this.deque;
            synchronized (deque) {
                command = (Command)this.deque.peekFirst();
                if (command != null) {
                    return command.promise;
                }
                command = (Command)supplier2.get();
            }
            submitter.accept(command);
            return command.promise;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(@NotNull T command, @NotNull Predicate<? super T> predicate) {
            Deque<T> deque = this.deque;
            synchronized (deque) {
                boolean add2;
                if (this.closed) {
                    return;
                }
                Command old = (Command)this.deque.peekFirst();
                boolean bl = add2 = old == null || predicate.test(old);
                if (add2) {
                    this.deque.addFirst(command);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void done(@NotNull T command, Node node) {
            Iterable<AsyncPromise<Node>> promises;
            Deque<T> deque = this.deque;
            synchronized (deque) {
                if (this.closed) {
                    return;
                }
                if (!this.deque.contains(command)) {
                    return;
                }
                promises = this.getPromises(command);
                if (this.deque.isEmpty()) {
                    this.deque.addLast(command);
                }
            }
            promises.forEach(promise -> promise.setResult((Object)node));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            Iterable<AsyncPromise<Node>> promises;
            Deque<T> deque = this.deque;
            synchronized (deque) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                if (this.deque.isEmpty()) {
                    return;
                }
                promises = this.getPromises(null);
            }
            promises.forEach(promise -> promise.setError("cancel loading"));
        }

        @NotNull
        private Iterable<AsyncPromise<Node>> getPromises(T command) {
            Command last;
            ArrayList<AsyncPromise<Node>> list2 = new ArrayList<AsyncPromise<Node>>();
            while ((last = (Command)this.deque.pollLast()) != null) {
                if (last.isPending()) {
                    list2.add(last.promise);
                }
                if (!last.equals(command)) continue;
                break;
            }
            return list2;
        }
    }

    private final class CmdGetChildren
    extends Command {
        private final Node node;
        private volatile boolean deep;

        CmdGetChildren(@NotNull String name, Node node, boolean deep) {
            super(name, node.object);
            this.node = node;
            if (deep) {
                this.deep = true;
            }
            node.queue.add(this, old -> {
                if (!deep && old.deep && old.isPending()) {
                    this.deep = true;
                }
                return true;
            });
        }

        public boolean isObsolete() {
            return AsyncTreeModel.this.disposed || this != this.node.queue.get();
        }

        @Override
        Node getNode(Object object) {
            Node loaded = new Node(object, LeafState.get((Object)object, (TreeModel)AsyncTreeModel.this.model));
            if (loaded.leafState == LeafState.ALWAYS || this.isObsolete()) {
                return loaded;
            }
            if (AsyncTreeModel.this.model instanceof ChildrenProvider) {
                ChildrenProvider provider = (ChildrenProvider)((Object)AsyncTreeModel.this.model);
                List children2 = provider.getChildren(object);
                if (children2 == null) {
                    throw new ProcessCanceledException();
                }
                loaded.children = this.load(children2.size(), index -> children2.get(index));
            } else {
                loaded.children = this.load(AsyncTreeModel.this.model.getChildCount(object), index -> AsyncTreeModel.this.model.getChild(object, index));
            }
            return loaded;
        }

        @Nullable
        private List<Node> load(int count, @NotNull IntFunction<?> function) {
            if (count < 0) {
                LOG.warn("illegal child count: " + count);
            }
            if (count <= 0) {
                return Collections.emptyList();
            }
            Object set = count == 1 ? new SmartHashSet() : new HashSet(count);
            ArrayList<Node> children2 = new ArrayList<Node>(count);
            for (int i2 = 0; i2 < count; ++i2) {
                ProgressManager.checkCanceled();
                if (this.isObsolete()) {
                    return null;
                }
                Object child2 = function.apply(i2);
                if (child2 == null) {
                    LOG.warn("ignore null child at " + i2);
                    continue;
                }
                if (!set.add(child2)) {
                    LOG.warn("ignore duplicated child at " + i2 + ": " + child2);
                    continue;
                }
                if (this.isObsolete()) {
                    return null;
                }
                children2.add(new Node(child2, LeafState.get(child2, (TreeModel)AsyncTreeModel.this.model)));
            }
            return children2;
        }

        @Override
        void setNode(Node loaded) {
            if (loaded == null || loaded.isLoadingRequired()) {
                LOG.debug("cancelled command: ", new Object[]{this});
                return;
            }
            if (this.node != AsyncTreeModel.this.tree.map.get(loaded.object)) {
                this.node.queue.close();
                LOG.warn("ignore removed node: " + this.node.object);
                return;
            }
            List oldChildren = this.node.getChildren();
            ArrayList newChildren = loaded.getChildren();
            if (oldChildren.isEmpty() && newChildren.isEmpty()) {
                this.node.setLeafState(loaded.leafState);
                AsyncTreeModel.this.treeNodesChanged(this.node, null);
                LOG.debug("no children: ", new Object[]{this.node.object});
                this.node.queue.done(this, this.node);
                return;
            }
            LinkedHashMap removed = AsyncTreeModel.getIndices(oldChildren, null);
            if (newChildren.isEmpty()) {
                oldChildren.forEach(child2 -> ((Node)child2).removeMapping(this.node, AsyncTreeModel.this.tree));
                this.node.setLeafState(loaded.leafState);
                AsyncTreeModel.this.treeNodesRemoved(this.node, removed);
                LOG.debug("children removed: ", new Object[]{this.node.object});
                this.node.queue.done(this, this.node);
                return;
            }
            ArrayList list2 = new ArrayList(newChildren.size());
            SmartHashSet reload = new SmartHashSet();
            LinkedHashMap inserted = AsyncTreeModel.getIndices(newChildren, child2 -> {
                Node found = (Node)AsyncTreeModel.this.tree.map.get(((Node)child2).object);
                if (found == null) {
                    AsyncTreeModel.this.tree.map.put(((Node)child2).object, child2);
                    list2.add(child2);
                } else {
                    AsyncTreeModel.this.tree.fixEqualButNotSame(found, ((Node)child2).object);
                    list2.add(found);
                    if (found.leafState == LeafState.ALWAYS) {
                        if (((Node)child2).leafState != LeafState.ALWAYS) {
                            found.setLeafState(((Node)child2).leafState);
                            reload.add(found.object);
                        }
                    } else if (((Node)child2).leafState == LeafState.ALWAYS || !found.isLoadingRequired() && (this.deep || !removed.containsKey(found.object))) {
                        reload.add(found.object);
                    }
                }
                return list2.size() - 1;
            });
            newChildren = list2;
            if (oldChildren.isEmpty()) {
                newChildren.forEach(child2 -> ((Node)child2).insertMapping(this.node));
                this.node.setChildren(newChildren);
                AsyncTreeModel.this.treeNodesInserted(this.node, inserted);
                LOG.debug("children inserted: ", new Object[]{this.node.object});
                this.node.queue.done(this, this.node);
                return;
            }
            LinkedHashMap contained = new LinkedHashMap();
            for (Object object : AsyncTreeModel.getIntersection((Map<Object, Integer>)removed, inserted)) {
                Integer newIndex;
                Integer oldIndex = (Integer)removed.remove(object);
                if (oldIndex == null) {
                    LOG.warn("intersection failed");
                }
                if ((newIndex = (Integer)inserted.remove(object)) == null) {
                    LOG.warn("intersection failed");
                    continue;
                }
                contained.put(object, newIndex);
            }
            for (Node child3 : newChildren) {
                if (removed.containsKey(child3.object) || !inserted.containsKey(child3.object)) continue;
                child3.insertMapping(this.node);
            }
            for (Node child3 : oldChildren) {
                if (!removed.containsKey(child3.object) || inserted.containsKey(child3.object)) continue;
                child3.removeMapping(this.node, AsyncTreeModel.this.tree);
            }
            this.node.setChildren(newChildren);
            if (!removed.isEmpty()) {
                AsyncTreeModel.this.treeNodesRemoved(this.node, removed);
            }
            if (!inserted.isEmpty()) {
                AsyncTreeModel.this.treeNodesInserted(this.node, inserted);
            }
            if (!contained.isEmpty()) {
                AsyncTreeModel.this.treeNodesChanged(this.node, contained);
            }
            if (removed.isEmpty() && inserted.isEmpty()) {
                AsyncTreeModel.this.treeNodesChanged(this.node, null);
            }
            LOG.debug("children changed: ", new Object[]{this.node.object});
            if (!reload.isEmpty()) {
                for (Node child3 : newChildren) {
                    if (!reload.contains(child3.object)) continue;
                    AsyncTreeModel.this.submit(new CmdGetChildren("Update children recursively", child3, true));
                }
            }
            this.node.queue.done(this, this.node);
        }
    }

    private final class CmdGetRoot
    extends Command {
        private CmdGetRoot(String name, Object object) {
            super(name, object);
            AsyncTreeModel.this.tree.queue.add(this, old -> old.started || old.object != object);
        }

        public boolean isObsolete() {
            return AsyncTreeModel.this.disposed || this != AsyncTreeModel.this.tree.queue.get();
        }

        @Override
        Node getNode(Object object) {
            if (object == null) {
                object = AsyncTreeModel.this.model.getRoot();
            }
            if (object == null || this.isObsolete()) {
                return null;
            }
            return new Node(object, LeafState.get((Object)object, (TreeModel)AsyncTreeModel.this.model));
        }

        @Override
        void setNode(Node loaded) {
            Node root = AsyncTreeModel.this.tree.root;
            if (root == null && loaded == null) {
                LOG.debug("no root");
                AsyncTreeModel.this.tree.queue.done(this, null);
                return;
            }
            if (root != null && loaded != null && root.object.equals(loaded.object)) {
                AsyncTreeModel.this.tree.fixEqualButNotSame(root, loaded.object);
                LOG.debug("same root: ", new Object[]{root.object});
                if (!root.isLoadingRequired()) {
                    AsyncTreeModel.this.submit(new CmdGetChildren("Update root children", root, true));
                }
                AsyncTreeModel.this.tree.queue.done(this, root);
                return;
            }
            if (root != null) {
                root.removeMapping(null, AsyncTreeModel.this.tree);
            }
            if (!AsyncTreeModel.this.tree.map.isEmpty()) {
                AsyncTreeModel.this.tree.map.values().forEach(node -> {
                    ((Node)node).queue.close();
                    LOG.warn("remove staled node: " + ((Node)node).object);
                });
                AsyncTreeModel.this.tree.map.clear();
            }
            AsyncTreeModel.this.tree.root = loaded;
            if (loaded != null) {
                AsyncTreeModel.this.tree.map.put(loaded.object, loaded);
                TreePath path = new TreePath(loaded.object);
                loaded.insertPath(path);
                AsyncTreeModel.this.treeStructureChanged(path, null, null);
                LOG.debug("new root: ", new Object[]{loaded.object});
                AsyncTreeModel.this.tree.queue.done(this, loaded);
            } else {
                AsyncTreeModel.this.treeStructureChanged(null, null, null);
                LOG.debug("root removed");
                AsyncTreeModel.this.tree.queue.done(this, null);
            }
        }
    }

    private static abstract class Command
    implements Obsolescent,
    Supplier<Node>,
    Consumer<Node> {
        final AsyncPromise<Node> promise = new AsyncPromise();
        final String name;
        final Object object;
        volatile boolean started;

        Command(@NotNull String name, Object object) {
            this.name = name;
            this.object = object;
            LOG.debug("create command: ", new Object[]{this});
        }

        abstract Node getNode(Object var1);

        abstract void setNode(Node var1);

        boolean isPending() {
            return Promise.State.PENDING == this.promise.getState();
        }

        public String toString() {
            return this.object == null ? this.name : this.name + ": " + this.object;
        }

        @Override
        public Node get() {
            this.started = true;
            if (this.isObsolete()) {
                LOG.debug("obsolete command: ", new Object[]{this});
                return null;
            }
            LOG.debug("background command: ", new Object[]{this});
            return this.getNode(this.object);
        }

        @Override
        public void accept(Node node) {
            if (this.isObsolete()) {
                LOG.debug("obsolete command: ", new Object[]{this});
            } else {
                LOG.debug("foreground command: ", new Object[]{this});
                this.setNode(node);
            }
        }
    }
}

