/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.NonProjectFilesScope;
import com.intellij.psi.search.scope.impl.CustomScopesAggregator;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.tabs.FileColorConfiguration;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileColorsModel
implements Cloneable {
    public static final String FILE_COLOR = "fileColor";
    private final List<FileColorConfiguration> myApplicationLevelConfigurations = new ArrayList<FileColorConfiguration>();
    private final List<FileColorConfiguration> myProjectLevelConfigurations = new ArrayList<FileColorConfiguration>();
    private final Map<String, String> myPredefinedScopeNameToPropertyKey = new THashMap();
    private final Map<String, String> myPredefinedScopeNameToColor = new THashMap();
    @NotNull
    private final Project myProject;

    FileColorsModel(@NotNull Project project) {
        this.myProject = project;
        this.initPredefinedAndGlobalScopes();
    }

    private FileColorsModel(@NotNull Project project, @NotNull List<? extends FileColorConfiguration> applicationLevel, @NotNull List<? extends FileColorConfiguration> projectLevel) {
        this.myProject = project;
        this.myApplicationLevelConfigurations.addAll(applicationLevel);
        this.myProjectLevelConfigurations.addAll(projectLevel);
        this.initPredefinedAndGlobalScopes();
    }

    private void initPredefinedAndGlobalScopes() {
        String colorName;
        for (NamedScope scope : CustomScopesAggregator.getAllCustomScopes(this.myProject)) {
            String scopeName = scope.getName();
            colorName = scope.getDefaultColorName();
            if (StringUtil.isEmpty((String)colorName)) continue;
            this.myPredefinedScopeNameToColor.put(scopeName, colorName);
            String propertyKey = NonProjectFilesScope.NAME.equals(scopeName) ? "file.colors.enable.non.project" : ("Tests".equals(scopeName) ? "file.colors.enable.tests" : "file.colors.enable.custom." + scopeName);
            this.myPredefinedScopeNameToPropertyKey.put(scopeName, propertyKey);
        }
        PropertiesComponent propertyComponent = PropertiesComponent.getInstance();
        for (String scopeName : this.myPredefinedScopeNameToPropertyKey.keySet()) {
            if (this.findConfiguration(scopeName, false) != null || (colorName = this.getColorNameForScope(propertyComponent, scopeName, this.myPredefinedScopeNameToPropertyKey)).isEmpty()) continue;
            Color color = ColorUtil.fromHex((String)colorName, null);
            String name = color == null ? null : FileColorManagerImpl.getColorName(color);
            this.myApplicationLevelConfigurations.add(new FileColorConfiguration(scopeName, name == null ? colorName : name));
        }
    }

    private String getColorNameForScope(PropertiesComponent propertyComponent, String scopeName, Map<String, String> scopeNameMap) {
        String colorName = propertyComponent.getValue(scopeNameMap.get(scopeName));
        if (colorName == null && (colorName = propertyComponent.getValue(scopeName)) == null) {
            colorName = this.myPredefinedScopeNameToColor.get(scopeName);
        }
        return colorName;
    }

    @NotNull
    Element save(boolean isProjectLevel) {
        Element e = new Element("state");
        List<FileColorConfiguration> configurations = isProjectLevel ? this.myProjectLevelConfigurations : this.myApplicationLevelConfigurations;
        for (FileColorConfiguration configuration : configurations) {
            String propertyKey;
            String scopeName = configuration.getScopeName();
            String string = propertyKey = isProjectLevel ? null : this.myPredefinedScopeNameToPropertyKey.get(scopeName);
            if (propertyKey == null) {
                configuration.save(e);
                continue;
            }
            PropertiesComponent propertyComponent = PropertiesComponent.getInstance();
            propertyComponent.setValue(propertyKey, configuration.getColorName(), this.myPredefinedScopeNameToColor.get(scopeName));
            PropertiesComponent.getInstance().setValue(scopeName, null);
        }
        return e;
    }

    public void load(@NotNull Element e, boolean isProjectLevel) {
        List<FileColorConfiguration> configurations = isProjectLevel ? this.myProjectLevelConfigurations : this.myApplicationLevelConfigurations;
        configurations.clear();
        THashMap predefinedScopeNameToPropertyKey = new THashMap(this.myPredefinedScopeNameToPropertyKey);
        for (Element child2 : e.getChildren(FILE_COLOR)) {
            FileColorConfiguration configuration = FileColorConfiguration.load(child2);
            if (configuration == null) continue;
            if (!isProjectLevel) {
                predefinedScopeNameToPropertyKey.remove(configuration.getScopeName());
            }
            configurations.add(configuration);
        }
        if (!isProjectLevel) {
            PropertiesComponent properties = PropertiesComponent.getInstance();
            for (String scopeName : predefinedScopeNameToPropertyKey.keySet()) {
                String colorName = this.getColorNameForScope(properties, scopeName, (Map<String, String>)predefinedScopeNameToPropertyKey);
                if (StringUtil.isEmpty((String)colorName)) continue;
                configurations.add(new FileColorConfiguration(scopeName, colorName));
            }
        }
    }

    public FileColorsModel clone() throws CloneNotSupportedException {
        ArrayList<FileColorConfiguration> applicationLevel = new ArrayList<FileColorConfiguration>();
        for (FileColorConfiguration configuration : this.myApplicationLevelConfigurations) {
            applicationLevel.add(configuration.clone());
        }
        ArrayList<FileColorConfiguration> projectLevel = new ArrayList<FileColorConfiguration>();
        for (FileColorConfiguration configuration : this.myProjectLevelConfigurations) {
            projectLevel.add(configuration.clone());
        }
        return new FileColorsModel(this.myProject, applicationLevel, projectLevel);
    }

    public void add(@NotNull FileColorConfiguration configuration, boolean isProjectLevel) {
        List<FileColorConfiguration> configurations;
        List<FileColorConfiguration> list2 = configurations = isProjectLevel ? this.myProjectLevelConfigurations : this.myApplicationLevelConfigurations;
        if (!configurations.contains(configuration)) {
            configurations.add(configuration);
        }
    }

    public void add(@NotNull String scopeName, @NotNull String colorName, boolean isProjectLevel) {
        this.add(new FileColorConfiguration(scopeName, colorName), isProjectLevel);
    }

    @Nullable
    private FileColorConfiguration findConfiguration(@NotNull String scopeName, boolean isProjectLevel) {
        List<FileColorConfiguration> configurations = isProjectLevel ? this.myProjectLevelConfigurations : this.myApplicationLevelConfigurations;
        for (FileColorConfiguration configuration : configurations) {
            if (!scopeName.equals(configuration.getScopeName())) continue;
            return configuration;
        }
        return null;
    }

    public boolean isProjectLevel(@NotNull String scopeName) {
        return this.findConfiguration(scopeName, true) != null;
    }

    @Nullable
    public String getColor(@NotNull PsiFile psiFile) {
        if (!psiFile.isValid()) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        return virtualFile == null ? null : this.getColor(virtualFile, psiFile.getProject());
    }

    @Nullable
    public String getColor(@NotNull VirtualFile file2, Project project) {
        if (!file2.isValid()) {
            return null;
        }
        FileColorConfiguration configuration = this.findConfiguration(file2);
        if (configuration != null && configuration.isValid(project)) {
            return configuration.getColorName();
        }
        return null;
    }

    @Nullable
    public String getScopeColor(@NotNull String scopeName, Project project) {
        FileColorConfiguration configuration = null;
        for (FileColorConfiguration each : this.getConfigurations()) {
            if (!scopeName.equals(each.getScopeName())) continue;
            configuration = each;
            break;
        }
        if (configuration != null && configuration.isValid(project)) {
            return configuration.getColorName();
        }
        return null;
    }

    @Nullable
    private FileColorConfiguration findConfiguration(@NotNull VirtualFile colored) {
        for (FileColorConfiguration configuration : this.getConfigurations()) {
            NamedScope scope = NamedScopesHolder.getScope((Project)this.myProject, (String)configuration.getScopeName());
            if (scope == null) continue;
            NamedScopesHolder namedScopesHolder = NamedScopesHolder.getHolder((Project)this.myProject, (String)configuration.getScopeName(), null);
            PackageSet packageSet = scope.getValue();
            if (!(packageSet instanceof PackageSetBase) || namedScopesHolder == null || !((PackageSetBase)packageSet).contains(colored, this.myProject, namedScopesHolder)) continue;
            return configuration;
        }
        return null;
    }

    @NotNull
    private List<FileColorConfiguration> getConfigurations() {
        return ContainerUtil.concat(this.myApplicationLevelConfigurations, this.myProjectLevelConfigurations);
    }

    public boolean isProjectLevel(@NotNull FileColorConfiguration configuration) {
        return this.myProjectLevelConfigurations.contains(configuration);
    }

    public void setConfigurations(@NotNull List<? extends FileColorConfiguration> configurations, boolean isProjectLevel) {
        if (isProjectLevel) {
            this.myProjectLevelConfigurations.clear();
            this.myProjectLevelConfigurations.addAll(configurations);
        } else {
            this.myApplicationLevelConfigurations.clear();
            THashMap predefinedScopeNameToPropertyKey = new THashMap(this.myPredefinedScopeNameToPropertyKey);
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
            for (FileColorConfiguration fileColorConfiguration : configurations) {
                this.myApplicationLevelConfigurations.add(fileColorConfiguration);
                String propertyKey = (String)predefinedScopeNameToPropertyKey.remove(fileColorConfiguration.getScopeName());
                if (propertyKey == null) continue;
                propertiesComponent.setValue(propertyKey, fileColorConfiguration.getColorName());
            }
            for (String string : predefinedScopeNameToPropertyKey.keySet()) {
                propertiesComponent.setValue((String)predefinedScopeNameToPropertyKey.get(string), "");
                propertiesComponent.setValue(string, null);
            }
        }
    }

    public boolean isColored(@NotNull String scopeName, boolean isProjectLevel) {
        return this.findConfiguration(scopeName, isProjectLevel) != null;
    }

    public List<FileColorConfiguration> getLocalConfigurations() {
        return this.myApplicationLevelConfigurations;
    }

    @NotNull
    public List<FileColorConfiguration> getProjectLevelConfigurations() {
        return this.myProjectLevelConfigurations;
    }
}

