/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.list;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBoxPopupState;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.ListPopupModel;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComboBoxPopup<T>
extends ListPopupImpl {
    private final Context<T> myContext;

    public ComboBoxPopup(@NotNull Context<T> context, @Nullable T selectedItem, @NotNull Consumer<? super T> onItemSelected2) {
        this(context, null, ComboBoxPopup.popupStateFromContext(context, onItemSelected2, selectedItem), null);
    }

    private ComboBoxPopup(@NotNull Context<T> context, @Nullable WizardPopup aParent, @NotNull MyBasePopupState<T> aStep, @Nullable Object parentValue) {
        super(context.getProject(), aParent, (ListPopupStep)aStep, parentValue);
        this.myContext = context;
        this.configurePopup();
    }

    @NotNull
    private static <T> MyBasePopupState<T> popupStateFromContext(final @NotNull Context<T> context, @NotNull Consumer<? super T> onItemSelected2, @Nullable T selectedItem) {
        MyBasePopupState step = new MyBasePopupState<T>(onItemSelected2, () -> context.getModel(), () -> context.getRenderer()){

            public void canceled() {
                context.onPopupStepCancelled();
            }
        };
        if (selectedItem != null) {
            step.setDefaultOptionIndex(step.getValues().indexOf(selectedItem));
        }
        return step;
    }

    public void syncWithModelChange() {
        this.disposeChildren();
        MyBasePopupState step = (MyBasePopupState)this.getStep();
        List values2 = step.getValues();
        values2.clear();
        values2.addAll(ComboBoxPopup.copyItemsFromModel(this.myContext.getModel()));
        JList<T> popupList = this.getList();
        ((ListPopupModel)popupList.getModel()).syncModel();
        JComponent content2 = this.getContent();
        content2.setPreferredSize(null);
        Dimension newSize = content2.getPreferredSize();
        content2.setPreferredSize(newSize);
        this.setSize(newSize);
        this.moveToFitScreen();
    }

    @Override
    @NotNull
    protected WizardPopup createPopup(WizardPopup parent, PopupStep step, Object parentValue) {
        if (step instanceof MyBasePopupState) {
            return new ComboBoxPopup<T>(this.myContext, parent, (MyBasePopupState)step, parentValue);
        }
        throw new IllegalArgumentException(step.getClass().toString());
    }

    @Override
    public JList<T> getList() {
        return super.getList();
    }

    @Override
    protected ListCellRenderer<T> getListElementRenderer() {
        return new MyDelegateRenderer();
    }

    private void configurePopup() {
        this.setMaxRowCount(this.myContext.getMaximumRowCount());
        this.setRequestFocus(false);
        JList<T> list2 = this.getList();
        this.myContext.configureList(list2);
        list2.setSelectionForeground(UIManager.getColor("ComboBox.selectionForeground"));
        list2.setSelectionBackground(UIManager.getColor("ComboBox.selectionBackground"));
        list2.setBorder(null);
        list2.setFocusable(false);
        list2.setSelectionMode(0);
        Border border = UIManager.getBorder("ComboPopup.border");
        if (border != null) {
            this.getContent().setBorder(border);
        }
    }

    @NotNull
    private static <T> List<T> copyItemsFromModel(@NotNull ListModel<T> model) {
        ArrayList<T> items = new ArrayList<T>(model.getSize());
        int size = model.getSize();
        for (int i2 = 0; i2 < size; ++i2) {
            items.add(model.getElementAt(i2));
        }
        return items;
    }

    private static class MyBasePopupState<T>
    extends BaseListPopupStep<T> {
        private final JBList<T> myProxyList = new JBList();
        private final Consumer<? super T> myOnItemSelected;
        @NotNull
        private final Supplier<? extends ListModel<T>> myGetComboboxModel;
        private final Supplier<? extends ListCellRenderer<? super T>> myGetRenderer;

        private MyBasePopupState(@NotNull Consumer<? super T> onItemSelected2, @NotNull Supplier<? extends ListModel<T>> getComboboxModel, @NotNull Supplier<? extends ListCellRenderer<? super T>> getRenderer) {
            super(null, ComboBoxPopup.copyItemsFromModel(getComboboxModel.get()));
            this.myOnItemSelected = onItemSelected2;
            this.myGetComboboxModel = getComboboxModel;
            this.myGetRenderer = getRenderer;
        }

        @Nullable
        public PopupStep onChosen(T selectedValue, boolean finalChoice) {
            ListModel nextModel;
            ListModel<T> model = this.myGetComboboxModel.get();
            if (model instanceof ComboBoxPopupState && (nextModel = ((ComboBoxPopupState)model).onChosen(selectedValue)) != null) {
                return new MyBasePopupState<T>(this.myOnItemSelected, () -> nextModel, this.myGetRenderer);
            }
            if (selectedValue != null) {
                ApplicationManager.getApplication().invokeLater(() -> this.myOnItemSelected.accept(selectedValue));
            }
            return FINAL_CHOICE;
        }

        public boolean hasSubstep(T selectedValue) {
            ListModel<T> model = this.myGetComboboxModel.get();
            if (model instanceof ComboBoxPopupState) {
                return ((ComboBoxPopupState)model).hasSubstep(selectedValue);
            }
            return super.hasSubstep(selectedValue);
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        @NotNull
        public String getTextFor(T value2) {
            Component component2 = this.myGetRenderer.get().getListCellRendererComponent((JList<T>)this.myProxyList, value2, -1, false, false);
            return component2 instanceof TitledSeparator || component2 instanceof JSeparator ? "" : (component2 instanceof JLabel ? ((JLabel)component2).getText() : (component2 instanceof SimpleColoredComponent ? ((SimpleColoredComponent)component2).getCharSequence(false).toString() : String.valueOf(value2)));
        }

        public boolean isSelectable(T value2) {
            Component component2 = this.myGetRenderer.get().getListCellRendererComponent((JList<T>)this.myProxyList, value2, -1, false, false);
            return !(component2 instanceof TitledSeparator) && !(component2 instanceof JSeparator);
        }
    }

    private class MyDelegateRenderer
    implements ListCellRenderer<T> {
        private MyDelegateRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
            Component component2 = ComboBoxPopup.this.myContext.getRenderer().getListCellRendererComponent(list2, value2, index, isSelected, cellHasFocus);
            if (component2 instanceof JComponent && !(component2 instanceof JSeparator) && !(component2 instanceof TitledSeparator)) {
                JComponent jComponent = (JComponent)component2;
                jComponent.setBorder((Border)JBUI.Borders.empty((int)2, (int)8));
                ComboBoxPopup.this.myContext.customizeListRendererComponent(jComponent);
            }
            return component2;
        }
    }

    public static interface SelectionListener<T>
    extends EventListener {
        public void setSelectedItem(@NotNull T var1);
    }

    public static interface Context<T> {
        @Nullable
        public Project getProject();

        @NotNull
        public ListModel<T> getModel();

        @NotNull
        public ListCellRenderer<? super T> getRenderer();

        default public int getMaximumRowCount() {
            return 10;
        }

        default public void onPopupStepCancelled() {
        }

        default public void configureList(@NotNull JList<T> list2) {
        }

        default public void customizeListRendererComponent(JComponent component2) {
        }
    }
}

