/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import gnu.trove.THashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="RecentsManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class RecentsManager
implements PersistentStateComponent<Element> {
    @NonNls
    private static final String KEY_ELEMENT_NAME = "key";
    @NonNls
    private static final String RECENT_ELEMENT_NAME = "recent";
    @NonNls
    protected static final String NAME_ATTR = "name";
    private final Map<String, LinkedList<String>> myMap = new THashMap();
    private int myRecentsNumberToKeep = 5;

    @NotNull
    public static RecentsManager getInstance(@NotNull Project project) {
        return (RecentsManager)ServiceManager.getService((Project)project, RecentsManager.class);
    }

    @Nullable
    public List<String> getRecentEntries(@NotNull String key) {
        return this.myMap.get(key);
    }

    public void registerRecentEntry(@NotNull String key, String recentEntry) {
        LinkedList<String> recents = this.myMap.get(key);
        if (recents == null) {
            recents = new LinkedList();
            this.myMap.put(key, recents);
        }
        this.add(recents, recentEntry);
    }

    private void add(LinkedList<? super String> recentEntries, String newEntry) {
        int oldIndex = recentEntries.indexOf(newEntry);
        if (oldIndex >= 0) {
            recentEntries.remove(oldIndex);
        } else if (recentEntries.size() == this.myRecentsNumberToKeep) {
            recentEntries.removeLast();
        }
        recentEntries.addFirst(newEntry);
    }

    public void loadState(@NotNull Element element2) {
        this.myMap.clear();
        for (Element keyElement : element2.getChildren(KEY_ELEMENT_NAME)) {
            LinkedList<String> recents = new LinkedList<String>();
            for (Element aChildren : keyElement.getChildren(RECENT_ELEMENT_NAME)) {
                recents.addLast(aChildren.getAttributeValue(NAME_ATTR));
            }
            this.myMap.put(keyElement.getAttributeValue(NAME_ATTR), recents);
        }
    }

    public Element getState() {
        Element element2 = new Element("state");
        for (Map.Entry<String, LinkedList<String>> entry : this.myMap.entrySet()) {
            Element keyElement = new Element(KEY_ELEMENT_NAME);
            keyElement.setAttribute(NAME_ATTR, entry.getKey());
            for (String recent : entry.getValue()) {
                keyElement.addContent(new Element(RECENT_ELEMENT_NAME).setAttribute(NAME_ATTR, recent));
            }
            element2.addContent(keyElement);
        }
        return element2;
    }

    public void setRecentsNumberToKeep(int recentsNumberToKeep) {
        this.myRecentsNumberToKeep = recentsNumberToKeep;
    }
}

