/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testIntegration.LanguageTestCreators;
import com.intellij.testIntegration.TestCreator;
import com.intellij.testIntegration.TestFinderHelper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoTestOrCodeHandler
extends GotoTargetHandler {
    @Override
    protected String getFeatureUsedKey() {
        return "navigation.goto.testOrCode";
    }

    @Override
    @Nullable
    protected GotoTargetHandler.GotoData getSourceAndTargetElements(final Editor editor, final PsiFile file2) {
        Collection<PsiElement> candidates;
        PsiElement selectedElement = GotoTestOrCodeHandler.getSelectedElement(editor, file2);
        PsiElement sourceElement = TestFinderHelper.findSourceElement(selectedElement);
        if (sourceElement == null) {
            return null;
        }
        SmartList actions = new SmartList();
        if (TestFinderHelper.isTest(selectedElement)) {
            candidates = TestFinderHelper.findClassesForTest(selectedElement);
        } else {
            candidates = TestFinderHelper.findTestsForClass(selectedElement);
            for (final TestCreator creator : LanguageTestCreators.INSTANCE.allForLanguage(file2.getLanguage())) {
                if (!creator.isAvailable(file2.getProject(), editor, file2)) continue;
                actions.add(new GotoTargetHandler.AdditionalAction(){

                    @Override
                    @NotNull
                    public String getText() {
                        String text = creator instanceof ItemPresentation ? ((ItemPresentation)creator).getPresentableText() : null;
                        return (String)ObjectUtils.notNull((Object)text, (Object)"Create New Test...");
                    }

                    @Override
                    public Icon getIcon() {
                        Icon icon2 = creator instanceof ItemPresentation ? ((ItemPresentation)creator).getIcon(false) : null;
                        return (Icon)ObjectUtils.notNull((Object)icon2, (Object)AllIcons.Actions.IntentionBulb);
                    }

                    @Override
                    public void execute() {
                        creator.createTest(file2.getProject(), editor, file2);
                    }
                });
            }
        }
        return new GotoTargetHandler.GotoData(sourceElement, PsiUtilCore.toPsiElementArray(candidates), (List<GotoTargetHandler.AdditionalAction>)actions);
    }

    @NotNull
    public static PsiElement getSelectedElement(Editor editor, PsiFile file2) {
        return PsiUtilCore.getElementAtOffset((PsiFile)file2, (int)editor.getCaretModel().getOffset());
    }

    @Override
    protected boolean shouldSortTargets() {
        return false;
    }

    @Override
    @NotNull
    protected String getChooserTitle(@NotNull PsiElement sourceElement, String name, int length, boolean finished2) {
        String suffix;
        String string = suffix = finished2 ? "" : " so far";
        if (TestFinderHelper.isTest(sourceElement)) {
            return CodeInsightBundle.message((String)"goto.test.chooserTitle.subject", (Object[])new Object[]{name, length, suffix});
        }
        return CodeInsightBundle.message((String)"goto.test.chooserTitle.test", (Object[])new Object[]{name, length, suffix});
    }

    @Override
    @NotNull
    protected String getFindUsagesTitle(@NotNull PsiElement sourceElement, String name, int length) {
        if (TestFinderHelper.isTest(sourceElement)) {
            return CodeInsightBundle.message((String)"goto.test.findUsages.subject.title", (Object[])new Object[]{name});
        }
        return CodeInsightBundle.message((String)"goto.test.findUsages.test.title", (Object[])new Object[]{name});
    }

    @Override
    @NotNull
    protected String getNotFoundMessage(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        return CodeInsightBundle.message((String)"goto.test.notFound", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    protected String getAdText(PsiElement source, int length) {
        Shortcut shortcut;
        if (length > 0 && !TestFinderHelper.isTest(source) && (shortcut = KeymapUtil.getPrimaryShortcut((String)DefaultRunExecutor.getRunExecutorInstance().getContextActionId())) != null) {
            return "Press " + KeymapUtil.getShortcutText((Shortcut)shortcut) + " to run selected tests";
        }
        return null;
    }

    @Override
    protected boolean useEditorFont() {
        return false;
    }

    @Override
    protected void navigateToElement(@NotNull Navigatable element2) {
        if (element2 instanceof PsiElement) {
            NavigationUtil.activateFileWithPsiElement((PsiElement)element2, true);
        } else {
            element2.navigate(true);
        }
    }
}

