/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.context;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.tasks.context.WorkingContextProvider;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.WatchesManagerState;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.XDebuggerWatchesManager;
import java.util.Collection;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

final class XDebuggerWatchesProvider
extends WorkingContextProvider {
    XDebuggerWatchesProvider() {
    }

    @NotNull
    public String getId() {
        return "watches";
    }

    @NotNull
    public String getDescription() {
        return "Debugger watches";
    }

    public void saveContext(@NotNull Project project, @NotNull Element toElement) throws WriteExternalException {
        WatchesManagerState state = new WatchesManagerState();
        XDebuggerWatchesProvider.getWatchManager(project).saveState(state);
        Element serialize = XmlSerializer.serialize((Object)((Object)state));
        if (serialize != null) {
            toElement.addContent((Collection)serialize.removeContent());
        }
    }

    @NotNull
    private static XDebuggerWatchesManager getWatchManager(@NotNull Project project) {
        return ((XDebuggerManagerImpl)XDebuggerManager.getInstance((Project)project)).getWatchesManager();
    }

    public void loadContext(@NotNull Project project, @NotNull Element fromElement) throws InvalidDataException {
        WatchesManagerState state = (WatchesManagerState)((Object)XmlSerializer.deserialize((Element)fromElement, WatchesManagerState.class));
        XDebuggerWatchesProvider.getWatchManager(project).loadState(state);
    }

    public void clearContext(@NotNull Project project) {
        XDebuggerWatchesProvider.getWatchManager(project).clearContext();
    }
}

