/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.analysis.AnalysisScope;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.slicer.LanguageSlicing;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceUsageTransformer;
import com.intellij.slicer.SliceValueFilter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public abstract class SliceUsage
extends UsageInfo2UsageAdapter {
    private final SliceUsage myParent;
    public final SliceAnalysisParams params;

    public SliceUsage(@NotNull PsiElement element2, @NotNull SliceUsage parent) {
        this(element2, parent, parent.params);
    }

    protected SliceUsage(@NotNull PsiElement element2, @NotNull SliceUsage parent, @NotNull SliceAnalysisParams params) {
        super(new UsageInfo(element2));
        this.myParent = parent;
        this.params = params;
    }

    protected SliceUsage(@NotNull PsiElement element2, @NotNull SliceAnalysisParams params) {
        super(new UsageInfo(element2));
        this.myParent = null;
        this.params = params;
    }

    @NotNull
    private static Collection<SliceUsage> transformToLanguageSpecificUsage(@NotNull SliceUsage usage) {
        PsiElement element2 = usage.getElement();
        if (element2 == null) {
            return Collections.singletonList(usage);
        }
        SliceLanguageSupportProvider provider = LanguageSlicing.getProvider(element2);
        if (!(provider instanceof SliceUsageTransformer)) {
            return Collections.singletonList(usage);
        }
        Collection<SliceUsage> transformedUsages = ((SliceUsageTransformer)((Object)provider)).transform(usage);
        return transformedUsages != null ? transformedUsages : Collections.singletonList(usage);
    }

    public void processChildren(@NotNull Processor<? super SliceUsage> processor2) {
        PsiElement element2 = (PsiElement)ReadAction.compute(() -> ((SliceUsage)this).getElement());
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        indicator.checkCanceled();
        CommonProcessors.UniqueProcessor<SliceUsage> uniqueProcessor = new CommonProcessors.UniqueProcessor<SliceUsage>(processor2, (TObjectHashingStrategy)new TObjectHashingStrategy<SliceUsage>(){

            public int computeHashCode(SliceUsage object) {
                return object.getUsageInfo().hashCode();
            }

            public boolean equals(SliceUsage o1, SliceUsage o2) {
                return o1.getUsageInfo().equals((Object)o2.getUsageInfo());
            }
        }){

            public boolean process(SliceUsage usage) {
                PsiElement psiElement;
                SliceValueFilter filter2 = usage.params.valueFilter;
                if (filter2 != null && (psiElement = usage.getElement()) != null && !filter2.allowed(psiElement)) {
                    return true;
                }
                return SliceUsage.transformToLanguageSpecificUsage(usage).stream().allMatch(x$0 -> super.process(x$0));
            }
        };
        ApplicationManager.getApplication().runReadAction(() -> this.lambda$processChildren$0(element2, (Processor)uniqueProcessor));
    }

    protected abstract void processUsagesFlownFromThe(PsiElement var1, Processor<? super SliceUsage> var2);

    protected abstract void processUsagesFlownDownTo(PsiElement var1, Processor<? super SliceUsage> var2);

    public SliceUsage getParent() {
        return this.myParent;
    }

    @NotNull
    public AnalysisScope getScope() {
        return this.params.scope;
    }

    @NotNull
    protected abstract SliceUsage copy();

    public boolean canBeLeaf() {
        return this.getElement() != null;
    }

    private /* synthetic */ void lambda$processChildren$0(PsiElement element2, Processor uniqueProcessor) {
        if (this.params.dataFlowToThis) {
            this.processUsagesFlownDownTo(element2, (Processor<? super SliceUsage>)uniqueProcessor);
        } else {
            this.processUsagesFlownFromThe(element2, (Processor<? super SliceUsage>)uniqueProcessor);
        }
    }
}

