/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.slicer.DuplicateMap;
import com.intellij.slicer.LanguageSlicing;
import com.intellij.slicer.MyColoredTreeCellRenderer;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceTooComplexDFAUsage;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceUsageCellRendererBase;
import com.intellij.ui.DuplicateNodeRenderer;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SliceNode
extends AbstractTreeNode<SliceUsage>
implements DuplicateNodeRenderer.DuplicatableNode<SliceNode>,
MyColoredTreeCellRenderer {
    protected List<SliceNode> myCachedChildren;
    boolean dupNodeCalculated;
    protected SliceNode duplicate;
    public final DuplicateMap targetEqualUsages;
    protected boolean changed;
    private int index;

    protected SliceNode(@NotNull Project project, @NotNull SliceUsage sliceUsage, @NotNull DuplicateMap targetEqualUsages) {
        super(project, (Object)sliceUsage);
        this.targetEqualUsages = targetEqualUsages;
    }

    @NotNull
    public SliceNode copy() {
        SliceUsage newUsage = ((SliceUsage)((Object)this.getValue())).copy();
        SliceNode newNode = new SliceNode(this.getProject(), newUsage, this.targetEqualUsages);
        newNode.dupNodeCalculated = this.dupNodeCalculated;
        newNode.duplicate = this.duplicate;
        return newNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<SliceNode> getChildren() {
        if (this.isUpToDate()) {
            return this.myCachedChildren == null ? Collections.emptyList() : this.myCachedChildren;
        }
        try {
            List nodes;
            ProgressIndicator current2 = ProgressManager.getInstance().getProgressIndicator();
            if (current2 == null) {
                ProgressIndicatorBase indicator = new ProgressIndicatorBase();
                Ref nodesRef = Ref.create();
                ProgressManager.getInstance().runProcess(() -> nodesRef.set(this.doGetChildren()), (ProgressIndicator)indicator);
                nodes = (List)nodesRef.get();
            } else {
                nodes = this.doGetChildren();
            }
            List list2 = nodes;
            synchronized (list2) {
                this.myCachedChildren = nodes;
            }
            return nodes;
        }
        catch (ProcessCanceledException pce) {
            this.changed = true;
            throw pce;
        }
    }

    private List<SliceNode> doGetChildren() {
        ArrayList<SliceNode> children2 = new ArrayList<SliceNode>();
        ProgressIndicator progress2 = ProgressManager.getInstance().getProgressIndicator();
        Processor processor2 = sliceUsage -> {
            progress2.checkCanceled();
            SliceNode node = new SliceNode(this.myProject, (SliceUsage)((Object)sliceUsage), this.targetEqualUsages);
            List list2 = children2;
            synchronized (list2) {
                node.index = children2.size();
                children2.add(node);
            }
            return true;
        };
        ApplicationManagerEx.getApplicationEx().executeByImpatientReader(() -> ((SliceUsage)((Object)((Object)this.getValue()))).processChildren((Processor<? super SliceUsage>)processor2));
        return children2;
    }

    SliceNode getNext(List parentChildren) {
        return this.index == parentChildren.size() - 1 ? null : (SliceNode)parentChildren.get(this.index + 1);
    }

    SliceNode getPrev(List parentChildren) {
        return this.index == 0 ? null : (SliceNode)parentChildren.get(this.index - 1);
    }

    public List<SliceNode> getCachedChildren() {
        return this.myCachedChildren;
    }

    private boolean isUpToDate() {
        return this.myCachedChildren != null || !this.isValid();
    }

    @NotNull
    protected PresentationData createPresentation() {
        return new PresentationData(){

            public Object @NotNull [] getEqualityObjects() {
                return ArrayUtil.append((Object[])super.getEqualityObjects(), (Object)SliceNode.this.changed);
            }
        };
    }

    protected void update(@NotNull PresentationData presentation2) {
        if (presentation2 != null) {
            presentation2.setChanged(presentation2.isChanged() || this.changed);
            this.changed = false;
        }
    }

    public void calculateDupNode() {
        if (!this.dupNodeCalculated) {
            if (!(this.getValue() instanceof SliceTooComplexDFAUsage)) {
                this.duplicate = this.targetEqualUsages.putNodeCheckDupe(this);
            }
            this.dupNodeCalculated = true;
        }
    }

    @Override
    public SliceNode getDuplicate() {
        return this.duplicate;
    }

    public void navigate(boolean requestFocus) {
        SliceUsage sliceUsage = (SliceUsage)((Object)this.getValue());
        sliceUsage.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return ((SliceUsage)((Object)this.getValue())).canNavigate();
    }

    public boolean canNavigateToSource() {
        return ((SliceUsage)((Object)this.getValue())).canNavigateToSource();
    }

    public boolean isValid() {
        return (Boolean)ReadAction.compute(() -> ((SliceUsage)((Object)((Object)this.getValue()))).isValid());
    }

    public boolean expandOnDoubleClick() {
        return false;
    }

    @Override
    public void customizeCellRenderer(@NotNull SliceUsageCellRendererBase renderer, @NotNull JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        renderer.setIcon(this.getPresentation().getIcon(expanded));
        if (this.isValid()) {
            SliceUsage sliceUsage = (SliceUsage)((Object)this.getValue());
            renderer.customizeCellRendererFor(sliceUsage);
            renderer.setToolTipText(sliceUsage.getPresentation().getTooltipText());
        } else {
            renderer.append(UsageViewBundle.message((String)"node.invalid", (Object[])new Object[0]) + " ", SliceUsageCellRendererBase.ourInvalidAttributes);
        }
    }

    public void setChanged() {
        this.changed = true;
    }

    @Nullable
    public SliceLanguageSupportProvider getProvider() {
        AbstractTreeNode element2 = this.getElement();
        if (element2 == null) {
            return null;
        }
        SliceUsage usage = (SliceUsage)((Object)element2.getValue());
        if (usage == null) {
            return null;
        }
        PsiElement psiElement = usage.getElement();
        if (psiElement == null) {
            return null;
        }
        return LanguageSlicing.getProvider(psiElement);
    }

    public String getNodeText() {
        return ((SliceUsage)((Object)this.getValue())).getPresentation().getPlainText().trim();
    }

    public String toString() {
        return (String)ReadAction.compute(() -> this.getValue() == null ? "<null>" : ((SliceUsage)((Object)((Object)this.getValue()))).toString());
    }
}

