/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceLeafEquality;
import com.intellij.slicer.SliceLeafValueRootNode;
import com.intellij.slicer.SliceManager;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceRootNode;
import com.intellij.slicer.SliceUsage;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairProcessor;
import com.intellij.util.WalkingState;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class SliceLeafAnalyzer {
    private static final Logger LOG = Logger.getInstance(SliceLeafAnalyzer.class);
    @NotNull
    private final SliceLeafEquality myLeafEquality;
    @NotNull
    private final SliceLanguageSupportProvider myProvider;

    public SliceLeafAnalyzer(@NotNull SliceLeafEquality leafEquality, @NotNull SliceLanguageSupportProvider provider) {
        this.myLeafEquality = leafEquality;
        this.myProvider = provider;
    }

    public static SliceNode filterTree(SliceNode oldRoot, NullableFunction<? super SliceNode, ? extends SliceNode> filter2, PairProcessor<? super SliceNode, ? super List<SliceNode>> postProcessor) {
        boolean success;
        SliceNode filtered2 = (SliceNode)filter2.fun((Object)oldRoot);
        if (filtered2 == null) {
            return null;
        }
        ArrayList<SliceNode> childrenFiltered = new ArrayList<SliceNode>();
        if (oldRoot.myCachedChildren != null) {
            for (SliceNode child2 : oldRoot.myCachedChildren) {
                SliceNode childFiltered = SliceLeafAnalyzer.filterTree(child2, filter2, postProcessor);
                if (childFiltered == null) continue;
                childrenFiltered.add(childFiltered);
            }
        }
        boolean bl = success = postProcessor == null || postProcessor.process((Object)filtered2, childrenFiltered);
        if (!success) {
            return null;
        }
        filtered2.myCachedChildren = new ArrayList<SliceNode>(childrenFiltered);
        return filtered2;
    }

    private void groupByValues(@NotNull Collection<? extends PsiElement> leaves, @NotNull SliceRootNode oldRoot, @NotNull Map<SliceNode, Collection<PsiElement>> map2) {
        assert (oldRoot.myCachedChildren.size() == 1);
        SliceRootNode root = this.createTreeGroupedByValues(leaves, oldRoot, map2);
        SliceNode oldRootStart = (SliceNode)oldRoot.myCachedChildren.get(0);
        SliceUsage rootUsage = (SliceUsage)((Object)oldRootStart.getValue());
        String description = SliceManager.getElementDescription(null, rootUsage.getElement(), " (grouped by value)");
        SliceManager.getInstance(root.getProject()).createToolWindow(true, root, true, description);
    }

    @NotNull
    public SliceRootNode createTreeGroupedByValues(@NotNull Collection<? extends PsiElement> leaves, @NotNull SliceRootNode oldRoot, @NotNull Map<SliceNode, Collection<PsiElement>> map2) {
        SliceNode oldRootStart = (SliceNode)oldRoot.myCachedChildren.get(0);
        SliceRootNode root = oldRoot.copy();
        root.setChanged();
        root.targetEqualUsages.clear();
        ArrayList<SliceLeafValueRootNode> leafValueRoots = new ArrayList<SliceLeafValueRootNode>(leaves.size());
        for (PsiElement psiElement : leaves) {
            SliceNode newNode = SliceLeafAnalyzer.filterTree(oldRootStart, (NullableFunction<? super SliceNode, ? extends SliceNode>)((NullableFunction)oldNode -> {
                if (oldNode.getDuplicate() != null) {
                    return null;
                }
                if (!SliceLeafAnalyzer.node(oldNode, map2).contains(leafExpression)) {
                    return null;
                }
                return oldNode.copy();
            }), (PairProcessor<? super SliceNode, ? super List<SliceNode>>)((PairProcessor)(node, children2) -> {
                if (!children2.isEmpty()) {
                    return true;
                }
                PsiElement element2 = ((SliceUsage)((Object)((Object)((Object)node.getValue())))).getElement();
                if (element2 == null) {
                    return false;
                }
                return element2.getManager().areElementsEquivalent(element2, leafExpression);
            }));
            SliceLeafValueRootNode lvNode = new SliceLeafValueRootNode(root.getProject(), root, this.myProvider.createRootUsage(psiElement, ((SliceUsage)((Object)oldRoot.getValue())).params), Collections.singletonList(newNode));
            leafValueRoots.add(lvNode);
        }
        root.setChildren(leafValueRoots);
        return root;
    }

    public void startAnalyzeValues(final @NotNull AbstractTreeStructure treeStructure, final @NotNull Runnable finish) {
        final SliceRootNode root = (SliceRootNode)treeStructure.getRootElement();
        final Ref leafExpressions = Ref.create(null);
        final Map<SliceNode, Collection<PsiElement>> map2 = this.createMap();
        String encouragementPiece = " " + LangBundle.message((String)"progress.title.may.very.well.take.whole.day", (Object[])new Object[0]);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(root.getProject(), LangBundle.message((String)"progress.title.expanding.all.nodes", (Object[])new Object[]{encouragementPiece}), true){

            public void run(@NotNull ProgressIndicator indicator) {
                Collection<PsiElement> l = SliceLeafAnalyzer.this.calcLeafExpressions(root, treeStructure, map2);
                leafExpressions.set(l);
            }

            public void onCancel() {
                finish.run();
            }

            public void onSuccess() {
                try {
                    Collection leaves = (Collection)leafExpressions.get();
                    if (leaves == null) {
                        return;
                    }
                    if (leaves.isEmpty()) {
                        Messages.showErrorDialog((String)LangBundle.message((String)"dialog.message.unable.to.find.leaf.expressions.to.group.by", (Object[])new Object[0]), (String)LangBundle.message((String)"dialog.title.cannot.group", (Object[])new Object[0]));
                        return;
                    }
                    SliceLeafAnalyzer.this.groupByValues(leaves, root, map2);
                }
                finally {
                    finish.run();
                }
            }
        });
    }

    public Map<SliceNode, Collection<PsiElement>> createMap() {
        return ConcurrentFactoryMap.create(k -> ConcurrentCollectionFactory.createConcurrentSet(this.myLeafEquality), () -> ConcurrentCollectionFactory.createMap(ContainerUtil.identityStrategy()));
    }

    private static Collection<PsiElement> node(SliceNode node, Map<SliceNode, Collection<PsiElement>> map2) {
        return map2.get(node);
    }

    @NotNull
    public Collection<PsiElement> calcLeafExpressions(@NotNull SliceNode root, @NotNull AbstractTreeStructure treeStructure, final @NotNull Map<SliceNode, Collection<PsiElement>> map2) {
        final SliceNodeGuide guide = new SliceNodeGuide(treeStructure);
        final AtomicInteger depth = new AtomicInteger();
        final boolean printToLog = LOG.isTraceEnabled();
        WalkingState<SliceNode> walkingState = new WalkingState<SliceNode>((WalkingState.TreeGuide)guide){

            public void elementStarted(@NotNull SliceNode element2) {
                depth.incrementAndGet();
                super.elementStarted((Object)element2);
            }

            public void visit(@NotNull SliceNode element2) {
                element2.calculateDupNode();
                SliceLeafAnalyzer.node(element2, map2).clear();
                SliceNode duplicate = element2.getDuplicate();
                if (duplicate != null) {
                    SliceLeafAnalyzer.node(element2, map2).addAll(SliceLeafAnalyzer.node(duplicate, map2));
                } else {
                    ApplicationManager.getApplication().runReadAction(() -> {
                        PsiElement value2;
                        SliceUsage sliceUsage = (SliceUsage)((Object)((Object)element2.getValue()));
                        Collection<SliceNode> children2 = element2.getChildren();
                        if (printToLog) {
                            LOG.trace(StringUtil.repeat((String)"  ", (int)Math.max(depth.get(), 0)) + "analyzing usages of " + (Object)((Object)sliceUsage) + " (in " + (sliceUsage == null ? "null" : sliceUsage.getFile().getName() + ":" + sliceUsage.getLine()) + ")");
                        }
                        if (children2.isEmpty() && sliceUsage != null && sliceUsage.canBeLeaf() && (value2 = sliceUsage.getElement()) != null) {
                            SliceLeafAnalyzer.node(element2, map2).addAll(ContainerUtil.singleton((Object)value2, (TObjectHashingStrategy)SliceLeafAnalyzer.this.myLeafEquality));
                        }
                    });
                    super.visit((Object)element2);
                }
            }

            public void elementFinished(@NotNull SliceNode element2) {
                depth.decrementAndGet();
                SliceNode parent = guide.getParent(element2);
                if (parent != null) {
                    SliceLeafAnalyzer.node(parent, map2).addAll(SliceLeafAnalyzer.node(element2, map2));
                }
            }
        };
        walkingState.visit((Object)root);
        return SliceLeafAnalyzer.node(root, map2);
    }

    public static class SliceNodeGuide
    implements WalkingState.TreeGuide<SliceNode> {
        private final AbstractTreeStructure myTreeStructure;

        public SliceNodeGuide(@NotNull AbstractTreeStructure treeStructure) {
            this.myTreeStructure = treeStructure;
        }

        public SliceNode getNextSibling(@NotNull SliceNode element2) {
            AbstractTreeNode parent = element2.getParent();
            if (parent == null) {
                return null;
            }
            return element2.getNext((List)parent.getChildren());
        }

        public SliceNode getPrevSibling(@NotNull SliceNode element2) {
            AbstractTreeNode parent = element2.getParent();
            if (parent == null) {
                return null;
            }
            return element2.getPrev((List)parent.getChildren());
        }

        public SliceNode getFirstChild(@NotNull SliceNode element2) {
            Object[] children2 = this.myTreeStructure.getChildElements((Object)element2);
            return children2.length == 0 ? null : (SliceNode)children2[0];
        }

        public SliceNode getParent(@NotNull SliceNode element2) {
            AbstractTreeNode parent = element2.getParent();
            return parent instanceof SliceNode ? (SliceNode)parent : null;
        }
    }
}

