/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.ui;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeNodeSelector;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ui.RemoteServersView;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;

public class RemoteServersViewImpl
extends RemoteServersView {
    private final List<Pair<ServersTreeNodeSelector, Condition<ServerConnection<?>>>> mySelectors = new CopyOnWriteArrayList();

    @Override
    public void showServerConnection(@NotNull ServerConnection<?> connection) {
        ServersTreeNodeSelector selector = this.findSelector(connection);
        if (selector != null) {
            selector.select(connection);
        }
    }

    private ServersTreeNodeSelector findSelector(ServerConnection<?> connection) {
        for (Pair<ServersTreeNodeSelector, Condition<ServerConnection<?>>> pair : this.mySelectors) {
            if (!((Condition)pair.second).value(connection)) continue;
            return (ServersTreeNodeSelector)pair.first;
        }
        return null;
    }

    @Override
    public void showDeployment(@NotNull ServerConnection<?> connection, @NotNull String deploymentName) {
        ServersTreeNodeSelector selector = this.findSelector(connection);
        if (selector != null) {
            selector.select(connection, deploymentName);
        }
    }

    @Override
    public void registerTreeNodeSelector(@NotNull ServersTreeNodeSelector selector, @NotNull Condition<ServerConnection<?>> condition) {
        this.mySelectors.add(Pair.create((Object)selector, condition));
    }
}

