/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.ui;

import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.services.SimpleServiceViewDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.impl.runtime.log.DeploymentLogManagerImpl;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerBase;
import com.intellij.remoteServer.impl.runtime.ui.RemoteServersServiceViewContributor;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeStructure;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.util.ObjectUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class DefaultRemoteServersServiceViewContributor
extends RemoteServersServiceViewContributor {
    private static final ServiceViewDescriptor CONTRIBUTOR_DESCRIPTOR = new SimpleServiceViewDescriptor("Clouds", AllIcons.General.Balloon){

        public ActionGroup getToolbarActions() {
            return RemoteServersServiceViewContributor.getToolbarActions(RemoteServersServiceViewContributor.ActionGroups.SHARED_ACTION_GROUPS);
        }

        public ActionGroup getPopupActions() {
            return RemoteServersServiceViewContributor.getPopupActions(RemoteServersServiceViewContributor.ActionGroups.SHARED_ACTION_GROUPS);
        }
    };

    @NotNull
    public ServiceViewDescriptor getViewDescriptor(@NotNull Project project) {
        return CONTRIBUTOR_DESCRIPTOR;
    }

    public boolean accept(@NotNull RemoteServer server) {
        return DefaultRemoteServersServiceViewContributor.isDefaultRemoteServer(server);
    }

    public void selectLog(@NotNull AbstractTreeNode deploymentNode, @NotNull String logName) {
        ServersTreeStructure.DeploymentNodeImpl node = (ServersTreeStructure.DeploymentNodeImpl)ObjectUtils.tryCast((Object)deploymentNode, ServersTreeStructure.DeploymentNodeImpl.class);
        if (node == null) {
            return;
        }
        ServerConnection<?> connection = node.getConnection();
        if (connection == null) {
            return;
        }
        Project project = Objects.requireNonNull(node.getProject());
        DeploymentLogManagerImpl logManager = (DeploymentLogManagerImpl)connection.getLogManager(project, node.getDeployment());
        if (logManager == null) {
            return;
        }
        for (LoggingHandlerBase loggingComponent : logManager.getAdditionalLoggingHandlers()) {
            if (!logName.equals(loggingComponent.getPresentableName())) continue;
            ServersTreeStructure.DeploymentLogNode logNode = new ServersTreeStructure.DeploymentLogNode(project, loggingComponent, node);
            ServiceViewManager.getInstance((Project)project).select((Object)logNode, DefaultRemoteServersServiceViewContributor.class, true, true);
        }
    }

    @Override
    @NotNull
    public RemoteServersServiceViewContributor.ActionGroups getActionGroups() {
        return RemoteServersServiceViewContributor.ActionGroups.SHARED_ACTION_GROUPS;
    }

    @Override
    public AbstractTreeNode<?> createDeploymentNode(ServerConnection<?> connection, ServersTreeStructure.RemoteServerNode serverNode, Deployment deployment) {
        return new ServersTreeStructure.DeploymentNodeImpl(serverNode.getProject(), connection, serverNode, deployment, this);
    }

    private static boolean isDefaultRemoteServer(RemoteServer<?> server) {
        String toolWindowId = server.getConfiguration().getCustomToolWindowId();
        if (toolWindowId == null) {
            toolWindowId = server.getType().getCustomToolWindowId();
        }
        return toolWindowId == null;
    }
}

