/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote.ext;

import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.ext.RemoteCredentialsHandlerBase;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshCredentialsHandler
extends RemoteCredentialsHandlerBase<RemoteCredentialsHolder> {
    public SshCredentialsHandler(RemoteCredentialsHolder credentials) {
        super(credentials);
    }

    @Override
    @NotNull
    public String getId() {
        return this.constructSshCredentialsFullPath();
    }

    @Override
    public void save(@NotNull Element rootElement) {
        ((RemoteCredentialsHolder)this.getCredentials()).save(rootElement);
    }

    @Override
    @NotNull
    public String getPresentableDetails(String interpreterPath) {
        return "(" + this.constructSshCredentialsFullPath() + interpreterPath + ")";
    }

    @Override
    public void load(@Nullable Element rootElement) {
        if (rootElement != null) {
            ((RemoteCredentialsHolder)this.getCredentials()).load(rootElement);
        }
    }

    @NotNull
    private String constructSshCredentialsFullPath() {
        RemoteCredentials cred = (RemoteCredentials)this.getCredentials();
        return "ssh://" + cred.getUserName() + "@" + cred.getHost() + ":" + cred.getLiteralPort();
    }
}

