/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.google.common.base.Joiner;
import com.intellij.remote.RemoteFile;
import com.intellij.util.AbstractPathMapper;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoteProcessUtil {
    @Contract(value="null -> null")
    public static String toRemoteFileSystemStyle(@Nullable String path) {
        if (path == null) {
            return null;
        }
        return RemoteFile.detectSystemByPath(path).createRemoteFile(path).getPath();
    }

    public static String[] buildRemoteCommand(@NotNull AbstractPathMapper pathMapper, @NotNull Collection<String> commands) {
        return ArrayUtilRt.toStringArray((Collection)pathMapper.convertToRemote(commands));
    }

    @NotNull
    public static String remapPathsList(@NotNull String pathsValue, @NotNull PathMapper pathMapper, @NotNull String interpreterPath) {
        boolean isWin = RemoteFile.isWindowsPath(interpreterPath);
        ArrayList<String> mappedPaths = new ArrayList<String>();
        for (String path : pathsValue.split(File.pathSeparator)) {
            mappedPaths.add(new RemoteFile(pathMapper.convertToRemote(path), isWin).getPath());
        }
        return Joiner.on((char)(isWin ? (char)';' : ':')).join(mappedPaths);
    }
}

