/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.ReadWriteAccessUsageInfo2UsageAdapter;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsagePresentation;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConflictsDialog
extends DialogWrapper {
    private static final int SHOW_CONFLICTS_EXIT_CODE = 4;
    private static final int MAX_CONFLICTS_SHOWN = 20;
    @NonNls
    private static final String EXPAND_LINK = "expand";
    protected final String[] myConflictDescriptions;
    protected MultiMap<PsiElement, String> myElementConflictDescription;
    private final Project myProject;
    private Runnable myDoRefactoringRunnable;
    private final boolean myCanShowConflictsInView;
    private String myCommandName;

    public ConflictsDialog(@NotNull Project project, @NotNull MultiMap<PsiElement, String> conflictDescriptions) {
        this(project, conflictDescriptions, null, true, true);
    }

    public ConflictsDialog(@NotNull Project project, @NotNull MultiMap<PsiElement, String> conflictDescriptions, @Nullable Runnable doRefactoringRunnable) {
        this(project, conflictDescriptions, doRefactoringRunnable, true, true);
    }

    public ConflictsDialog(@NotNull Project project, @NotNull MultiMap<PsiElement, String> conflictDescriptions, @Nullable Runnable doRefactoringRunnable, boolean alwaysShowOkButton, boolean canShowConflictsInView) {
        super(project, true);
        this.myProject = project;
        this.myDoRefactoringRunnable = doRefactoringRunnable;
        this.myCanShowConflictsInView = canShowConflictsInView;
        LinkedHashSet conflicts = new LinkedHashSet(conflictDescriptions.values());
        this.myConflictDescriptions = ArrayUtilRt.toStringArray(conflicts);
        this.myElementConflictDescription = conflictDescriptions;
        this.setTitle(RefactoringBundle.message((String)"problems.detected.title"));
        this.setOKButtonText(RefactoringBundle.message((String)"continue.button"));
        this.setOKActionEnabled(alwaysShowOkButton || this.getDoRefactoringRunnable(null) != null);
        this.init();
    }

    @Deprecated
    public ConflictsDialog(Project project, String ... conflictDescriptions) {
        super(project, true);
        this.myProject = project;
        this.myConflictDescriptions = conflictDescriptions;
        this.myCanShowConflictsInView = true;
        this.setTitle(RefactoringBundle.message((String)"problems.detected.title"));
        this.setOKButtonText(RefactoringBundle.message((String)"continue.button"));
        this.init();
    }

    protected Action @NotNull [] createActions() {
        boolean showUsagesButton;
        Action okAction = this.getOKAction();
        boolean bl = showUsagesButton = this.myElementConflictDescription != null && this.myCanShowConflictsInView;
        if (showUsagesButton || !okAction.isEnabled()) {
            okAction.putValue("DefaultAction", null);
        }
        if (!showUsagesButton) {
            return new Action[]{okAction, new CancelAction()};
        }
        return new Action[]{okAction, new MyShowConflictsInUsageViewAction(), new CancelAction()};
    }

    public boolean isShowConflicts() {
        return this.getExitCode() == 4;
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout(0, 2));
        panel2.add((Component)new JLabel(RefactoringBundle.message((String)"the.following.problems.were.found")), "North");
        StringBuilder buf = new StringBuilder();
        for (int i2 = 0; i2 < Math.min(this.myConflictDescriptions.length, 20); ++i2) {
            buf.append(this.myConflictDescriptions[i2]).append("<br><br>");
        }
        if (this.myConflictDescriptions.length > 20) {
            buf.append("<a href='expand'>Show more...</a>");
        }
        JEditorPane messagePane = new JEditorPane();
        messagePane.setEditorKit(UIUtil.getHTMLEditorKit());
        messagePane.setText(buf.toString());
        messagePane.setEditable(false);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)messagePane, (int)22, (int)30);
        scrollPane.setPreferredSize((Dimension)JBUI.size((int)500, (int)400));
        messagePane.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && EXPAND_LINK.equals(e.getDescription())) {
                messagePane.setText(StringUtil.join((String[])this.myConflictDescriptions, (String)"<br><br>"));
            }
        });
        panel2.add((Component)scrollPane, "Center");
        if (this.getOKAction().isEnabled()) {
            panel2.add((Component)new JLabel(RefactoringBundle.message((String)"do.you.wish.to.ignore.them.and.continue")), "South");
        }
        return panel2;
    }

    public void setCommandName(String commandName) {
        this.myCommandName = commandName;
    }

    protected Runnable getDoRefactoringRunnable(@Nullable UsageView usageView) {
        return this.myDoRefactoringRunnable;
    }

    private class MyShowConflictsInUsageViewAction
    extends AbstractAction {
        MyShowConflictsInUsageViewAction() {
            super(RefactoringBundle.message((String)"action.show.conflicts.in.view.text"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UsageViewPresentation presentation2 = new UsageViewPresentation();
            String codeUsagesString = RefactoringBundle.message((String)"conflicts.tab.name");
            presentation2.setCodeUsagesString(codeUsagesString);
            presentation2.setTabName(codeUsagesString);
            presentation2.setTabText(codeUsagesString);
            presentation2.setShowCancelButton(true);
            ArrayList<Object> usages = new ArrayList<Object>(ConflictsDialog.this.myElementConflictDescription.values().size());
            for (PsiElement element2 : ConflictsDialog.this.myElementConflictDescription.keySet()) {
                if (element2 == null) {
                    usages.add(new DescriptionOnlyUsage());
                    continue;
                }
                boolean isRead = false;
                boolean isWrite = false;
                ReadWriteAccessDetector detector = ReadWriteAccessDetector.findDetector((PsiElement)element2);
                if (detector != null) {
                    ReadWriteAccessDetector.Access access = detector.getExpressionAccess(element2);
                    isRead = access != ReadWriteAccessDetector.Access.Write;
                    isWrite = access != ReadWriteAccessDetector.Access.Read;
                }
                for (String conflictDescription : ConflictsDialog.this.myElementConflictDescription.get((Object)element2)) {
                    final UsagePresentation usagePresentation = new DescriptionOnlyUsage(conflictDescription).getPresentation();
                    Object usage = isRead || isWrite ? new ReadWriteAccessUsageInfo2UsageAdapter(new UsageInfo(element2), isRead, isWrite){

                        @NotNull
                        public UsagePresentation getPresentation() {
                            return usagePresentation;
                        }
                    } : new UsageInfo2UsageAdapter(new UsageInfo(element2)){

                        @NotNull
                        public UsagePresentation getPresentation() {
                            return usagePresentation;
                        }
                    };
                    usages.add(usage);
                }
            }
            UsageView usageView = UsageViewManager.getInstance((Project)ConflictsDialog.this.myProject).showUsages(UsageTarget.EMPTY_ARRAY, usages.toArray(Usage.EMPTY_ARRAY), presentation2);
            Runnable doRefactoringRunnable = ConflictsDialog.this.getDoRefactoringRunnable(usageView);
            if (doRefactoringRunnable != null) {
                usageView.addPerformOperationAction(doRefactoringRunnable, ConflictsDialog.this.myCommandName != null ? ConflictsDialog.this.myCommandName : RefactoringBundle.message((String)"retry.command"), "Unable to perform refactoring. There were changes in code after the usages have been found.", RefactoringBundle.message((String)"usageView.doAction"));
            }
            ConflictsDialog.this.close(4);
        }

        private class DescriptionOnlyUsage
        implements Usage {
            private final String myConflictDescription;

            DescriptionOnlyUsage(String conflictDescription) {
                this.myConflictDescription = StringUtil.unescapeXmlEntities((String)conflictDescription).replaceAll("<code>", "").replaceAll("</code>", "").replaceAll("<b>", "").replaceAll("</b>", "");
            }

            DescriptionOnlyUsage() {
                this.myConflictDescription = Pattern.compile("<[^<>]*>").matcher(StringUtil.join(new LinkedHashSet(ConflictsDialog.this.myElementConflictDescription.get(null)), (String)"\n")).replaceAll("");
            }

            @NotNull
            public UsagePresentation getPresentation() {
                return new UsagePresentation(){

                    public TextChunk @NotNull [] getText() {
                        return new TextChunk[]{new TextChunk(SimpleTextAttributes.REGULAR_ATTRIBUTES.toTextAttributes(), DescriptionOnlyUsage.this.myConflictDescription)};
                    }

                    @Nullable
                    public Icon getIcon() {
                        return null;
                    }

                    public String getTooltipText() {
                        return DescriptionOnlyUsage.this.myConflictDescription;
                    }

                    @NotNull
                    public String getPlainText() {
                        return DescriptionOnlyUsage.this.myConflictDescription;
                    }
                };
            }

            public boolean canNavigateToSource() {
                return false;
            }

            public boolean canNavigate() {
                return false;
            }

            public void navigate(boolean requestFocus) {
            }

            public FileEditorLocation getLocation() {
                return null;
            }

            public boolean isReadOnly() {
                return false;
            }

            public boolean isValid() {
                return true;
            }

            public void selectInEditor() {
            }

            public void highlightInEditor() {
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        CancelAction() {
            super(RefactoringBundle.message((String)"cancel.button"));
            this.putValue("DefaultAction", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConflictsDialog.this.doCancelAction();
        }
    }
}

