/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import org.jetbrains.annotations.NotNull;

class UsageHolder {
    private final SmartPsiElementPointer myElementPointer;
    private int myUnsafeUsages;
    private int myNonCodeUnsafeUsages;

    UsageHolder(PsiElement element2, UsageInfo[] usageInfos) {
        Project project = element2.getProject();
        this.myElementPointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(element2);
        for (UsageInfo usageInfo : usageInfos) {
            SafeDeleteReferenceUsageInfo usage;
            if (!(usageInfo instanceof SafeDeleteReferenceUsageInfo) || (usage = (SafeDeleteReferenceUsageInfo)usageInfo).getReferencedElement() != element2 || usage.isSafeDelete()) continue;
            ++this.myUnsafeUsages;
            if (!usage.isNonCodeUsage && !UsageHolder.isInGeneratedCode(usage, project)) continue;
            ++this.myNonCodeUnsafeUsages;
        }
    }

    private static boolean isInGeneratedCode(SafeDeleteReferenceUsageInfo usage, Project project) {
        VirtualFile file2 = usage.getVirtualFile();
        return file2 != null && GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)file2, (Project)project);
    }

    @NotNull
    public String getDescription() {
        PsiElement element2 = this.myElementPointer.getElement();
        String message = RefactoringBundle.message((String)"0.has.1.usages.that.are.not.safe.to.delete", (Object[])new Object[]{RefactoringUIUtil.getDescription(element2, true), this.myUnsafeUsages});
        if (this.myNonCodeUnsafeUsages > 0) {
            message = message + "<br>" + RefactoringBundle.message((String)"safe.delete.of.those.0.in.comments.strings.non.code", (Object[])new Object[]{this.myNonCodeUnsafeUsages});
        }
        return message;
    }

    public boolean hasUnsafeUsagesInCode() {
        return this.myUnsafeUsages != this.myNonCodeUnsafeUsages;
    }
}

