/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.inplace;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.ide.IdeBundle;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.FinishMarkAction;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.rename.AutomaticRenamingDialog;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.ResolveSnapshotProvider;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.refactoring.rename.inplace.RenameChooser;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenameHandler;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.PairProcessor;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableInplaceRenamer
extends InplaceRefactoring {
    public static final LanguageExtension<ResolveSnapshotProvider> INSTANCE = new LanguageExtension("com.intellij.rename.inplace.resolveSnapshotProvider");
    private ResolveSnapshotProvider.ResolveSnapshot mySnapshot;
    private TextRange mySelectedRange;
    protected Language myLanguage;

    public VariableInplaceRenamer(@NotNull PsiNamedElement elementToRename, @NotNull Editor editor) {
        this(elementToRename, editor, elementToRename.getProject());
    }

    public VariableInplaceRenamer(@Nullable PsiNamedElement elementToRename, @NotNull Editor editor, @NotNull Project project) {
        this(elementToRename, editor, project, elementToRename != null ? elementToRename.getName() : null, elementToRename != null ? elementToRename.getName() : null);
    }

    public VariableInplaceRenamer(@Nullable PsiNamedElement elementToRename, @NotNull Editor editor, @NotNull Project project, @Nullable String initialName, @Nullable String oldName) {
        super(editor, elementToRename, project, initialName, oldName);
    }

    @Override
    protected boolean startsOnTheSameElement(RefactoringActionHandler handler2, PsiElement element2) {
        return super.startsOnTheSameElement(handler2, element2) && handler2 instanceof VariableInplaceRenameHandler;
    }

    public boolean performInplaceRename() {
        return this.performInplaceRefactoring(null);
    }

    @Override
    protected void collectAdditionalElementsToRename(@NotNull List<Pair<PsiElement, TextRange>> stringUsages) {
        String stringToSearch = this.myElementToRename.getName();
        PsiFile currentFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
        if (!StringUtil.isEmptyOrSpaces((String)stringToSearch)) {
            TextOccurrencesUtil.processUsagesInStringsAndComments((PsiElement)this.myElementToRename, (SearchScope)GlobalSearchScope.projectScope((Project)this.myElementToRename.getProject()), stringToSearch, true, (PairProcessor<? super PsiElement, ? super TextRange>)((PairProcessor)(psiElement, textRange) -> {
                if (psiElement.getContainingFile() == currentFile) {
                    stringUsages.add(Pair.create((Object)psiElement, (Object)textRange));
                }
                return true;
            }));
        }
    }

    @Override
    protected boolean buildTemplateAndStart(final Collection<PsiReference> refs, Collection<Pair<PsiElement, TextRange>> stringUsages, final PsiElement scope, final PsiFile containingFile) {
        if (this.appendAdditionalElement(refs, stringUsages)) {
            return super.buildTemplateAndStart(refs, stringUsages, scope, containingFile);
        }
        RenameChooser renameChooser = new RenameChooser(this.myEditor){

            @Override
            protected void runRenameTemplate(Collection<Pair<PsiElement, TextRange>> stringUsages) {
                VariableInplaceRenamer.super.buildTemplateAndStart(refs, stringUsages, scope, containingFile);
            }
        };
        renameChooser.showChooser(refs, stringUsages);
        return true;
    }

    protected boolean appendAdditionalElement(Collection<PsiReference> refs, Collection<Pair<PsiElement, TextRange>> stringUsages) {
        return stringUsages.isEmpty() || StartMarkAction.canStart(this.myProject) != null;
    }

    protected boolean shouldCreateSnapshot() {
        return true;
    }

    protected String getRefactoringId() {
        return "refactoring.rename";
    }

    @Override
    protected void beforeTemplateStart() {
        SelectionModel selectionModel;
        super.beforeTemplateStart();
        this.myLanguage = this.myScope.getLanguage();
        if (this.shouldCreateSnapshot()) {
            ResolveSnapshotProvider resolveSnapshotProvider = (ResolveSnapshotProvider)INSTANCE.forLanguage(this.myLanguage);
            this.mySnapshot = resolveSnapshotProvider != null ? resolveSnapshotProvider.createSnapshot(this.myScope) : null;
        }
        this.mySelectedRange = (selectionModel = this.myEditor.getSelectionModel()).hasSelection() ? new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd()) : null;
    }

    @Override
    protected void restoreSelection() {
        if (this.mySelectedRange != null) {
            TextRange selectedRange;
            Editor editor = InjectedLanguageUtil.getTopLevelEditor(this.myEditor);
            if (this.myEditor instanceof EditorWindow) {
                PsiFile injected = ((EditorWindow)this.myEditor).getInjectedFile();
                selectedRange = InjectedLanguageManager.getInstance((Project)editor.getProject()).injectedToHost((PsiElement)injected, this.mySelectedRange);
            } else {
                selectedRange = this.mySelectedRange;
            }
            TemplateState state = TemplateManagerImpl.getTemplateState(editor);
            if (state != null) {
                for (int i2 = 0; i2 < state.getSegmentsCount(); ++i2) {
                    TextRange segmentRange = state.getSegmentRange(i2);
                    TextRange intersection = segmentRange.intersection(selectedRange);
                    if (intersection == null) continue;
                    editor.getSelectionModel().setSelection(intersection.getStartOffset(), intersection.getEndOffset());
                    return;
                }
            }
            this.myEditor.getSelectionModel().setSelection(this.mySelectedRange.getStartOffset(), this.mySelectedRange.getEndOffset());
        } else if (!this.shouldSelectAll()) {
            this.myEditor.getSelectionModel().removeSelection();
        }
    }

    @Override
    protected int restoreCaretOffset(int offset) {
        if (this.myCaretRangeMarker.isValid()) {
            if (this.myCaretRangeMarker.getStartOffset() <= offset && this.myCaretRangeMarker.getEndOffset() >= offset) {
                return offset;
            }
            return this.myCaretRangeMarker.getEndOffset();
        }
        return offset;
    }

    @Override
    protected boolean shouldSelectAll() {
        if (this.myEditor.getSettings().isPreselectRename()) {
            return true;
        }
        Boolean selectAll = (Boolean)this.myEditor.getUserData(RenameHandlerRegistry.SELECT_ALL);
        return selectAll != null && selectAll != false;
    }

    @NotNull
    protected VariableInplaceRenamer createInplaceRenamerToRestart(PsiNamedElement variable, Editor editor, String initialName) {
        return new VariableInplaceRenamer(variable, editor, this.myProject, initialName, this.myOldName);
    }

    protected void performOnInvalidIdentifier(String newName, LinkedHashSet<String> nameSuggestions) {
        PsiNamedElement variable = this.getVariable();
        if (variable != null) {
            int offset = variable.getTextOffset();
            this.restoreCaretOffset(offset);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            JBPopupFactory.getInstance().createConfirmation(LangBundle.message((String)"popup.title.inserted.identifier.valid", (Object[])new Object[0]), IdeBundle.message((String)"button.continue.editing", (Object[])new Object[0]), CommonBundle.getCancelButtonText(), () -> this.createInplaceRenamerToRestart(variable, this.myEditor, newName).performInplaceRefactoring(nameSuggestions), 0).showInBestPositionFor(this.myEditor);
        }
    }

    protected void renameSynthetic(String newName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRefactoringRename(String newName, StartMarkAction markAction) {
        AutomaticRenamer renamer;
        ArrayList usages;
        PsiNamedElement elementToRename;
        String refactoringId;
        block26: {
            block27: {
                refactoringId = this.getRefactoringId();
                elementToRename = this.getVariable();
                if (refactoringId != null) {
                    RefactoringEventData beforeData = new RefactoringEventData();
                    beforeData.addElement((PsiElement)elementToRename);
                    beforeData.addStringProperties(new String[]{this.myOldName});
                    ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(refactoringId, beforeData);
                }
                if (this.isIdentifier(newName, this.myLanguage)) break block26;
                if (refactoringId == null) break block27;
                RefactoringEventData afterData = new RefactoringEventData();
                afterData.addElement((PsiElement)this.getVariable());
                afterData.addStringProperties(new String[]{newName});
                ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(refactoringId, afterData);
            }
            try {
                ((EditorImpl)InjectedLanguageUtil.getTopLevelEditor(this.myEditor)).stopDumbLater();
            }
            finally {
                FinishMarkAction.finish(this.myProject, this.myEditor, markAction);
            }
            return;
        }
        try {
            if (elementToRename != null) {
                WriteCommandAction.writeCommandAction((Project)this.myProject).withName(this.getCommandName()).run(() -> this.renameSynthetic(newName));
            }
            for (AutomaticRenamerFactory renamerFactory : AutomaticRenamerFactory.EP_NAME.getExtensionList()) {
                AutomaticRenamingDialog renamingDialog;
                if (elementToRename == null || !renamerFactory.isApplicable((PsiElement)elementToRename)) continue;
                usages = new ArrayList();
                renamer = renamerFactory.createRenamer((PsiElement)elementToRename, newName, new ArrayList<UsageInfo>());
                if (!renamer.hasAnythingToRename() || !ApplicationManager.getApplication().isUnitTestMode() && !(renamingDialog = new AutomaticRenamingDialog(this.myProject, renamer)).showAndGet()) continue;
                Runnable runnable2 = () -> ApplicationManager.getApplication().runReadAction(() -> renamer.findUsages(usages, false, false));
                if (ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable2, RefactoringBundle.message((String)"searching.for.variables"), true, this.myProject)) break block29;
                if (refactoringId == null) break block30;
            }
        }
        catch (Throwable throwable) {
            if (refactoringId != null) {
                RefactoringEventData afterData = new RefactoringEventData();
                afterData.addElement((PsiElement)this.getVariable());
                afterData.addStringProperties(new String[]{newName});
                ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(refactoringId, afterData);
            }
            try {
                ((EditorImpl)InjectedLanguageUtil.getTopLevelEditor(this.myEditor)).stopDumbLater();
            }
            finally {
                FinishMarkAction.finish(this.myProject, this.myEditor, markAction);
            }
            throw throwable;
        }
        {
            block32: {
                block33: {
                    RefactoringEventData afterData;
                    block29: {
                        block30: {
                            afterData = new RefactoringEventData();
                            afterData.addElement((PsiElement)this.getVariable());
                            afterData.addStringProperties(new String[]{newName});
                            ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(refactoringId, afterData);
                        }
                        try {
                            ((EditorImpl)InjectedLanguageUtil.getTopLevelEditor(this.myEditor)).stopDumbLater();
                        }
                        finally {
                            FinishMarkAction.finish(this.myProject, this.myEditor, markAction);
                        }
                        return;
                    }
                    if (CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement[])PsiUtilCore.toPsiElementArray(renamer.getElements()))) break block32;
                    if (refactoringId == null) break block33;
                    afterData = new RefactoringEventData();
                    afterData.addElement((PsiElement)this.getVariable());
                    afterData.addStringProperties(new String[]{newName});
                    ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(refactoringId, afterData);
                }
                try {
                    ((EditorImpl)InjectedLanguageUtil.getTopLevelEditor(this.myEditor)).stopDumbLater();
                }
                finally {
                    FinishMarkAction.finish(this.myProject, this.myEditor, markAction);
                }
                return;
            }
            ThrowableRunnable performAutomaticRename = () -> {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(this.myProject);
                UsageInfo[] usageInfos = usages.toArray(UsageInfo.EMPTY_ARRAY);
                MultiMap<PsiElement, UsageInfo> classified = RenameProcessor.classifyUsages(renamer.getElements(), usageInfos);
                for (PsiNamedElement element2 : renamer.getElements()) {
                    String newElementName = renamer.getNewName(element2);
                    if (newElementName == null) continue;
                    Collection infos = classified.get((Object)element2);
                    RenameUtil.doRename((PsiElement)element2, newElementName, infos.toArray(UsageInfo.EMPTY_ARRAY), this.myProject, RefactoringElementListener.DEAF);
                }
            };
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                WriteCommandAction.writeCommandAction((Project)this.myProject).withName(this.getCommandName()).run(performAutomaticRename);
                continue;
            }
            ApplicationManager.getApplication().invokeLater(() -> WriteCommandAction.writeCommandAction((Project)this.myProject).withName(this.getCommandName()).run(performAutomaticRename));
            continue;
        }
        if (refactoringId != null) {
            RefactoringEventData afterData = new RefactoringEventData();
            afterData.addElement((PsiElement)this.getVariable());
            afterData.addStringProperties(new String[]{newName});
            ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(refactoringId, afterData);
        }
        try {
            ((EditorImpl)InjectedLanguageUtil.getTopLevelEditor(this.myEditor)).stopDumbLater();
        }
        finally {
            FinishMarkAction.finish(this.myProject, this.myEditor, markAction);
        }
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"renaming.command.name", (Object[])new Object[]{this.myInitialName});
    }

    @Override
    protected boolean performRefactoring() {
        boolean bind2 = false;
        if (this.myInsertedName != null) {
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            if (commandProcessor.getCurrentCommand() != null && this.getVariable() != null) {
                commandProcessor.setCurrentCommandName(this.getCommandName());
            }
            bind2 = true;
            if (!this.isIdentifier(this.myInsertedName, this.myLanguage)) {
                this.performOnInvalidIdentifier(this.myInsertedName, this.myNameSuggestions);
            } else if (this.mySnapshot != null) {
                ApplicationManager.getApplication().runWriteAction(() -> this.mySnapshot.apply(this.myInsertedName));
            }
            this.performRefactoringRename(this.myInsertedName, this.myMarkAction);
        }
        return bind2;
    }

    @Override
    public void finish(boolean success) {
        super.finish(success);
        if (success) {
            this.revertStateOnFinish();
        } else {
            ((EditorImpl)InjectedLanguageUtil.getTopLevelEditor(this.myEditor)).stopDumbLater();
        }
    }

    protected void revertStateOnFinish() {
        if (this.myInsertedName == null || !this.isIdentifier(this.myInsertedName, this.myLanguage)) {
            this.revertState();
        }
    }
}

