/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.RenameUtilBase;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RenamePsiElementProcessor {
    private static final Logger LOG = Logger.getInstance(RenamePsiElementProcessor.class);
    public static final ExtensionPointName<RenamePsiElementProcessor> EP_NAME = ExtensionPointName.create((String)"com.intellij.renamePsiElementProcessor");
    public static final RenamePsiElementProcessor DEFAULT = new RenamePsiElementProcessor(){

        @Override
        public boolean canProcessElement(@NotNull PsiElement element2) {
            return true;
        }
    };
    final boolean myOldFindMethodsImplemented;

    public RenamePsiElementProcessor() {
        boolean implemented;
        try {
            Method find1 = this.getClass().getMethod("findReferences", PsiElement.class);
            Method find2 = this.getClass().getMethod("findReferences", PsiElement.class, Boolean.TYPE);
            boolean bl = implemented = !RenamePsiElementProcessor.class.equals(find1.getDeclaringClass()) || !RenamePsiElementProcessor.class.equals(find2.getDeclaringClass());
            if (implemented) {
                LOG.warn(this.getClass().getName() + " overrides deprecated findReferences(..).\nOverride findReferences(PsiElement, SearchScope, boolean) instead.");
            }
        }
        catch (NoSuchMethodException e) {
            implemented = false;
            LOG.warn((Throwable)e);
        }
        this.myOldFindMethodsImplemented = implemented;
    }

    public abstract boolean canProcessElement(@NotNull PsiElement var1);

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, @NotNull PsiElement element2, @Nullable PsiElement nameSuggestionContext, @Nullable Editor editor) {
        return new RenameDialog(project, element2, nameSuggestionContext, editor);
    }

    public void renameElement(@NotNull PsiElement element2, @NotNull String newName, UsageInfo @NotNull [] usages, @Nullable RefactoringElementListener listener2) throws IncorrectOperationException {
        RenameUtil.doRenameGenericNamedElement(element2, newName, usages, listener2);
    }

    @Deprecated
    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element2, boolean searchInCommentsAndStrings) {
        return this.myOldFindMethodsImplemented ? this.findReferences(element2) : this.findReferences(element2, (SearchScope)GlobalSearchScope.projectScope((Project)element2.getProject()), searchInCommentsAndStrings);
    }

    @Deprecated
    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element2) {
        return this.myOldFindMethodsImplemented ? ReferencesSearch.search((PsiElement)element2, (SearchScope)GlobalSearchScope.projectScope((Project)element2.getProject())).findAll() : this.findReferences(element2, (SearchScope)GlobalSearchScope.projectScope((Project)element2.getProject()), false);
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element2, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        if (this.myOldFindMethodsImplemented) {
            Collection<PsiReference> refs = this.findReferences(element2, searchInCommentsAndStrings);
            if (!searchScope.equals(GlobalSearchScope.projectScope((Project)element2.getProject()))) {
                ArrayList<PsiReference> result2 = new ArrayList<PsiReference>();
                for (PsiReference ref : refs) {
                    VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)ref.getElement());
                    if (file2 != null && !searchScope.contains(file2)) continue;
                    result2.add(ref);
                }
                return result2;
            }
            return refs;
        }
        return ReferencesSearch.search((PsiElement)element2, (SearchScope)searchScope).findAll();
    }

    @Nullable
    public Pair<String, String> getTextOccurrenceSearchStrings(@NotNull PsiElement element2, @NotNull String newName) {
        return null;
    }

    @Nullable
    public String getQualifiedNameAfterRename(@NotNull PsiElement element2, @NotNull String newName, boolean nonJava) {
        return null;
    }

    public void prepareRenaming(@NotNull PsiElement element2, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        this.prepareRenaming(element2, newName, allRenames, PsiSearchHelper.getInstance((Project)element2.getProject()).getUseScope(element2));
    }

    public void prepareRenaming(@NotNull PsiElement element2, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames, @NotNull SearchScope scope) {
    }

    public void findExistingNameConflicts(@NotNull PsiElement element2, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
    }

    public void findExistingNameConflicts(@NotNull PsiElement element2, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts, @NotNull Map<PsiElement, String> allRenames) {
        this.findExistingNameConflicts(element2, newName, conflicts);
    }

    public boolean isInplaceRenameSupported() {
        return true;
    }

    @NotNull
    public static List<RenamePsiElementProcessor> allForElement(@NotNull PsiElement element2) {
        ArrayList<RenamePsiElementProcessor> result2 = new ArrayList<RenamePsiElementProcessor>();
        for (RenamePsiElementProcessor processor2 : (RenamePsiElementProcessor[])EP_NAME.getExtensions()) {
            if (!processor2.canProcessElement(element2)) continue;
            result2.add(processor2);
        }
        return result2;
    }

    @NotNull
    public static RenamePsiElementProcessor forElement(@NotNull PsiElement element2) {
        for (RenamePsiElementProcessor processor2 : EP_NAME.getExtensionList()) {
            if (!processor2.canProcessElement(element2)) continue;
            return processor2;
        }
        return DEFAULT;
    }

    @Nullable
    public Runnable getPostRenameCallback(@NotNull PsiElement element2, @NotNull String newName, @NotNull RefactoringElementListener elementListener) {
        return null;
    }

    @Nullable
    @NonNls
    public String getHelpID(PsiElement element2) {
        if (element2 instanceof PsiFile) {
            return "refactoring.renameFile";
        }
        return "refactoring.renameDialogs";
    }

    public boolean isToSearchInComments(@NotNull PsiElement element2) {
        return element2 instanceof PsiFileSystemItem && RefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FILE;
    }

    public void setToSearchInComments(@NotNull PsiElement element2, boolean enabled) {
        if (element2 instanceof PsiFileSystemItem) {
            RefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FILE = enabled;
        }
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element2) {
        return element2 instanceof PsiFileSystemItem && RefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_FILE;
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element2, boolean enabled) {
        if (element2 instanceof PsiFileSystemItem) {
            RefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_FILE = enabled;
        }
    }

    public boolean showRenamePreviewButton(@NotNull PsiElement psiElement) {
        return true;
    }

    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element2, @Nullable Editor editor) {
        return element2;
    }

    public void substituteElementToRename(@NotNull PsiElement element2, @NotNull Editor editor, @NotNull Pass<PsiElement> renameCallback) {
        PsiElement psiElement = this.substituteElementToRename(element2, editor);
        if (psiElement == null) {
            return;
        }
        if (!PsiElementRenameHandler.canRename(psiElement.getProject(), editor, psiElement)) {
            return;
        }
        renameCallback.pass((Object)psiElement);
    }

    public void findCollisions(@NotNull PsiElement element2, @NotNull String newName, @NotNull Map<? extends PsiElement, String> allRenames, @NotNull List<UsageInfo> result2) {
    }

    public boolean forcesShowPreview() {
        return false;
    }

    @Nullable
    public PsiElement getElementToSearchInStringsAndComments(@NotNull PsiElement element2) {
        return element2;
    }

    @NotNull
    public UsageInfo createUsageInfo(@NotNull PsiElement element2, @NotNull PsiReference ref, @NotNull PsiElement referenceElement) {
        return RenameUtilBase.createMoveRenameUsageInfo(element2, ref, referenceElement);
    }
}

