/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.DirectoryAsPackageRenameHandlerBase;
import com.intellij.refactoring.rename.DirectoryRenameHandlerBase;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class PlainDirectoryRenameHandler
extends DirectoryRenameHandlerBase {
    @Override
    protected boolean isSuitableDirectory(PsiDirectory directory) {
        return PlainDirectoryRenameHandler.isPlainDirectory(directory);
    }

    public static boolean isPlainDirectory(@NotNull PsiDirectory directory) {
        return Arrays.stream(EP_NAME.getExtensions()).noneMatch(extension -> extension instanceof DirectoryAsPackageRenameHandlerBase && ((DirectoryAsPackageRenameHandlerBase)extension).getPackage(directory) != null);
    }

    @Override
    protected void doRename(PsiElement element2, Project project, PsiElement nameSuggestionContext, Editor editor) {
        PsiElementRenameHandler.rename(element2, project, nameSuggestionContext, editor);
    }
}

