/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveFilesOrDirectories;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import org.jetbrains.annotations.NotNull;

class MoveFilesOrDirectoriesViewDescriptor
implements UsageViewDescriptor {
    private final PsiElement[] myElementsToMove;
    private String myProcessedElementsHeader;
    private final String myCodeReferencesText;

    MoveFilesOrDirectoriesViewDescriptor(PsiElement[] elementsToMove, PsiDirectory newParent) {
        this.myElementsToMove = elementsToMove;
        if (elementsToMove.length == 1) {
            this.myProcessedElementsHeader = StringUtil.capitalize((String)RefactoringBundle.message((String)"move.single.element.elements.header", (Object[])new Object[]{UsageViewUtil.getType(elementsToMove[0]), newParent.getVirtualFile().getPresentableUrl()}));
            this.myCodeReferencesText = RefactoringBundle.message((String)"references.in.code.to.0.1", (Object[])new Object[]{UsageViewUtil.getType(elementsToMove[0]), UsageViewUtil.getLongName(elementsToMove[0])});
        } else {
            if (elementsToMove[0] instanceof PsiFile) {
                this.myProcessedElementsHeader = StringUtil.capitalize((String)RefactoringBundle.message((String)"move.files.elements.header", (Object[])new Object[]{newParent.getVirtualFile().getPresentableUrl()}));
            } else if (elementsToMove[0] instanceof PsiDirectory) {
                this.myProcessedElementsHeader = StringUtil.capitalize((String)RefactoringBundle.message((String)"move.directories.elements.header", (Object[])new Object[]{newParent.getVirtualFile().getPresentableUrl()}));
            }
            this.myCodeReferencesText = RefactoringBundle.message((String)"references.found.in.code");
        }
    }

    public PsiElement @NotNull [] getElements() {
        return this.myElementsToMove;
    }

    public String getProcessedElementsHeader() {
        return this.myProcessedElementsHeader;
    }

    @NotNull
    public String getCodeReferencesText(int usagesCount, int filesCount) {
        return this.myCodeReferencesText + UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount);
    }

    public String getCommentReferencesText(int usagesCount, int filesCount) {
        return RefactoringBundle.message((String)"comments.elements.header", (Object[])new Object[]{UsageViewBundle.getOccurencesString((int)usagesCount, (int)filesCount)});
    }
}

