/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.move.FileReferenceContextUtil;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveMultipleElementsViewDescriptor;
import com.intellij.refactoring.move.moveClassesOrPackages.CommonMoveUtil;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveDirectoryWithClassesHelper;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFileHandler;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveDirectoryWithClassesProcessor
extends BaseRefactoringProcessor {
    private final PsiDirectory[] myDirectories;
    private final PsiDirectory myTargetDirectory;
    private final boolean mySearchInComments;
    private final boolean mySearchInNonJavaFiles;
    private final Map<VirtualFile, TargetDirectoryWrapper> myFilesToMove;
    private final Map<PsiDirectory, TargetDirectoryWrapper> myNestedDirsToMove;
    private NonCodeUsageInfo[] myNonCodeUsages;
    private final MoveCallback myMoveCallback;
    private final PsiManager myManager;

    public MoveDirectoryWithClassesProcessor(Project project, PsiDirectory[] directories, PsiDirectory targetDirectory, boolean searchInComments, boolean searchInNonJavaFiles, boolean includeSelf, MoveCallback moveCallback) {
        super(project);
        if (targetDirectory != null) {
            ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>(Arrays.asList(directories));
            Iterator iterator2 = dirs.iterator();
            while (iterator2.hasNext()) {
                PsiDirectory directory = (PsiDirectory)iterator2.next();
                if (!targetDirectory.equals(directory.getParentDirectory()) && !targetDirectory.equals(directory)) continue;
                iterator2.remove();
            }
            directories = dirs.toArray(PsiDirectory.EMPTY_ARRAY);
        }
        this.myManager = PsiManager.getInstance((Project)project);
        this.myDirectories = directories;
        this.myTargetDirectory = targetDirectory;
        this.mySearchInComments = searchInComments;
        this.mySearchInNonJavaFiles = searchInNonJavaFiles;
        this.myMoveCallback = moveCallback;
        this.myFilesToMove = new HashMap<VirtualFile, TargetDirectoryWrapper>();
        this.myNestedDirsToMove = new LinkedHashMap<PsiDirectory, TargetDirectoryWrapper>();
        for (PsiDirectory dir : directories) {
            MoveDirectoryWithClassesProcessor.collectFiles2Move(this.myFilesToMove, this.myNestedDirsToMove, dir, includeSelf ? dir.getParentDirectory() : dir, this.getTargetDirectory(dir));
        }
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        PsiElement[] elements2 = new PsiElement[this.myFilesToMove.size()];
        PsiFile[] classes = PsiUtilCore.toPsiFileArray(this.getPsiFiles());
        System.arraycopy(classes, 0, elements2, 0, classes.length);
        return new MoveMultipleElementsViewDescriptor(elements2, this.getTargetName());
    }

    private Set<PsiFile> getPsiFiles() {
        return this.myFilesToMove.keySet().stream().map(arg_0 -> ((PsiManager)this.myManager).findFile(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    protected String getTargetName() {
        return RefactoringUIUtil.getDescription((PsiElement)this.getTargetDirectory(null).getTargetDirectory(), false);
    }

    @Override
    public UsageInfo @NotNull [] findUsages() {
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        for (MoveDirectoryWithClassesHelper helper : MoveDirectoryWithClassesHelper.findAll()) {
            helper.findUsages(this.getPsiFiles(), this.myDirectories, usages, this.mySearchInComments, this.mySearchInNonJavaFiles, this.myProject);
        }
        return UsageViewUtil.removeDuplicatedUsages(usages.toArray(UsageInfo.EMPTY_ARRAY));
    }

    private void collectConflicts(@NotNull MultiMap<PsiElement, String> conflicts, @NotNull Ref<UsageInfo[]> refUsages) {
        for (VirtualFile vFile : this.myFilesToMove.keySet()) {
            PsiFile file2 = this.myManager.findFile(vFile);
            if (file2 == null) continue;
            try {
                this.myFilesToMove.get(vFile).checkMove(file2);
            }
            catch (IncorrectOperationException e) {
                conflicts.putValue((Object)file2, (Object)e.getMessage());
            }
        }
        for (MoveDirectoryWithClassesHelper helper : MoveDirectoryWithClassesHelper.findAll()) {
            helper.preprocessUsages(this.myProject, this.getPsiFiles(), (UsageInfo[])refUsages.get(), this.myTargetDirectory, conflicts);
        }
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        MultiMap conflicts = new MultiMap();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReadAction.run(() -> this.collectConflicts((MultiMap<PsiElement, String>)conflicts, refUsages)), RefactoringBundle.message((String)"detecting.possible.conflicts"), true, this.myProject)) {
            return false;
        }
        return this.showConflicts((MultiMap<PsiElement, String>)conflicts, (UsageInfo[])refUsages.get());
    }

    @Override
    public void performRefactoring(UsageInfo @NotNull [] usages) {
        try {
            for (PsiDirectory directory : this.myDirectories) {
                this.getResultDirectory(directory).findOrCreateTargetDirectory();
            }
            for (PsiDirectory directory : this.myNestedDirsToMove.keySet()) {
                this.myNestedDirsToMove.get(directory).findOrCreateTargetDirectory();
            }
            for (VirtualFile virtualFile : this.myFilesToMove.keySet()) {
                this.myFilesToMove.get(virtualFile).findOrCreateTargetDirectory();
            }
            DumbService.getInstance((Project)this.myProject).completeJustSubmittedTasks();
            ArrayList<PsiFile> movedFiles = new ArrayList<PsiFile>();
            HashMap<PsiElement, PsiElement> oldToNewElementsMapping = new HashMap<PsiElement, PsiElement>();
            for (VirtualFile virtualFile : this.myFilesToMove.keySet()) {
                MoveDirectoryWithClassesHelper helper;
                boolean processed2;
                PsiFile file2 = this.myManager.findFile(virtualFile);
                if (file2 == null) continue;
                for (MoveDirectoryWithClassesHelper helper2 : MoveDirectoryWithClassesHelper.findAll()) {
                    helper2.beforeMove(file2);
                }
                RefactoringElementListener refactoringElementListener = this.getTransaction().getElementListener((PsiElement)file2);
                PsiDirectory moveDestination = this.myFilesToMove.get(virtualFile).getTargetDirectory();
                Iterator<MoveDirectoryWithClassesHelper> iterator2 = MoveDirectoryWithClassesHelper.findAll().iterator();
                while (iterator2.hasNext() && !(processed2 = (helper = iterator2.next()).move(file2, moveDestination, oldToNewElementsMapping, movedFiles, refactoringElementListener))) {
                }
            }
            for (PsiElement newElement : oldToNewElementsMapping.values()) {
                for (MoveDirectoryWithClassesHelper moveDirectoryWithClassesHelper : MoveDirectoryWithClassesHelper.findAll()) {
                    moveDirectoryWithClassesHelper.afterMove(newElement);
                }
            }
            for (PsiFile movedFile : movedFiles) {
                MoveFileHandler.forElement(movedFile).updateMovedFile(movedFile);
                FileReferenceContextUtil.decodeFileReferences((PsiElement)movedFile);
            }
            this.myNonCodeUsages = CommonMoveUtil.retargetUsages(usages, oldToNewElementsMapping);
            for (MoveDirectoryWithClassesHelper helper : MoveDirectoryWithClassesHelper.findAll()) {
                helper.postProcessUsages(usages, (Function<PsiDirectory, PsiDirectory>)((Function)dir -> this.getResultDirectory((PsiDirectory)dir).findOrCreateTargetDirectory()));
            }
            for (Iterator<Object> iterator3 : this.myDirectories) {
                if (this.isUsedInTarget((PsiDirectory)iterator3)) continue;
                iterator3.delete();
            }
            for (PsiDirectory directory : this.myNestedDirsToMove.keySet()) {
                if (!directory.isValid() || directory.getChildren().length != 0) continue;
                directory.delete();
            }
        }
        catch (IncorrectOperationException e) {
            this.myNonCodeUsages = new NonCodeUsageInfo[0];
            RefactoringUIUtil.processIncorrectOperation(this.myProject, e);
        }
    }

    private boolean isUsedInTarget(PsiDirectory directory) {
        PsiDirectory targetDirectory = this.myNestedDirsToMove.get(directory).getTargetDirectory();
        if (targetDirectory != null && PsiTreeUtil.isAncestor((PsiElement)directory, (PsiElement)targetDirectory, (boolean)false)) {
            return true;
        }
        return PsiTreeUtil.isAncestor((PsiElement)targetDirectory, (PsiElement)directory, (boolean)false);
    }

    @Override
    @Nullable
    protected String getRefactoringId() {
        return "refactoring.move";
    }

    @Override
    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data2 = new RefactoringEventData();
        data2.addElements((PsiElement[])this.myDirectories);
        return data2;
    }

    @Override
    @Nullable
    protected RefactoringEventData getAfterData(UsageInfo @NotNull [] usages) {
        RefactoringEventData data2 = new RefactoringEventData();
        data2.addElement((PsiElement)this.myTargetDirectory);
        return data2;
    }

    private TargetDirectoryWrapper getResultDirectory(PsiDirectory dir) {
        return this.myTargetDirectory != null ? new TargetDirectoryWrapper(this.myTargetDirectory, dir.getName()) : this.getTargetDirectory(dir);
    }

    @Override
    protected void performPsiSpoilingRefactoring() {
        if (this.myNonCodeUsages == null) {
            return;
        }
        RenameUtil.renameNonCodeUsages(this.myProject, this.myNonCodeUsages);
        if (this.myMoveCallback != null) {
            this.myMoveCallback.refactoringCompleted();
        }
    }

    private static void collectFiles2Move(Map<VirtualFile, TargetDirectoryWrapper> files2Move, Map<PsiDirectory, TargetDirectoryWrapper> nestedDirsToMove, PsiDirectory directory, PsiDirectory rootDirectory, @NotNull TargetDirectoryWrapper targetDirectory) {
        PsiElement[] children2 = directory.getChildren();
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)directory.getVirtualFile(), (VirtualFile)rootDirectory.getVirtualFile(), (char)'/');
        TargetDirectoryWrapper newTargetDirectory = relativePath.length() == 0 ? targetDirectory : targetDirectory.findOrCreateChild(relativePath);
        nestedDirsToMove.put(directory, newTargetDirectory);
        for (PsiElement child2 : children2) {
            if (child2 instanceof PsiFile) {
                files2Move.put(PsiUtilCore.getVirtualFile((PsiElement)child2), newTargetDirectory);
                continue;
            }
            if (!(child2 instanceof PsiDirectory)) continue;
            MoveDirectoryWithClassesProcessor.collectFiles2Move(files2Move, nestedDirsToMove, (PsiDirectory)child2, directory, newTargetDirectory);
        }
    }

    @Override
    @NotNull
    protected String getCommandName() {
        return RefactoringBundle.message((String)"moving.directories.command");
    }

    @NotNull
    public TargetDirectoryWrapper getTargetDirectory(PsiDirectory dir) {
        return new TargetDirectoryWrapper(this.myTargetDirectory);
    }

    public static class TargetDirectoryWrapper {
        private TargetDirectoryWrapper myParentDirectory;
        private PsiDirectory myTargetDirectory;
        private String myRelativePath;

        public TargetDirectoryWrapper(PsiDirectory targetDirectory) {
            this.myTargetDirectory = targetDirectory;
        }

        public TargetDirectoryWrapper(TargetDirectoryWrapper parentDirectory, String relativePath) {
            this.myParentDirectory = parentDirectory;
            this.myRelativePath = relativePath;
        }

        public TargetDirectoryWrapper(PsiDirectory parentDirectory, String relativePath) {
            this.myTargetDirectory = parentDirectory.findSubdirectory(relativePath);
            this.myParentDirectory = new TargetDirectoryWrapper(parentDirectory);
            this.myRelativePath = relativePath;
        }

        public PsiDirectory findOrCreateTargetDirectory() throws IncorrectOperationException {
            if (this.myTargetDirectory == null) {
                String[] pathComponents;
                PsiDirectory root = this.myParentDirectory.findOrCreateTargetDirectory();
                for (String component2 : pathComponents = this.myRelativePath.split("/")) {
                    this.myTargetDirectory = root.findSubdirectory(component2);
                    if (this.myTargetDirectory == null) {
                        this.myTargetDirectory = root.createSubdirectory(component2);
                    }
                    root = this.myTargetDirectory;
                }
            }
            return this.myTargetDirectory;
        }

        @Nullable
        public PsiDirectory getTargetDirectory() {
            return this.myTargetDirectory;
        }

        public TargetDirectoryWrapper findOrCreateChild(String relativePath) {
            PsiDirectory psiDirectory;
            if (this.myTargetDirectory != null && (psiDirectory = this.myTargetDirectory.findSubdirectory(relativePath)) != null) {
                return new TargetDirectoryWrapper(psiDirectory);
            }
            return new TargetDirectoryWrapper(this, relativePath);
        }

        public void checkMove(PsiFile psiFile) throws IncorrectOperationException {
            if (this.myTargetDirectory != null) {
                MoveFilesOrDirectoriesUtil.checkMove((PsiElement)psiFile, (PsiElement)this.myTargetDirectory);
            }
        }
    }
}

