/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.listeners.impl.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import com.intellij.refactoring.listeners.UndoRefactoringElementListener;
import com.intellij.refactoring.listeners.impl.RefactoringTransaction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class RefactoringTransactionImpl
implements RefactoringTransaction {
    private static final Logger LOG = Logger.getInstance(RefactoringTransactionImpl.class);
    private final List<Runnable> myRunnables = new ArrayList<Runnable>();
    private final List<? extends RefactoringElementListenerProvider> myListenerProviders;
    private final Project myProject;
    private final Map<PsiElement, List<RefactoringElementListener>> myOldElementToListenerListMap = new HashMap<PsiElement, List<RefactoringElementListener>>();
    private final Map<PsiElement, RefactoringElementListener> myOldElementToTransactionListenerMap = new HashMap<PsiElement, RefactoringElementListener>();

    public RefactoringTransactionImpl(Project project, List<? extends RefactoringElementListenerProvider> listenerProviders) {
        this.myListenerProviders = listenerProviders;
        this.myProject = project;
    }

    private void addAffectedElement(PsiElement oldElement) {
        if (this.myOldElementToListenerListMap.get(oldElement) != null) {
            return;
        }
        ArrayList<RefactoringElementListener> listenerList = new ArrayList<RefactoringElementListener>();
        for (RefactoringElementListenerProvider refactoringElementListenerProvider : this.myListenerProviders) {
            try {
                RefactoringElementListener listener2 = refactoringElementListenerProvider.getListener(oldElement);
                if (listener2 == null) continue;
                listenerList.add(listener2);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        this.myOldElementToListenerListMap.put(oldElement, listenerList);
    }

    @Override
    @NotNull
    public RefactoringElementListener getElementListener(@NotNull PsiElement oldElement) {
        RefactoringElementListener listener2 = this.myOldElementToTransactionListenerMap.get(oldElement);
        if (listener2 == null) {
            listener2 = new MyRefactoringElementListener(oldElement);
            this.myOldElementToTransactionListenerMap.put(oldElement, listener2);
        }
        return listener2;
    }

    @Override
    public void commit() {
        DumbService dumbService = DumbService.getInstance((Project)this.myProject);
        for (Runnable runnable2 : this.myRunnables) {
            dumbService.withAlternativeResolveEnabled(runnable2);
        }
    }

    private class MyRefactoringElementListener
    implements RefactoringElementListener,
    UndoRefactoringElementListener {
        private final List<RefactoringElementListener> myListenerList;

        private MyRefactoringElementListener(PsiElement oldElement) {
            RefactoringTransactionImpl.this.addAffectedElement(oldElement);
            this.myListenerList = (List)RefactoringTransactionImpl.this.myOldElementToListenerListMap.get(oldElement);
        }

        public void elementMoved(@NotNull PsiElement newElement) {
            if (!newElement.isValid()) {
                return;
            }
            SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)newElement.getProject()).createSmartPsiElementPointer(newElement);
            RefactoringTransactionImpl.this.myRunnables.add(() -> {
                PsiElement element2 = pointer.getElement();
                if (element2 == null) {
                    LOG.info("Unable to restore element for: " + newElement.getClass());
                    return;
                }
                for (RefactoringElementListener refactoringElementListener : this.myListenerList) {
                    try {
                        refactoringElementListener.elementMoved(element2);
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                    }
                }
            });
        }

        public void elementRenamed(@NotNull PsiElement newElement) {
            if (!newElement.isValid()) {
                return;
            }
            SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)RefactoringTransactionImpl.this.myProject).createSmartPsiElementPointer(newElement);
            RefactoringTransactionImpl.this.myRunnables.add(() -> {
                PsiElement element2 = pointer.getElement();
                if (element2 == null) {
                    LOG.info("Unable to restore element: " + newElement.getClass());
                    return;
                }
                for (RefactoringElementListener refactoringElementListener : this.myListenerList) {
                    try {
                        refactoringElementListener.elementRenamed(element2);
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                    }
                }
            });
        }

        public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
            for (RefactoringElementListener listener2 : this.myListenerList) {
                if (!(listener2 instanceof UndoRefactoringElementListener)) continue;
                ((UndoRefactoringElementListener)listener2).undoElementMovedOrRenamed(newElement, oldQualifiedName);
            }
        }
    }
}

