/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public abstract class InlineOptionsWithSearchSettingsDialog
extends InlineOptionsDialog {
    protected JCheckBox myCbSearchInComments;
    protected JCheckBox myCbSearchTextOccurences;

    protected InlineOptionsWithSearchSettingsDialog(Project project, boolean canBeParent, PsiElement element2) {
        super(project, canBeParent, element2);
    }

    protected abstract boolean isSearchInCommentsAndStrings();

    protected abstract void saveSearchInCommentsAndStrings(boolean var1);

    protected abstract boolean isSearchForTextOccurrences();

    protected abstract void saveSearchInTextOccurrences(boolean var1);

    @Override
    protected void doAction() {
        boolean searchInNonJava = this.myCbSearchTextOccurences.isSelected();
        boolean searchInComments = this.myCbSearchInComments.isSelected();
        if (this.myCbSearchInComments.isEnabled()) {
            this.saveSearchInCommentsAndStrings(searchInComments);
        }
        if (this.myCbSearchTextOccurences.isEnabled()) {
            this.saveSearchInTextOccurrences(searchInNonJava);
        }
    }

    public void setEnabledSearchSettngs(boolean enabled) {
        this.myCbSearchInComments.setEnabled(enabled);
        this.myCbSearchTextOccurences.setEnabled(enabled);
        if (enabled) {
            this.myCbSearchInComments.setSelected(this.isSearchInCommentsAndStrings());
            this.myCbSearchTextOccurences.setSelected(this.isSearchForTextOccurrences());
        } else {
            this.myCbSearchInComments.setSelected(false);
            this.myCbSearchTextOccurences.setSelected(false);
        }
    }

    @Override
    @NotNull
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.insets.bottom = JBUIScale.scale((int)10);
        panel2.add((Component)super.createCenterPanel(), gbc);
        this.myCbSearchInComments = new JCheckBox(RefactoringBundle.message((String)"search.in.comments.and.strings"), this.isSearchInCommentsAndStrings());
        this.myCbSearchTextOccurences = new JCheckBox(RefactoringBundle.message((String)"search.for.text.occurrences"), this.isSearchForTextOccurrences());
        gbc.insets.bottom = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.gridy = 1;
        gbc.gridx = 0;
        panel2.add((Component)this.myCbSearchInComments, gbc);
        gbc.gridx = 1;
        panel2.add((Component)this.myCbSearchTextOccurences, gbc);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InlineOptionsWithSearchSettingsDialog.this.setEnabledSearchSettngs(InlineOptionsWithSearchSettingsDialog.this.myRbInlineAll.isSelected() || InlineOptionsWithSearchSettingsDialog.this.myKeepTheDeclaration != null && InlineOptionsWithSearchSettingsDialog.this.myKeepTheDeclaration.isSelected());
            }
        };
        this.myRbInlineThisOnly.addActionListener(actionListener);
        this.myRbInlineAll.addActionListener(actionListener);
        if (this.myKeepTheDeclaration != null) {
            this.myKeepTheDeclaration.addActionListener(actionListener);
        }
        this.setEnabledSearchSettngs(this.myRbInlineAll.isSelected());
        return panel2;
    }
}

