/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature.inplace;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface LanguageChangeSignatureDetector<C extends ChangeInfo> {
    @NotNull
    public C createInitialChangeInfo(@NotNull PsiElement var1);

    public boolean ignoreChanges(PsiElement var1);

    @Nullable
    public C createNextChangeInfo(String var1, @NotNull C var2, boolean var3);

    public void performChange(C var1, Editor var2, @NotNull String var3);

    public boolean isChangeSignatureAvailableOnElement(@NotNull PsiElement var1, C var2);

    public TextRange getHighlightingRange(@NotNull C var1);

    @NotNull
    default public String extractSignature(@NotNull C initialChangeInfo) {
        TextRange signatureRange = this.getHighlightingRange(initialChangeInfo);
        return signatureRange.shiftRight(-signatureRange.getStartOffset()).substring(initialChangeInfo.getMethod().getText());
    }

    default public String getMethodSignaturePreview(C info, List<? super TextRange> deleteRanges, List<? super TextRange> newRanges) {
        return this.extractSignature(info);
    }

    public FileType getFileType();
}

