/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.IntroduceTarget;
import com.intellij.refactoring.introduce.PsiIntroduceTarget;
import com.intellij.ui.JBColor;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntroduceTargetChooser {
    private IntroduceTargetChooser() {
    }

    public static <T extends PsiElement> void showChooser(@NotNull Editor editor, @NotNull List<? extends T> expressions, @NotNull Pass<? super T> callback2, @NotNull Function<? super T, String> renderer) {
        IntroduceTargetChooser.showChooser(editor, expressions, callback2, renderer, RefactoringBundle.message((String)"introduce.target.chooser.expressions.title"));
    }

    public static <T extends PsiElement> void showChooser(@NotNull Editor editor, @NotNull List<? extends T> expressions, @NotNull Pass<? super T> callback2, @NotNull Function<? super T, String> renderer, @NotNull @NlsContexts.PopupTitle String title) {
        IntroduceTargetChooser.showChooser(editor, expressions, callback2, renderer, title, ScopeHighlighter.NATURAL_RANGER);
    }

    public static <T extends PsiElement> void showChooser(@NotNull Editor editor, @NotNull List<? extends T> expressions, @NotNull Pass<? super T> callback2, @NotNull Function<? super T, String> renderer, @NotNull @NlsContexts.PopupTitle String title, @NotNull NotNullFunction<? super PsiElement, ? extends TextRange> ranger) {
        IntroduceTargetChooser.showChooser(editor, expressions, callback2, renderer, title, -1, ranger);
    }

    public static <T extends PsiElement> void showChooser(@NotNull Editor editor, @NotNull List<? extends T> expressions, final @NotNull Pass<? super T> callback2, @NotNull Function<? super T, String> renderer, @NotNull @NlsContexts.PopupTitle String title, int selection, @NotNull NotNullFunction<? super PsiElement, ? extends TextRange> ranger) {
        List targets2 = ContainerUtil.map(expressions, t -> new MyIntroduceTarget<PsiElement>((PsiElement)t, (NotNullFunction<PsiElement, TextRange>)ranger, (Function<PsiElement, String>)renderer));
        Pass callbackWrapper = new Pass<MyIntroduceTarget<T>>(){

            public void pass(MyIntroduceTarget<T> target2) {
                callback2.pass(target2.getPlace());
            }
        };
        IntroduceTargetChooser.showIntroduceTargetChooser(editor, targets2, callbackWrapper, title, selection);
    }

    public static <T extends IntroduceTarget> void showIntroduceTargetChooser(@NotNull Editor editor, @NotNull List<T> expressions, @NotNull Pass<? super T> callback2, @NotNull @NlsContexts.PopupTitle String title, int selection) {
        IntroduceTargetChooser.showIntroduceTargetChooser(editor, expressions, callback2, title, null, selection);
    }

    public static <T extends IntroduceTarget> void showIntroduceTargetChooser(@NotNull Editor editor, @NotNull List<T> expressions, @NotNull Pass<? super T> callback2, @NotNull @NlsContexts.PopupTitle String title, @Nullable JComponent southComponent, int selection) {
        final AtomicReference<ScopeHighlighter> highlighter = new AtomicReference<ScopeHighlighter>(new ScopeHighlighter(editor));
        IPopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(expressions).setSelectionMode(0).setSelectedValue(expressions.get(selection > -1 ? selection : 0), true).setAccessibleName(title).setTitle(title).setMovable(false).setResizable(false).setRequestFocus(true).setItemSelectedCallback(expr -> {
            ScopeHighlighter h = (ScopeHighlighter)highlighter.get();
            if (h == null) {
                return;
            }
            h.dropHighlight();
            if (expr != null && expr.isValid()) {
                TextRange range2 = expr.getTextRange();
                h.highlight((Pair<TextRange, List<TextRange>>)Pair.create((Object)range2, Collections.singletonList(range2)));
            }
        }).setItemChosenCallback(expr -> {
            if (expr.isValid()) {
                callback2.pass(expr);
            }
        }).addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                ((ScopeHighlighter)highlighter.getAndSet(null)).dropHighlight();
            }
        }).setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                Component rendererComponent = super.getListCellRendererComponent((JList<?>)list2, value2, index, isSelected, cellHasFocus);
                IntroduceTarget expr = (IntroduceTarget)value2;
                if (expr.isValid()) {
                    String text;
                    int firstNewLinePos = (text = expr.render()).indexOf(10);
                    String trimmedText = text.substring(0, firstNewLinePos != -1 ? firstNewLinePos : Math.min(100, text.length()));
                    if (trimmedText.length() != text.length()) {
                        trimmedText = trimmedText + " ...";
                    }
                    this.setText(trimmedText);
                } else {
                    this.setForeground((Color)JBColor.RED);
                    this.setText(IdeBundle.message((String)"invalid.node.text", (Object[])new Object[0]));
                }
                return rendererComponent;
            }
        });
        if (southComponent != null && builder2 instanceof PopupChooserBuilder) {
            ((PopupChooserBuilder)builder2).setSouthComponent(southComponent);
        }
        JBPopup popup2 = builder2.createPopup();
        popup2.showInBestPositionFor(editor);
        Project project = editor.getProject();
        if (project != null && !popup2.isDisposed()) {
            NavigationUtil.hidePopupIfDumbModeStarts(popup2, project);
        }
    }

    private static class MyIntroduceTarget<T extends PsiElement>
    extends PsiIntroduceTarget<T> {
        private final NotNullFunction<? super PsiElement, ? extends TextRange> myRanger;
        private final Function<? super T, String> myRenderer;

        MyIntroduceTarget(@NotNull T psi, @NotNull NotNullFunction<? super PsiElement, ? extends TextRange> ranger, @NotNull Function<? super T, String> renderer) {
            super(psi);
            this.myRanger = ranger;
            this.myRenderer = renderer;
        }

        @Override
        @NotNull
        public TextRange getTextRange() {
            return (TextRange)this.myRanger.fun(this.getPlace());
        }

        @Override
        @NotNull
        public String render() {
            return (String)this.myRenderer.fun(this.getPlace());
        }

        public String toString() {
            return this.isValid() ? this.render() : "invalid";
        }
    }
}

