/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.ErrorQuickFixProvider;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.TemplateDataLanguageConfigurable;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class TemplateLanguageErrorQuickFixProvider
implements ErrorQuickFixProvider {
    @Override
    public void registerErrorQuickFix(@NotNull PsiErrorElement errorElement, @NotNull HighlightInfo highlightInfo) {
        PsiFile psiFile = errorElement.getContainingFile();
        FileViewProvider provider = psiFile.getViewProvider();
        if (!(provider instanceof TemplateLanguageFileViewProvider)) {
            return;
        }
        if (psiFile.getLanguage() != ((TemplateLanguageFileViewProvider)provider).getTemplateDataLanguage()) {
            return;
        }
        QuickFixAction.registerQuickFixAction(highlightInfo, TemplateLanguageErrorQuickFixProvider.createChangeTemplateDataLanguageFix((PsiElement)errorElement));
    }

    public static IntentionAction createChangeTemplateDataLanguageFix(PsiElement errorElement) {
        PsiFile containingFile = errorElement.getContainingFile();
        final VirtualFile virtualFile = containingFile.getVirtualFile();
        final Language language = ((TemplateLanguageFileViewProvider)containingFile.getViewProvider()).getTemplateDataLanguage();
        return new IntentionAction(){

            @NotNull
            public String getText() {
                return LangBundle.message((String)"quickfix.change.template.data.language.text", (Object[])new Object[]{language.getDisplayName()});
            }

            @NotNull
            public String getFamilyName() {
                return this.getText();
            }

            public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
                return true;
            }

            public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
                TemplateDataLanguageConfigurable configurable2 = new TemplateDataLanguageConfigurable(project);
                ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable2, () -> {
                    if (virtualFile != null) {
                        configurable2.selectFile(virtualFile);
                    }
                });
            }

            public boolean startInWriteAction() {
                return false;
            }
        };
    }
}

