/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.lang.DependentLanguage;
import com.intellij.lang.InjectableLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguagePerFileMappings;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.templateLanguages.TemplateDataLanguagePatterns;
import com.intellij.psi.templateLanguages.TemplateDataLanguagePusher;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="TemplateDataLanguageMappings", storages={@Storage(value="templateLanguages.xml")})
public class TemplateDataLanguageMappings
extends LanguagePerFileMappings<Language> {
    private final FilePropertyPusher<Language> myPropertyPusher = new TemplateDataLanguagePusher();

    public static TemplateDataLanguageMappings getInstance(Project project) {
        return (TemplateDataLanguageMappings)ServiceManager.getService((Project)project, TemplateDataLanguageMappings.class);
    }

    public TemplateDataLanguageMappings(Project project) {
        super(project);
    }

    @Override
    protected String serialize(Language language) {
        return language.getID();
    }

    @Override
    @NotNull
    public List<Language> getAvailableValues() {
        return TemplateDataLanguageMappings.getTemplateableLanguages();
    }

    @Override
    @Nullable
    public Language getMapping(@Nullable VirtualFile file2) {
        Language t = (Language)this.getConfiguredMapping(file2);
        return t == null || t == Language.ANY ? this.getDefaultMapping(file2) : t;
    }

    @Override
    public Language getDefaultMapping(@Nullable VirtualFile file2) {
        return TemplateDataLanguageMappings.getDefaultMappingForFile(file2);
    }

    @Nullable
    public static Language getDefaultMappingForFile(@Nullable VirtualFile file2) {
        return file2 == null ? null : TemplateDataLanguagePatterns.getInstance().getTemplateDataLanguageByFileName(file2);
    }

    @NotNull
    public static List<Language> getTemplateableLanguages() {
        return ContainerUtil.findAll((Collection)Language.getRegisteredLanguages(), (Condition)new Condition<Language>(){

            public boolean value(Language language) {
                if (language == Language.ANY) {
                    return false;
                }
                if (language instanceof TemplateLanguage || language instanceof DependentLanguage || language instanceof InjectableLanguage) {
                    return false;
                }
                if (language.getBaseLanguage() != null) {
                    return this.value(language.getBaseLanguage());
                }
                return true;
            }
        });
    }

    @Override
    @NotNull
    protected FilePropertyPusher<Language> getFilePropertyPusher() {
        return this.myPropertyPusher;
    }
}

