/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.ITemplateDataElementType;
import com.intellij.psi.templateLanguages.OuterLanguageElementImpl;
import com.intellij.psi.templateLanguages.RangeCollectorImpl;
import com.intellij.psi.templateLanguages.SimpleTreePatcher;
import com.intellij.psi.templateLanguages.TemplateDataModifications;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.templateLanguages.TreePatcher;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILazyParseableElementTypeBase;
import com.intellij.psi.tree.TokenSet;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.CharTable;
import com.intellij.util.LocalTimeCounter;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateDataElementType
extends IFileElementType
implements ITemplateDataElementType {
    public static final LanguageExtension<TreePatcher> TREE_PATCHER = new LanguageExtension("com.intellij.lang.treePatcher", (Object)new SimpleTreePatcher());
    @NotNull
    private final IElementType myTemplateElementType;
    @NotNull
    final IElementType myOuterElementType;
    private final NotNullLazyValue<Boolean> REQUIRES_OLD_CREATE_TEMPLATE_TEXT = VolatileNotNullLazyValue.createValue(() -> {
        Class<?> aClass = ((Object)((Object)this)).getClass();
        while (!TemplateDataElementType.class.equals(aClass)) {
            try {
                aClass.getDeclaredMethod("appendCurrentTemplateToken", StringBuilder.class, CharSequence.class, Lexer.class, RangeCollector.class);
                return true;
            }
            catch (NoSuchMethodException e) {
                aClass = aClass.getSuperclass();
            }
        }
        return false;
    });

    public TemplateDataElementType(@NonNls String debugName, Language language, @NotNull IElementType templateElementType, @NotNull IElementType outerElementType) {
        super(debugName, language);
        this.myTemplateElementType = templateElementType;
        this.myOuterElementType = outerElementType;
    }

    protected Lexer createBaseLexer(TemplateLanguageFileViewProvider viewProvider) {
        return ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(viewProvider.getBaseLanguage())).createLexer(viewProvider.getManager().getProject());
    }

    protected LanguageFileType createTemplateFakeFileType(Language language) {
        return new TemplateFileType(language);
    }

    public ASTNode parseContents(@NotNull ASTNode chameleon) {
        CharTable charTable = SharedImplUtil.findCharTableByTree(chameleon);
        FileElement fileElement = TreeUtil.getFileElement((TreeElement)chameleon);
        PsiFile psiFile = (PsiFile)fileElement.getPsi();
        PsiFile originalPsiFile = psiFile.getOriginalFile();
        TemplateLanguageFileViewProvider viewProvider = (TemplateLanguageFileViewProvider)originalPsiFile.getViewProvider();
        Language templateLanguage = this.getTemplateFileLanguage(viewProvider);
        CharSequence sourceCode = chameleon.getChars();
        RangeCollectorImpl collector = new RangeCollectorImpl(this);
        PsiFile templatePsiFile = this.createTemplateFile(psiFile, templateLanguage, sourceCode, viewProvider, collector);
        FileElement templateFileElement = ((PsiFileImpl)templatePsiFile).calcTreeElement();
        return (ASTNode)DebugUtil.performPsiModification("template language parsing", () -> {
            collector.insertOuterElementsAndRemoveRanges(templateFileElement, sourceCode, charTable, templateFileElement.getPsi().getLanguage());
            TreeElement childNode = templateFileElement.getFirstChildNode();
            DebugUtil.checkTreeStructure(templateFileElement);
            DebugUtil.checkTreeStructure(chameleon);
            if (fileElement != chameleon) {
                DebugUtil.checkTreeStructure((ASTNode)psiFile.getNode());
                DebugUtil.checkTreeStructure((ASTNode)originalPsiFile.getNode());
            }
            return childNode;
        });
    }

    protected Language getTemplateFileLanguage(TemplateLanguageFileViewProvider viewProvider) {
        return viewProvider.getTemplateDataLanguage();
    }

    protected PsiFile createTemplateFile(PsiFile psiFile, Language templateLanguage, CharSequence sourceCode, TemplateLanguageFileViewProvider viewProvider, @NotNull RangeCollector rangeCollector) {
        CharSequence templateSourceCode = this.createTemplateText(sourceCode, this.createBaseLexer(viewProvider), rangeCollector);
        if (rangeCollector instanceof RangeCollectorImpl) {
            ((RangeCollectorImpl)rangeCollector).prepareFileForParsing(templateLanguage, sourceCode, templateSourceCode);
        }
        return this.createPsiFileFromSource(templateLanguage, templateSourceCode, psiFile.getManager());
    }

    protected CharSequence createTemplateText(@NotNull CharSequence sourceCode, @NotNull Lexer baseLexer, @NotNull RangeCollector rangeCollector) {
        if (((Boolean)this.REQUIRES_OLD_CREATE_TEMPLATE_TEXT.getValue()).booleanValue()) {
            return this.oldCreateTemplateText(sourceCode, baseLexer, rangeCollector);
        }
        TemplateDataModifications modifications = this.collectTemplateModifications(sourceCode, baseLexer);
        return ((RangeCollectorImpl)rangeCollector).applyTemplateDataModifications(sourceCode, modifications);
    }

    private CharSequence oldCreateTemplateText(@NotNull CharSequence sourceCode, @NotNull Lexer baseLexer, @NotNull RangeCollector rangeCollector) {
        StringBuilder result2 = new StringBuilder(sourceCode.length());
        baseLexer.start(sourceCode);
        TextRange currentRange = TextRange.EMPTY_RANGE;
        while (baseLexer.getTokenType() != null) {
            TextRange newRange = TextRange.create((int)baseLexer.getTokenStart(), (int)baseLexer.getTokenEnd());
            assert (currentRange.getEndOffset() == newRange.getStartOffset()) : "Inconsistent tokens stream from " + baseLexer + ": " + TemplateDataElementType.getRangeDump(currentRange, sourceCode) + " followed by " + TemplateDataElementType.getRangeDump(newRange, sourceCode);
            currentRange = newRange;
            if (baseLexer.getTokenType() == this.myTemplateElementType) {
                this.appendCurrentTemplateToken(result2, sourceCode, baseLexer, rangeCollector);
            } else {
                rangeCollector.addOuterRange(currentRange);
            }
            baseLexer.advance();
        }
        return result2;
    }

    @NotNull
    protected TemplateDataModifications collectTemplateModifications(@NotNull CharSequence sourceCode, @NotNull Lexer baseLexer) {
        TemplateDataModifications modifications = new TemplateDataModifications();
        baseLexer.start(sourceCode);
        TextRange currentRange = TextRange.EMPTY_RANGE;
        while (baseLexer.getTokenType() != null) {
            TextRange newRange = TextRange.create((int)baseLexer.getTokenStart(), (int)baseLexer.getTokenEnd());
            assert (currentRange.getEndOffset() == newRange.getStartOffset()) : "Inconsistent tokens stream from " + baseLexer + ": " + TemplateDataElementType.getRangeDump(currentRange, sourceCode) + " followed by " + TemplateDataElementType.getRangeDump(newRange, sourceCode);
            currentRange = newRange;
            if (baseLexer.getTokenType() == this.myTemplateElementType) {
                TemplateDataModifications tokenModifications = this.appendCurrentTemplateToken(baseLexer.getTokenEnd(), baseLexer.getTokenSequence());
                modifications.addAll(tokenModifications);
            } else {
                modifications.addOuterRange(currentRange, this.getTemplateDataInsertionTokens().contains(baseLexer.getTokenType()));
            }
            baseLexer.advance();
        }
        return modifications;
    }

    @NotNull
    private static String getRangeDump(@NotNull TextRange range2, @NotNull CharSequence sequence) {
        return "'" + StringUtil.escapeLineBreak((String)range2.subSequence(sequence).toString()) + "' " + range2;
    }

    @Deprecated
    protected void appendCurrentTemplateToken(@NotNull StringBuilder result2, @NotNull CharSequence buf, @NotNull Lexer lexer, @NotNull RangeCollector collector) {
        result2.append(buf, lexer.getTokenStart(), lexer.getTokenEnd());
    }

    @NotNull
    protected TemplateDataModifications appendCurrentTemplateToken(int tokenEndOffset, @NotNull CharSequence tokenText) {
        return TemplateDataModifications.EMPTY;
    }

    @NotNull
    protected TokenSet getTemplateDataInsertionTokens() {
        return TokenSet.EMPTY;
    }

    protected OuterLanguageElementImpl createOuterLanguageElement(@NotNull CharSequence internedTokenText, @NotNull IElementType outerElementType) {
        return new OuterLanguageElementImpl(outerElementType, internedTokenText);
    }

    protected PsiFile createPsiFileFromSource(final Language language, CharSequence sourceCode, PsiManager manager) {
        LightVirtualFile virtualFile = new LightVirtualFile("foo", (FileType)this.createTemplateFakeFileType(language), sourceCode, LocalTimeCounter.currentTime());
        SingleRootFileViewProvider viewProvider = new SingleRootFileViewProvider(manager, (VirtualFile)virtualFile, false){

            @Override
            @NotNull
            public Language getBaseLanguage() {
                return language;
            }
        };
        SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)virtualFile);
        return viewProvider.getPsi(language);
    }

    @NotNull
    public static ASTNode parseWithOuterAndRemoveRangesApplied(@NotNull ASTNode chameleon, @NotNull Language language, @NotNull @NotNull Function<@NotNull CharSequence, @NotNull ASTNode> parser) {
        RangeCollectorImpl collector = (RangeCollectorImpl)chameleon.getUserData(RangeCollectorImpl.OUTER_ELEMENT_RANGES);
        return collector != null ? collector.applyRangeCollectorAndExpandChameleon(chameleon, language, parser) : parser.apply(chameleon.getChars());
    }

    public static interface OuterLanguageRangePatcher {
        @ApiStatus.Internal
        public static final LanguageExtension<OuterLanguageRangePatcher> EXTENSION = new LanguageExtension("com.intellij.outerLanguageRangePatcher");

        @Nullable
        public String getTextForOuterLanguageInsertionRange(@NotNull TemplateDataElementType var1, @NotNull CharSequence var2);
    }

    public static interface TemplateAwareElementType
    extends ILazyParseableElementTypeBase {
        @NotNull
        public TreeElement createTreeElement(@NotNull CharSequence var1);
    }

    public static abstract class RangeCollector {
        public void addOuterRange(@NotNull TextRange newRange) {
        }

        public abstract void addOuterRange(@NotNull TextRange var1, boolean var2);

        public void addRangeToRemove(@NotNull TextRange rangeToRemove) {
        }
    }

    protected static class TemplateFileType
    extends LanguageFileType {
        private final Language myLanguage;

        protected TemplateFileType(Language language) {
            super(language);
            this.myLanguage = language;
        }

        @NotNull
        public String getDefaultExtension() {
            return "";
        }

        @NotNull
        @NonNls
        public String getDescription() {
            return "fake for language" + this.myLanguage.getID();
        }

        @Nullable
        public Icon getIcon() {
            return null;
        }

        @NotNull
        @NonNls
        public String getName() {
            return this.myLanguage.getID();
        }
    }
}

