/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.psi.stubs.FileLocalStringEnumerator;
import com.intellij.psi.stubs.StubIdExternalizer;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubIndexKeyDescriptorCache;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StubForwardIndexExternalizer<StubKeySerializationState>
implements DataExternalizer<Map<StubIndexKey<?, ?>, Map<Object, StubIdList>>> {
    @NotNull
    public static StubForwardIndexExternalizer<?> getIdeUsedExternalizer() {
        if (System.getProperty("idea.uses.shareable.serialized.stubs") == null) {
            return new IdeStubForwardIndexesExternalizer();
        }
        return new FileLocalStubForwardIndexExternalizer();
    }

    @NotNull
    public static StubForwardIndexExternalizer<?> createFileLocalExternalizer() {
        return new FileLocalStubForwardIndexExternalizer();
    }

    protected abstract StubKeySerializationState createStubIndexKeySerializationState(@NotNull DataOutput var1, @NotNull Set<StubIndexKey<?, ?>> var2) throws IOException;

    protected abstract void writeStubIndexKey(@NotNull DataOutput var1, @NotNull StubIndexKey var2, StubKeySerializationState var3) throws IOException;

    protected abstract StubKeySerializationState createStubIndexKeySerializationState(@NotNull DataInput var1, int var2) throws IOException;

    protected abstract ID<?, ?> readStubIndexKey(@NotNull DataInput var1, StubKeySerializationState var2) throws IOException;

    public final void save(@NotNull DataOutput out, Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> indexedStubs) throws IOException {
        DataInputOutputUtil.writeINT((DataOutput)out, (int)indexedStubs.size());
        if (!indexedStubs.isEmpty()) {
            StubKeySerializationState stubKeySerializationState = this.createStubIndexKeySerializationState(out, indexedStubs.keySet());
            for (StubIndexKey<?, ?> stubIndexKey : indexedStubs.keySet()) {
                this.writeStubIndexKey(out, stubIndexKey, stubKeySerializationState);
                Map<Object, StubIdList> map2 = indexedStubs.get(stubIndexKey);
                this.serializeIndexValue(out, stubIndexKey, map2);
            }
        }
    }

    public final Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> read(@NotNull DataInput in) throws IOException {
        return this.doRead(in, null, null);
    }

    <K> Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> doRead(@NotNull DataInput in, @Nullable StubIndexKey<K, ?> requestedIndex, @Nullable K requestedKey) throws IOException {
        int stubIndicesValueMapSize = DataInputOutputUtil.readINT((DataInput)in);
        if (stubIndicesValueMapSize > 0) {
            THashMap stubIndicesValueMap = requestedIndex != null ? null : new THashMap(stubIndicesValueMapSize);
            StubKeySerializationState stubKeySerializationState = this.createStubIndexKeySerializationState(in, stubIndicesValueMapSize);
            for (int i2 = 0; i2 < stubIndicesValueMapSize; ++i2) {
                ID<?, ?> indexKey = this.readStubIndexKey(in, stubKeySerializationState);
                if (indexKey instanceof StubIndexKey) {
                    boolean deserialize;
                    StubIndexKey stubIndexKey = (StubIndexKey)indexKey;
                    boolean bl = deserialize = requestedIndex == null || requestedIndex.equals((Object)stubIndexKey);
                    if (deserialize) {
                        Map<K, StubIdList> value2 = this.deserializeIndexValue(in, stubIndexKey, requestedKey);
                        if (requestedIndex != null) {
                            return Collections.singletonMap(requestedIndex, value2);
                        }
                        stubIndicesValueMap.put((Object)stubIndexKey, value2);
                        continue;
                    }
                    this.skipIndexValue(in);
                    continue;
                }
                assert (indexKey == null);
                this.skipIndexValue(in);
            }
            return stubIndicesValueMap;
        }
        return Collections.emptyMap();
    }

    <K> void serializeIndexValue(@NotNull DataOutput out, @NotNull StubIndexKey<K, ?> stubIndexKey, @NotNull Map<K, StubIdList> map2) throws IOException {
        KeyDescriptor<K> keyDescriptor = StubIndexKeyDescriptorCache.INSTANCE.getKeyDescriptor(stubIndexKey);
        BufferExposingByteArrayOutputStream indexOs = new BufferExposingByteArrayOutputStream();
        DataOutputStream indexDos = new DataOutputStream((OutputStream)indexOs);
        for (K key : map2.keySet()) {
            keyDescriptor.save((DataOutput)indexDos, key);
            StubIdExternalizer.INSTANCE.save((DataOutput)indexDos, map2.get(key));
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)indexDos.size());
        out.write(indexOs.getInternalBuffer(), 0, indexOs.size());
    }

    @NotNull
    <K> Map<K, StubIdList> deserializeIndexValue(@NotNull DataInput in, @NotNull StubIndexKey<K, ?> stubIndexKey, @Nullable K requestedKey) throws IOException {
        KeyDescriptor<K> keyDescriptor = StubIndexKeyDescriptorCache.INSTANCE.getKeyDescriptor(stubIndexKey);
        int bufferSize = DataInputOutputUtil.readINT((DataInput)in);
        byte[] buffer = new byte[bufferSize];
        in.readFully(buffer);
        UnsyncByteArrayInputStream indexIs = new UnsyncByteArrayInputStream(buffer);
        DataInputStream indexDis = new DataInputStream((InputStream)indexIs);
        TObjectHashingStrategy<K> hashingStrategy = StubIndexKeyDescriptorCache.INSTANCE.getKeyHashingStrategy(stubIndexKey);
        THashMap result2 = new THashMap(hashingStrategy);
        while (indexDis.available() > 0) {
            Object key = keyDescriptor.read((DataInput)indexDis);
            StubIdList read = StubIdExternalizer.INSTANCE.read(indexDis);
            if (requestedKey != null) {
                if (!hashingStrategy.equals(requestedKey, key)) continue;
                result2.put(key, read);
                return result2;
            }
            result2.put(key, read);
        }
        return result2;
    }

    void skipIndexValue(@NotNull DataInput in) throws IOException {
        int bufferSize = DataInputOutputUtil.readINT((DataInput)in);
        in.skipBytes(bufferSize);
    }

    private static final class FileLocalStubForwardIndexExternalizer
    extends StubForwardIndexExternalizer<FileLocalStringEnumerator> {
        private FileLocalStubForwardIndexExternalizer() {
        }

        @Override
        protected FileLocalStringEnumerator createStubIndexKeySerializationState(@NotNull DataOutput out, @NotNull Set<StubIndexKey<?, ?>> set) throws IOException {
            FileLocalStringEnumerator enumerator = new FileLocalStringEnumerator(true);
            for (StubIndexKey<?, ?> key : set) {
                enumerator.enumerate(key.getName());
            }
            enumerator.write(out);
            return enumerator;
        }

        @Override
        protected void writeStubIndexKey(@NotNull DataOutput out, @NotNull StubIndexKey key, FileLocalStringEnumerator enumerator) throws IOException {
            DataInputOutputUtil.writeINT((DataOutput)out, (int)enumerator.enumerate(key.getName()));
        }

        @Override
        protected FileLocalStringEnumerator createStubIndexKeySerializationState(@NotNull DataInput input, int stubIndexKeyCount) throws IOException {
            FileLocalStringEnumerator enumerator = new FileLocalStringEnumerator(false);
            enumerator.read(input, UnaryOperator.identity());
            return enumerator;
        }

        @Override
        protected ID<?, ?> readStubIndexKey(@NotNull DataInput input, FileLocalStringEnumerator enumerator) throws IOException {
            int idx = DataInputOutputUtil.readINT((DataInput)input);
            String name = enumerator.valueOf(idx);
            if (name == null) {
                throw new IOException("corrupted data: no value for idx = " + idx + " in local enumerator");
            }
            return ID.findByName((String)name);
        }
    }

    private static final class IdeStubForwardIndexesExternalizer
    extends StubForwardIndexExternalizer<Void> {
        private IdeStubForwardIndexesExternalizer() {
        }

        @Override
        protected void writeStubIndexKey(@NotNull DataOutput out, @NotNull StubIndexKey key, Void aVoid) throws IOException {
            DataInputOutputUtil.writeINT((DataOutput)out, (int)key.getUniqueId());
        }

        @Override
        protected Void createStubIndexKeySerializationState(@NotNull DataOutput out, @NotNull Set<StubIndexKey<?, ?>> set) {
            return null;
        }

        @Override
        protected ID<?, ?> readStubIndexKey(@NotNull DataInput input, Void aVoid) throws IOException {
            return ID.findById((int)DataInputOutputUtil.readINT((DataInput)input));
        }

        @Override
        protected Void createStubIndexKeySerializationState(@NotNull DataInput input, int stubIndexKeyCount) {
            return null;
        }
    }
}

