/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class IndexingStampInfo {
    final long indexingFileStamp;
    final long indexingByteLength;
    final int indexingCharLength;

    IndexingStampInfo(long indexingFileStamp, long indexingByteLength, int indexingCharLength) {
        this.indexingFileStamp = indexingFileStamp;
        this.indexingByteLength = indexingByteLength;
        this.indexingCharLength = indexingCharLength;
    }

    public String toString() {
        return "indexed at " + this.indexingFileStamp + " with document " + IndexingStampInfo.dumpSize(this.indexingByteLength, this.indexingCharLength);
    }

    @NotNull
    static String dumpSize(long byteLength, int charLength) {
        return " byte size = " + byteLength + ", char size = " + charLength;
    }

    public boolean isUpToDate(@Nullable Document document, @NotNull VirtualFile file2, @NotNull PsiFile psi) {
        if (document == null || FileDocumentManager.getInstance().isDocumentUnsaved(document) || !PsiDocumentManager.getInstance((Project)psi.getProject()).isCommitted(document)) {
            return false;
        }
        return this.indexingFileStamp == file2.getTimeStamp() && this.contentLengthMatches(file2.getLength(), document.getTextLength());
    }

    public boolean contentLengthMatches(long byteContentLength, int charContentLength) {
        if (this.indexingCharLength >= 0 && charContentLength >= 0) {
            return this.indexingCharLength == charContentLength;
        }
        return this.indexingByteLength == byteContentLength;
    }
}

