/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.FileTypeMapReduceIndex;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.SubstitutedFileType;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileTypeKeyDescriptor
implements KeyDescriptor<FileType> {
    private final NotNullLazyValue<FileTypeMapReduceIndex> myIndex = new NotNullLazyValue<FileTypeMapReduceIndex>(){

        @NotNull
        protected FileTypeMapReduceIndex compute() {
            return (FileTypeMapReduceIndex)((FileBasedIndexImpl)FileBasedIndex.getInstance()).getIndex(FileTypeIndex.NAME);
        }
    };

    FileTypeKeyDescriptor() {
    }

    public int getHashCode(FileType value2) {
        return value2.getName().hashCode();
    }

    public boolean isEqual(FileType val1, FileType val2) {
        if (val1 instanceof SubstitutedFileType) {
            val1 = ((SubstitutedFileType)val1).getFileType();
        }
        if (val2 instanceof SubstitutedFileType) {
            val2 = ((SubstitutedFileType)val2).getFileType();
        }
        if (val1 instanceof OutDatedFileType || val2 instanceof OutDatedFileType) {
            return Objects.equals(val1.getName(), val2.getName());
        }
        return Comparing.equal((Object)val1, (Object)val2);
    }

    public void save(@NotNull DataOutput out, FileType value2) throws IOException {
        DataInputOutputUtil.writeINT((DataOutput)out, (int)this.getFileTypeId(value2.getName()));
    }

    public FileType read(@NotNull DataInput in) throws IOException {
        String read = this.getFileTypeName(DataInputOutputUtil.readINT((DataInput)in));
        FileType fileType = FileTypeRegistry.getInstance().findFileTypeByName(read);
        return fileType == null ? new OutDatedFileType(read) : fileType;
    }

    int getFileTypeId(@NotNull String fileTypeName) throws IOException {
        return ((FileTypeMapReduceIndex)this.myIndex.getValue()).getFileTypeId(fileTypeName);
    }

    String getFileTypeName(int fileTypeId) throws IOException {
        return ((FileTypeMapReduceIndex)this.myIndex.getValue()).getFileTypeName(fileTypeId);
    }

    private static class OutDatedFileType
    implements FileType {
        @NotNull
        private final String myName;

        private OutDatedFileType(@NotNull String name) {
            this.myName = name;
        }

        @NotNull
        public String getName() {
            return this.myName;
        }

        @NotNull
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public String getDefaultExtension() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public Icon getIcon() {
            throw new UnsupportedOperationException();
        }

        public boolean isBinary() {
            throw new UnsupportedOperationException();
        }

        public boolean isReadOnly() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public String getCharset(@NotNull VirtualFile file2, byte @NotNull [] content2) {
            throw new UnsupportedOperationException();
        }
    }
}

