/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiRecursiveVisitor;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.util.WalkingState;
import org.jetbrains.annotations.NotNull;

public abstract class RecursiveTreeElementWalkingVisitor
extends TreeElementVisitor
implements PsiRecursiveVisitor {
    private final boolean myDoTransform;
    private final WalkingState<ASTNode> myWalkingState = new WalkingState<ASTNode>((WalkingState.TreeGuide)ASTTreeGuide.access$000()){

        public void elementFinished(@NotNull ASTNode element2) {
            RecursiveTreeElementWalkingVisitor.this.elementFinished(element2);
        }

        public void visit(@NotNull ASTNode element2) {
            ((TreeElement)element2).acceptTree(RecursiveTreeElementWalkingVisitor.this);
        }
    };

    protected RecursiveTreeElementWalkingVisitor() {
        this(true);
    }

    protected RecursiveTreeElementWalkingVisitor(boolean doTransform) {
        this.myDoTransform = doTransform;
    }

    protected void elementFinished(@NotNull ASTNode element2) {
    }

    @Override
    public void visitLeaf(LeafElement leaf) {
        this.visitNode(leaf);
    }

    @Override
    public void visitComposite(CompositeElement composite) {
        this.visitNode(composite);
    }

    protected void visitNode(TreeElement element2) {
        if (this.myDoTransform || !TreeUtil.isCollapsedChameleon(element2)) {
            this.myWalkingState.elementStarted((Object)element2);
        }
    }

    public void stopWalking() {
        this.myWalkingState.stopWalking();
    }

    private static class ASTTreeGuide
    implements WalkingState.TreeGuide<ASTNode> {
        private static final ASTTreeGuide instance = new ASTTreeGuide();

        private ASTTreeGuide() {
        }

        public ASTNode getNextSibling(@NotNull ASTNode element2) {
            return element2.getTreeNext();
        }

        public ASTNode getPrevSibling(@NotNull ASTNode element2) {
            return element2.getTreePrev();
        }

        public ASTNode getFirstChild(@NotNull ASTNode element2) {
            return element2.getFirstChildNode();
        }

        public ASTNode getParent(@NotNull ASTNode element2) {
            return element2.getTreeParent();
        }

        static /* synthetic */ ASTTreeGuide access$000() {
            return instance;
        }
    }
}

