/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FCTSBackedLighterAST;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.TreeBackedLighterAST;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.StackOverflowPreventedException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.AstSpine;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILightStubFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.CharTable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FileElement
extends LazyParseableElement
implements FileASTNode,
Getter<FileElement> {
    public static final FileElement[] EMPTY_ARRAY = new FileElement[0];
    private volatile CharTable myCharTable = new CharTableImpl();
    private volatile boolean myDetached;
    private volatile AstSpine myStubbedSpine;

    @Override
    protected PsiElement createPsiNoLock() {
        return this.myDetached ? null : super.createPsiNoLock();
    }

    public void detachFromFile() {
        this.myDetached = true;
        this.clearPsi();
    }

    @NotNull
    public CharTable getCharTable() {
        return this.myCharTable;
    }

    @NotNull
    public LighterAST getLighterAST() {
        IElementType contentType = this.getElementType();
        if (!this.isParsed() && contentType instanceof ILightStubFileElementType) {
            return new FCTSBackedLighterAST(this.getCharTable(), ((ILightStubFileElementType)contentType).parseContentsLight(this));
        }
        return new TreeBackedLighterAST((FileASTNode)this);
    }

    public FileElement(@NotNull IElementType type, CharSequence text) {
        super(type, text);
    }

    @Override
    public PsiManagerEx getManager() {
        CompositeElement treeParent = this.getTreeParent();
        if (treeParent != null) {
            return treeParent.getManager();
        }
        PsiElement psi = this.getPsi();
        if (psi == null) {
            throw PsiInvalidElementAccessException.createByNode((ASTNode)this, null);
        }
        return (PsiManagerEx)psi.getManager();
    }

    @Override
    public ASTNode copyElement() {
        PsiFileImpl psiElement = (PsiFileImpl)this.getPsi();
        PsiFileImpl psiElementCopy = (PsiFileImpl)psiElement.copy();
        return psiElementCopy.getTreeElement();
    }

    public void setCharTable(@NotNull CharTable table) {
        this.myCharTable = table;
    }

    public FileElement get() {
        return this;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myStubbedSpine = null;
    }

    @NotNull
    public final AstSpine getStubbedSpine() {
        AstSpine result2 = this.myStubbedSpine;
        if (result2 == null) {
            PsiFileImpl file2 = (PsiFileImpl)this.getPsi();
            IStubFileElementType type = file2.getElementTypeForStubBuilder();
            if (type == null) {
                return AstSpine.EMPTY_SPINE;
            }
            result2 = (AstSpine)RecursionManager.doPreventingRecursion((Object)file2, (boolean)false, () -> new AstSpine(this.calcStubbedDescendants(type.getBuilder())));
            if (result2 == null) {
                throw new StackOverflowPreventedException("Endless recursion prevented");
            }
            this.myStubbedSpine = result2;
        }
        return result2;
    }

    private List<CompositeElement> calcStubbedDescendants(final StubBuilder builder2) {
        final ArrayList<CompositeElement> result2 = new ArrayList<CompositeElement>();
        result2.add(this);
        this.acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            public void visitComposite(CompositeElement node) {
                CompositeElement parent = node.getTreeParent();
                if (parent != null && builder2.skipChildProcessingWhenBuildingStubs((ASTNode)parent, (ASTNode)node)) {
                    return;
                }
                IElementType type = node.getElementType();
                if (type instanceof IStubElementType && ((IStubElementType)type).shouldCreateStub((ASTNode)node)) {
                    result2.add(node);
                }
                super.visitNode(node);
            }
        });
        return result2;
    }
}

