/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.annotations.NotNull;

public class ASTStructure
implements FlyweightCapableTreeStructure<ASTNode> {
    private final ASTNode myRoot;

    public ASTStructure(@NotNull ASTNode root) {
        this.myRoot = root;
    }

    @NotNull
    public ASTNode getRoot() {
        return this.myRoot;
    }

    public ASTNode getParent(@NotNull ASTNode node) {
        return node.getTreeParent();
    }

    public int getChildren(@NotNull ASTNode astNode, @NotNull Ref<ASTNode[]> into) {
        ASTNode child2 = astNode.getFirstChildNode();
        if (child2 == null) {
            return 0;
        }
        ASTNode[] store = (ASTNode[])into.get();
        if (store == null) {
            store = new ASTNode[10];
            into.set((Object)store);
        }
        int count = 0;
        while (child2 != null) {
            if (count >= store.length) {
                ASTNode[] newStore = new ASTNode[count * 3 / 2];
                System.arraycopy(store, 0, newStore, 0, count);
                into.set((Object)newStore);
                store = newStore;
            }
            store[count++] = child2;
            child2 = child2.getTreeNext();
        }
        return count;
    }

    public void disposeChildren(ASTNode[] nodes, int count) {
    }

    @NotNull
    public CharSequence toString(@NotNull ASTNode node) {
        return node.getChars();
    }

    public int getStartOffset(@NotNull ASTNode node) {
        return node.getStartOffset();
    }

    public int getEndOffset(@NotNull ASTNode node) {
        return node.getStartOffset() + node.getTextLength();
    }
}

