/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileTargetContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public final class JpsFileTargetContextUtils {
    private JpsFileTargetContextUtils() {
    }

    @NotNull
    public static Collection<FileTargetContext> prepareTargetContexts(@NotNull Project project, @NotNull VirtualFile file2, @NotNull Collection<FileTargetContext> targetContexts) {
        if (targetContexts.size() <= 1) {
            return targetContexts;
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
        boolean isInSources = projectFileIndex.isInSourceContent(file2) && !projectFileIndex.isInTestSourceContent(file2);
        List targetContextWrappers = ContainerUtil.filter(JpsFileTargetContextUtils.findSourceRootTypes(targetContexts), tc -> {
            if (isInSources && tc.getSourceRootType() != null && tc.getSourceRootType().isForTests()) {
                return false;
            }
            if (tc.getJpsModuleSourceRoot() == null) {
                return true;
            }
            JavaSourceRootProperties srcProperties = (JavaSourceRootProperties)tc.getJpsModuleSourceRoot().getProperties(JavaModuleSourceRootTypes.SOURCES);
            if (srcProperties == null) {
                return true;
            }
            return !srcProperties.isForGeneratedSources();
        });
        if (JpsFileTargetContextUtils.hasEqualSourceRootTypes(targetContextWrappers)) {
            return targetContexts;
        }
        if (projectFileIndex.isInTestSourceContent(file2)) {
            targetContextWrappers.sort(JpsFileTargetContextUtils::compareTargetsForTests);
        } else {
            targetContextWrappers.sort(JpsFileTargetContextUtils::compareTargetsForProduction);
        }
        return ContainerUtil.map((Collection)targetContextWrappers, FileTargetContextWrapper::getTargetContext);
    }

    private static boolean hasEqualSourceRootTypes(@NotNull List<FileTargetContextWrapper> wrappers) {
        if (wrappers.size() <= 1) {
            return true;
        }
        JpsModuleSourceRootType<?> sourceRootType = null;
        for (FileTargetContextWrapper item : wrappers) {
            JpsModuleSourceRootType<?> itemSourceRootType = item.getSourceRootType();
            if (sourceRootType == null) {
                if (itemSourceRootType == null) continue;
                sourceRootType = itemSourceRootType;
                continue;
            }
            if (sourceRootType == itemSourceRootType) continue;
            return false;
        }
        return true;
    }

    private static List<FileTargetContextWrapper> findSourceRootTypes(Collection<FileTargetContext> targetContexts) {
        return ContainerUtil.map(targetContexts, c -> {
            Project project = c.getFileSystemItem().getProject();
            SourceFolder sourceFolder = null;
            VirtualFile file2 = c.getFileSystemItem().getVirtualFile();
            if (file2 != null) {
                sourceFolder = JpsFileTargetContextUtils.getSourceFolder(project, file2);
            }
            return new FileTargetContextWrapper((FileTargetContext)c, sourceFolder);
        });
    }

    @Nullable
    private static SourceFolder getSourceFolder(@NotNull Project project, @NotNull VirtualFile directory) {
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
        return projectFileIndex.getSourceFolder(directory);
    }

    private static int compareTargetsForTests(@NotNull FileTargetContextWrapper d1, @NotNull FileTargetContextWrapper d2) {
        int o1 = JpsFileTargetContextUtils.getTestsTargetOrdinal(d1);
        int o2 = JpsFileTargetContextUtils.getTestsTargetOrdinal(d2);
        if (o1 > 0 && o2 > 0) {
            return Integer.compare(o1, o2);
        }
        return JpsFileTargetContextUtils.compareDirectoryPaths(d1, d2);
    }

    private static int compareTargetsForProduction(@NotNull FileTargetContextWrapper d1, @NotNull FileTargetContextWrapper d2) {
        int o1 = JpsFileTargetContextUtils.getSourcesTargetOrdinal(d1);
        int o2 = JpsFileTargetContextUtils.getSourcesTargetOrdinal(d2);
        if (o1 > 0 && o2 > 0) {
            return Integer.compare(o1, o2);
        }
        return JpsFileTargetContextUtils.compareDirectoryPaths(d1, d2);
    }

    private static int getTestsTargetOrdinal(@NotNull FileTargetContextWrapper item) {
        JpsModuleSourceRootType<?> type = item.getSourceRootType();
        if (JpsFileTargetContextUtils.isSourceItem(type)) {
            return 4;
        }
        if (JpsFileTargetContextUtils.isTestSourceItem(type)) {
            return 3;
        }
        if (JpsFileTargetContextUtils.isResourceItem(type)) {
            return 2;
        }
        if (JpsFileTargetContextUtils.isTestResourceItem(type)) {
            return 1;
        }
        return 0;
    }

    private static int getSourcesTargetOrdinal(@NotNull FileTargetContextWrapper item) {
        JpsModuleSourceRootType<?> type = item.getSourceRootType();
        if (JpsFileTargetContextUtils.isTestSourceItem(type)) {
            return 4;
        }
        if (JpsFileTargetContextUtils.isSourceItem(type)) {
            return 3;
        }
        if (JpsFileTargetContextUtils.isTestResourceItem(type)) {
            return 2;
        }
        if (JpsFileTargetContextUtils.isResourceItem(type)) {
            return 1;
        }
        return 0;
    }

    private static int compareDirectoryPaths(@NotNull FileTargetContextWrapper d1, @NotNull FileTargetContextWrapper d2) {
        PsiFileSystemItem directory1 = d1.getTargetContext().getFileSystemItem();
        PsiFileSystemItem directory2 = d2.getTargetContext().getFileSystemItem();
        assert (directory1 != null) : "Invalid PsiFileSystemItem instances found";
        assert (directory2 != null) : "Invalid PsiFileSystemItem instances found";
        VirtualFile f1 = directory1.getVirtualFile();
        VirtualFile f2 = directory2.getVirtualFile();
        return f1.getPath().compareTo(f2.getPath());
    }

    private static boolean isTestResourceItem(@Nullable JpsModuleSourceRootType<?> type) {
        return type == JavaResourceRootType.TEST_RESOURCE;
    }

    private static boolean isResourceItem(@Nullable JpsModuleSourceRootType<?> type) {
        return type == JavaResourceRootType.RESOURCE;
    }

    private static boolean isTestSourceItem(@Nullable JpsModuleSourceRootType<?> type) {
        return type == JavaSourceRootType.TEST_SOURCE;
    }

    private static boolean isSourceItem(@Nullable JpsModuleSourceRootType<?> type) {
        return type == JavaSourceRootType.SOURCE;
    }

    private static class FileTargetContextWrapper {
        private final FileTargetContext myTargetContext;
        private final SourceFolder mySourceFolder;

        private FileTargetContextWrapper(FileTargetContext context, @Nullable SourceFolder sourceFolder) {
            this.myTargetContext = context;
            this.mySourceFolder = sourceFolder;
        }

        public FileTargetContext getTargetContext() {
            return this.myTargetContext;
        }

        @Nullable
        public JpsModuleSourceRootType<?> getSourceRootType() {
            return this.mySourceFolder != null ? this.mySourceFolder.getRootType() : null;
        }

        public JpsModuleSourceRoot getJpsModuleSourceRoot() {
            return this.mySourceFolder != null ? this.mySourceFolder.getJpsElement() : null;
        }
    }
}

