/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.FileContextProvider;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.CustomizableReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelperRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceResolver;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileTargetContext;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileReferenceSet {
    private static final Logger LOG = Logger.getInstance(FileReferenceSet.class);
    private static final FileType[] EMPTY_FILE_TYPES = new FileType[0];
    public static final CustomizableReferenceProvider.CustomizationKey<Function<PsiFile, Collection<PsiFileSystemItem>>> DEFAULT_PATH_EVALUATOR_OPTION = new CustomizableReferenceProvider.CustomizationKey(AnalysisBundle.message((String)"default.path.evaluator.option", (Object[])new Object[0]));
    public static final Function<PsiFile, Collection<PsiFileSystemItem>> ABSOLUTE_TOP_LEVEL = new AbsoluteTopLevelEvaluator();
    public static final Condition<PsiFileSystemItem> FILE_FILTER = item -> item instanceof PsiFile;
    public static final Condition<PsiFileSystemItem> DIRECTORY_FILTER = item -> item instanceof PsiDirectory;
    protected FileReference[] myReferences;
    private PsiElement myElement;
    private final int myStartInElement;
    private final boolean myCaseSensitive;
    private final String myPathStringNonTrimmed;
    private final String myPathString;
    private volatile Collection<PsiFileSystemItem> myDefaultContexts;
    private final boolean myEndingSlashNotAllowed;
    private boolean myEmptyPathAllowed;
    @Nullable
    private Map<CustomizableReferenceProvider.CustomizationKey, Object> myOptions;
    private FileType @Nullable [] mySuitableFileTypes;

    public FileReferenceSet(@NotNull String str, @NotNull PsiElement element2, int startInElement, PsiReferenceProvider provider, boolean caseSensitive, boolean endingSlashNotAllowed, FileType @Nullable [] suitableFileTypes) {
        this(str, element2, startInElement, provider, caseSensitive, endingSlashNotAllowed, suitableFileTypes, true);
    }

    public FileReferenceSet(@NotNull String str, @NotNull PsiElement element2, int startInElement, PsiReferenceProvider provider, boolean caseSensitive, boolean endingSlashNotAllowed, FileType @Nullable [] suitableFileTypes, boolean init2) {
        this.myElement = element2;
        this.myStartInElement = startInElement;
        this.myCaseSensitive = caseSensitive;
        this.myPathStringNonTrimmed = str;
        this.myPathString = str.trim();
        this.myEndingSlashNotAllowed = endingSlashNotAllowed;
        this.myEmptyPathAllowed = !endingSlashNotAllowed;
        this.myOptions = provider instanceof CustomizableReferenceProvider ? ((CustomizableReferenceProvider)provider).getOptions() : null;
        this.mySuitableFileTypes = suitableFileTypes;
        if (init2) {
            this.reparse();
        }
    }

    protected String getNewAbsolutePath(PsiFileSystemItem root, String relativePath) {
        return this.absoluteUrlNeedsStartSlash() ? "/" + relativePath : relativePath;
    }

    public String getSeparatorString() {
        return "/";
    }

    protected int findSeparatorLength(@NotNull CharSequence sequence, int atOffset) {
        return StringUtil.startsWith((CharSequence)sequence, (int)atOffset, (CharSequence)this.getSeparatorString()) ? this.getSeparatorString().length() : 0;
    }

    protected int findSeparatorOffset(@NotNull CharSequence sequence, int startingFrom) {
        return StringUtil.indexOf((CharSequence)sequence, (CharSequence)this.getSeparatorString(), (int)startingFrom);
    }

    @Deprecated
    protected Collection<PsiFileSystemItem> getExtraContexts() {
        return Collections.emptyList();
    }

    public static FileReferenceSet createSet(@NotNull PsiElement element2, final boolean soft, boolean endingSlashNotAllowed, final boolean urlEncoded) {
        TextRange range2 = ElementManipulators.getValueTextRange((PsiElement)element2);
        int offset = range2.getStartOffset();
        String text = range2.substring(element2.getText());
        for (FileReferenceHelper helper : FileReferenceHelperRegistrar.getHelpers()) {
            text = helper.trimUrl(text);
        }
        return new FileReferenceSet(text, element2, offset, null, true, endingSlashNotAllowed){

            @Override
            protected boolean isUrlEncoded() {
                return urlEncoded;
            }

            @Override
            protected boolean isSoft() {
                return soft;
            }
        };
    }

    public FileReferenceSet(String str, @NotNull PsiElement element2, int startInElement, @Nullable PsiReferenceProvider provider, boolean isCaseSensitive) {
        this(str, element2, startInElement, provider, isCaseSensitive, true);
    }

    public FileReferenceSet(@NotNull String str, @NotNull PsiElement element2, int startInElement, PsiReferenceProvider provider, boolean isCaseSensitive, boolean endingSlashNotAllowed) {
        this(str, element2, startInElement, provider, isCaseSensitive, endingSlashNotAllowed, null);
    }

    public FileReferenceSet(@NotNull PsiElement element2) {
        this.myElement = element2;
        TextRange range2 = ElementManipulators.getValueTextRange((PsiElement)element2);
        this.myStartInElement = range2.getStartOffset();
        this.myPathStringNonTrimmed = range2.substring(element2.getText());
        this.myPathString = this.myPathStringNonTrimmed.trim();
        this.myEndingSlashNotAllowed = true;
        this.myCaseSensitive = false;
        this.reparse();
    }

    @NotNull
    public PsiElement getElement() {
        return this.myElement;
    }

    void setElement(@NotNull PsiElement element2) {
        this.myElement = element2;
    }

    public boolean isCaseSensitive() {
        return this.myCaseSensitive;
    }

    public boolean isEndingSlashNotAllowed() {
        return this.myEndingSlashNotAllowed;
    }

    public int getStartInElement() {
        return this.myStartInElement;
    }

    @Nullable
    public FileReference createFileReference(TextRange range2, int index, String text) {
        return new FileReference(this, range2, index, text);
    }

    protected void reparse() {
        List<FileReference> referencesList = this.reparse(this.myPathStringNonTrimmed, this.myStartInElement);
        this.myReferences = referencesList.toArray(FileReference.EMPTY);
    }

    protected List<FileReference> reparse(String str, int startInElement) {
        TextRange r;
        FileReference reference2;
        int sepLen;
        int i2;
        CharSequence decoded;
        TextRange valueRange;
        LiteralTextEscaper escaper;
        int wsHead = 0;
        int wsTail = 0;
        if (this.myElement instanceof PsiLanguageInjectionHost && !StringUtil.startsWith((CharSequence)this.myElement.getText(), (int)startInElement, (CharSequence)str)) {
            escaper = ((PsiLanguageInjectionHost)this.myElement).createLiteralTextEscaper();
            valueRange = ElementManipulators.getValueTextRange((PsiElement)this.myElement);
            StringBuilder sb = new StringBuilder();
            escaper.decode(valueRange, sb);
            decoded = sb;
            wsHead += Math.max(0, startInElement - valueRange.getStartOffset());
        } else {
            escaper = null;
            decoded = str;
            valueRange = TextRange.from((int)startInElement, (int)decoded.length());
        }
        ArrayList<FileReference> referencesList = new ArrayList<FileReference>();
        for (i2 = wsHead; i2 < decoded.length() && Character.isWhitespace(decoded.charAt(i2)); ++i2) {
            ++wsHead;
        }
        for (i2 = decoded.length() - 1; i2 >= 0 && Character.isWhitespace(decoded.charAt(i2)); --i2) {
            ++wsTail;
        }
        int index = 0;
        int curSep = this.findSeparatorOffset(decoded, wsHead);
        int n = sepLen = curSep >= wsHead ? this.findSeparatorLength(decoded, curSep) : 0;
        if (curSep >= 0 && decoded.length() == wsHead + sepLen + wsTail && (reference2 = this.createFileReference(r = TextRange.create((int)startInElement, (int)(FileReferenceSet.offset(curSep + Math.max(0, sepLen - 1), (LiteralTextEscaper<? extends PsiLanguageInjectionHost>)escaper, valueRange) + 1)), index++, decoded.subSequence(curSep, curSep + sepLen).toString())) != null) {
            referencesList.add(reference2);
        }
        curSep = curSep == wsHead ? curSep + sepLen : wsHead;
        sepLen = 0;
        while (curSep >= 0) {
            FileReference reference3;
            int refEnd;
            int nextSep = this.findSeparatorOffset(decoded, curSep + sepLen);
            int start2 = curSep + sepLen;
            int endTrimmed = nextSep > 0 ? nextSep : Math.max(start2, decoded.length() - wsTail);
            String refText = index == 0 && nextSep < 0 && !StringUtil.contains((CharSequence)decoded, (CharSequence)str) ? str : decoded.subSequence(start2, endTrimmed).toString();
            int refStart = FileReferenceSet.offset(start2, (LiteralTextEscaper<? extends PsiLanguageInjectionHost>)escaper, valueRange);
            if (refStart > (refEnd = FileReferenceSet.offset(endTrimmed, (LiteralTextEscaper<? extends PsiLanguageInjectionHost>)escaper, valueRange)) || refStart < 0) {
                LOG.error("Invalid range: (" + refText + ", " + refEnd + "), escaper=" + escaper + "\ntext=" + refText + ", start=" + startInElement);
            }
            if ((reference3 = this.createFileReference(new TextRange(refStart, refEnd), index++, refText)) != null) {
                referencesList.add(reference3);
            }
            sepLen = (curSep = nextSep) > 0 ? this.findSeparatorLength(decoded, curSep) : 0;
        }
        return referencesList;
    }

    private static int offset(int offset, LiteralTextEscaper<? extends PsiLanguageInjectionHost> escaper, TextRange valueRange) {
        return escaper == null ? offset + valueRange.getStartOffset() : escaper.getOffsetInHost(offset, valueRange);
    }

    public FileReference getReference(int index) {
        return this.myReferences[index];
    }

    public FileReference @NotNull [] getAllReferences() {
        return this.myReferences;
    }

    protected boolean isSoft() {
        return false;
    }

    protected boolean isUrlEncoded() {
        return false;
    }

    @NotNull
    public Collection<PsiFileSystemItem> getDefaultContexts() {
        Collection<PsiFileSystemItem> result2 = this.myDefaultContexts;
        if (result2 == null) {
            this.myDefaultContexts = result2 = this.computeDefaultContexts();
        }
        return result2;
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        PsiFile file2 = this.getContainingFile();
        if (file2 == null) {
            return Collections.emptyList();
        }
        Collection<PsiFileSystemItem> contexts = this.getCustomizationContexts(file2);
        if (contexts != null) {
            return contexts;
        }
        if (this.isAbsolutePathReference()) {
            return FileReferenceSet.getAbsoluteTopLevelDirLocations(file2);
        }
        return this.getContextByFile(file2);
    }

    @Nullable
    protected PsiFile getContainingFile() {
        PsiFile cf = this.myElement.getContainingFile();
        PsiFile file2 = InjectedLanguageManager.getInstance((Project)cf.getProject()).getTopLevelFile((PsiElement)cf);
        if (file2 != null) {
            return file2.getOriginalFile();
        }
        LOG.error("Invalid element: " + this.myElement);
        return null;
    }

    @NotNull
    private Collection<PsiFileSystemItem> getContextByFile(@NotNull PsiFile file2) {
        Collection<PsiFileSystemItem> folders;
        PsiElement context = file2.getContext();
        if (context != null) {
            file2 = context.getContainingFile();
        }
        if ((folders = this.getIncludingFileContexts(file2)) != null) {
            return folders;
        }
        return this.getContextByFileSystemItem((PsiFileSystemItem)file2.getOriginalFile());
    }

    @NotNull
    protected Collection<PsiFileSystemItem> getContextByFileSystemItem(@NotNull PsiFileSystemItem file2) {
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile != null) {
            FileReferenceHelper[] helpers = FileReferenceHelperRegistrar.getHelpers();
            ArrayList<PsiFileSystemItem> list2 = new ArrayList<PsiFileSystemItem>();
            Project project = file2.getProject();
            boolean hasRealContexts = false;
            for (FileReferenceHelper helper : helpers) {
                if (!helper.isMine(project, virtualFile) || !list2.isEmpty() && helper.isFallback()) continue;
                Collection<PsiFileSystemItem> contexts = helper.getContexts(project, virtualFile);
                for (PsiFileSystemItem context : contexts) {
                    list2.add(context);
                    hasRealContexts |= !(context instanceof FileReferenceResolver);
                }
            }
            if (!list2.isEmpty()) {
                if (!hasRealContexts) {
                    list2.addAll(this.getParentDirectoryContext());
                }
                return list2;
            }
            return this.getParentDirectoryContext();
        }
        return Collections.emptyList();
    }

    @Nullable
    private Collection<PsiFileSystemItem> getIncludingFileContexts(@NotNull PsiFile file2) {
        FileContextProvider contextProvider;
        if (this.useIncludingFileAsContext() && (contextProvider = FileContextProvider.getProvider((PsiFile)file2)) != null) {
            Collection folders = contextProvider.getContextFolders(file2);
            if (!folders.isEmpty()) {
                return folders;
            }
            PsiFile contextFile = contextProvider.getContextFile(file2);
            if (contextFile != null && contextFile.getParent() != null) {
                return Collections.singletonList(contextFile.getParent());
            }
        }
        return null;
    }

    @NotNull
    protected Collection<PsiFileSystemItem> getParentDirectoryContext() {
        PsiFile file2 = this.getContainingFile();
        VirtualFile virtualFile = file2 == null ? null : file2.getOriginalFile().getVirtualFile();
        VirtualFile parent = virtualFile == null ? null : virtualFile.getParent();
        PsiDirectory directory = parent == null ? null : file2.getManager().findDirectory(parent);
        return directory != null ? Collections.singleton(directory) : Collections.emptyList();
    }

    public Collection<FileTargetContext> getTargetContexts() {
        PsiFile file2 = this.getContainingFile();
        if (file2 == null) {
            return Collections.emptyList();
        }
        Collection<FileTargetContext> customizationContexts = this.getTargetCustomizationContexts(file2);
        Collection<FileTargetContext> targetContexts = customizationContexts != null ? customizationContexts : this.getTargetContextByFile(file2);
        return FileReferenceSet.filterLocalFsContexts(targetContexts);
    }

    private static Collection<FileTargetContext> filterLocalFsContexts(Collection<FileTargetContext> contexts) {
        return ContainerUtil.filter(contexts, c -> {
            VirtualFile file2 = c.getFileSystemItem().getVirtualFile();
            return file2 != null && c.getFileSystemItem().isDirectory() && file2.isInLocalFileSystem();
        });
    }

    @Nullable
    private Collection<PsiFileSystemItem> getCustomizationContexts(PsiFile file2) {
        Collection roots;
        Function<PsiFile, Collection<PsiFileSystemItem>> value2;
        if (this.myOptions != null && (value2 = DEFAULT_PATH_EVALUATOR_OPTION.getValue(this.myOptions)) != null && (roots = (Collection)value2.fun((Object)file2)) != null) {
            for (PsiFileSystemItem root : roots) {
                if (root != null) continue;
                LOG.error("Default path evaluator " + value2 + " produced a null root for " + file2);
            }
            return roots;
        }
        return null;
    }

    @Nullable
    private Collection<FileTargetContext> getTargetCustomizationContexts(@NotNull PsiFile file2) {
        Function<PsiFile, Collection<PsiFileSystemItem>> value2;
        if (this.myOptions != null && (value2 = DEFAULT_PATH_EVALUATOR_OPTION.getValue(this.myOptions)) != null) {
            Collection items;
            Collection<FileTargetContext> roots = value2 instanceof TargetContextEvaluator ? ((TargetContextEvaluator)value2).getTargetContexts(file2) : ((items = (Collection)value2.fun((Object)file2)) != null ? FileTargetContext.toTargetContexts(items) : Collections.emptyList());
            return roots;
        }
        return null;
    }

    @NotNull
    private Collection<FileTargetContext> getTargetContextByFile(@NotNull PsiFile file2) {
        PsiDirectory parent;
        boolean absolutePathReference = this.isAbsolutePathReference();
        if (!absolutePathReference) {
            Collection<PsiFileSystemItem> folders;
            PsiElement context = file2.getContext();
            if (context != null) {
                file2 = context.getContainingFile();
            }
            if ((folders = this.getIncludingFileContexts(file2)) != null) {
                return FileTargetContext.toTargetContexts(folders);
            }
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((parent = file2.getParent()) == null ? file2 : parent));
        if (absolutePathReference && module == null) {
            return Collections.emptyList();
        }
        PsiFile originalFile = file2.getOriginalFile();
        VirtualFile virtualFile = originalFile.getVirtualFile();
        if (virtualFile == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<FileTargetContext> list2 = new LinkedHashSet<FileTargetContext>();
        Project project = originalFile.getProject();
        boolean hasRealContexts = false;
        FileReferenceHelper[] helpers = FileReferenceHelperRegistrar.getHelpers();
        for (FileReferenceHelper helper : helpers) {
            if (!helper.isMine(project, virtualFile) || !list2.isEmpty() && helper.isFallback()) continue;
            Collection<FileTargetContext> contexts = helper.getTargetContexts(project, virtualFile, absolutePathReference);
            for (FileTargetContext context : contexts) {
                list2.add(context);
                hasRealContexts |= !(context.getFileSystemItem() instanceof FileReferenceResolver);
            }
        }
        if (!list2.isEmpty()) {
            if (!hasRealContexts) {
                for (PsiFileSystemItem item : this.getParentDirectoryContext()) {
                    list2.add(new FileTargetContext(item));
                }
            }
            return list2;
        }
        return FileTargetContext.toTargetContexts(this.getParentDirectoryContext());
    }

    public String getPathString() {
        return this.myPathString;
    }

    public boolean isAbsolutePathReference() {
        return this.myPathString.startsWith(this.getSeparatorString());
    }

    protected boolean useIncludingFileAsContext() {
        return true;
    }

    @Nullable
    public PsiFileSystemItem resolve() {
        FileReference lastReference = this.getLastReference();
        return lastReference == null ? null : lastReference.resolve();
    }

    @Nullable
    public FileReference getLastReference() {
        return this.myReferences == null || this.myReferences.length == 0 ? null : this.myReferences[this.myReferences.length - 1];
    }

    @NotNull
    public static Collection<PsiFileSystemItem> getAbsoluteTopLevelDirLocations(@NotNull PsiFile file2) {
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return Collections.emptyList();
        }
        PsiDirectory parent = file2.getParent();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)(parent == null ? file2 : parent));
        if (module == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<PsiFileSystemItem> result2 = new LinkedHashSet<PsiFileSystemItem>();
        Project project = file2.getProject();
        for (FileReferenceHelper helper : FileReferenceHelperRegistrar.getHelpers()) {
            if (!helper.isMine(project, virtualFile) || helper.isFallback() && !result2.isEmpty()) continue;
            Collection<PsiFileSystemItem> roots = helper.getRoots(module, virtualFile);
            for (PsiFileSystemItem root : roots) {
                if (root != null) continue;
                LOG.error("Helper " + helper + " produced a null root for " + file2);
            }
            result2.addAll(roots);
        }
        return new ArrayList<PsiFileSystemItem>(result2);
    }

    @NotNull
    private static Collection<FileTargetContext> getTargetAbsoluteTopLevelContexts(@NotNull PsiFile file2) {
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return Collections.emptyList();
        }
        PsiDirectory parent = file2.getParent();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)(parent == null ? file2 : parent));
        if (module == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<FileTargetContext> result2 = new LinkedHashSet<FileTargetContext>();
        Project project = file2.getProject();
        for (FileReferenceHelper helper : FileReferenceHelperRegistrar.getHelpers()) {
            if (!helper.isMine(project, virtualFile) || helper.isFallback() && !result2.isEmpty()) continue;
            Collection<FileTargetContext> roots = helper.getTargetContexts(project, virtualFile, true);
            result2.addAll(roots);
        }
        return new ArrayList<FileTargetContext>(result2);
    }

    @NotNull
    protected Collection<PsiFileSystemItem> toFileSystemItems(VirtualFile ... files2) {
        return this.toFileSystemItems(Arrays.asList(files2));
    }

    @NotNull
    protected Collection<PsiFileSystemItem> toFileSystemItems(@NotNull Collection<? extends VirtualFile> files2) {
        PsiManager manager = this.getElement().getManager();
        return ContainerUtil.mapNotNull(files2, (Function)((NullableFunction)file2 -> file2 != null && file2.isValid() ? manager.findDirectory(file2) : null));
    }

    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        return Conditions.alwaysTrue();
    }

    public <Option> void addCustomization(CustomizableReferenceProvider.CustomizationKey<Option> key, Option value2) {
        if (this.myOptions == null) {
            this.myOptions = new HashMap<CustomizableReferenceProvider.CustomizationKey, Object>(5);
        }
        this.myOptions.put(key, value2);
    }

    public boolean couldBeConvertedTo(boolean relative) {
        return true;
    }

    public boolean absoluteUrlNeedsStartSlash() {
        return true;
    }

    public FileType @NotNull [] getSuitableFileTypes() {
        return this.mySuitableFileTypes == null ? EMPTY_FILE_TYPES : this.mySuitableFileTypes;
    }

    public boolean isEmptyPathAllowed() {
        return this.myEmptyPathAllowed;
    }

    public void setEmptyPathAllowed(boolean emptyPathAllowed) {
        this.myEmptyPathAllowed = emptyPathAllowed;
    }

    public boolean supportsExtendedCompletion() {
        return true;
    }

    private static class AbsoluteTopLevelEvaluator
    implements Function<PsiFile, Collection<PsiFileSystemItem>>,
    TargetContextEvaluator {
        private AbsoluteTopLevelEvaluator() {
        }

        @Override
        @NotNull
        public Collection<FileTargetContext> getTargetContexts(@NotNull PsiFile file2) {
            return FileReferenceSet.getTargetAbsoluteTopLevelContexts(file2);
        }

        public Collection<PsiFileSystemItem> fun(PsiFile file2) {
            return FileReferenceSet.getAbsoluteTopLevelDirLocations(file2);
        }
    }

    public static interface TargetContextEvaluator {
        @NotNull
        public Collection<FileTargetContext> getTargetContexts(@NotNull PsiFile var1);
    }
}

